#import "MyPersistentObjectTest.h"

#import "MyPersistentObject.h"
#import <ObjcUnit/MockObjects.h>

@implementation MyPersistentObjectTest

- (void)testEncoding {
    MyPersistentObject *myObject = [[[MyPersistentObject alloc] init] autorelease];
    MockCoder *mockCoder = [[[MockCoder alloc] init] autorelease];
    
    [myObject setName:@"My Persistent One"];
    [myObject setAmount:[NSNumber numberWithFloat:412.32]];

    [mockCoder addExpectedEncodedObject:@"My Persistent One"];
    [mockCoder addExpectedEncodedObject:[NSNumber numberWithFloat:412.32]];

    [myObject encodeWithCoder:mockCoder];
    
    [mockCoder verify];
}

- (void)testDecoding {
    MockCoder *mockCoder = [[[MockCoder alloc] init] autorelease];
    MyPersistentObject *myObject;

    [mockCoder addDecodedObject:@"Another Persistent Thing"];
    [mockCoder addDecodedObject:[NSNumber numberWithFloat:141.99]];

    myObject = [[[MyPersistentObject alloc] initWithCoder:mockCoder] autorelease];

    [mockCoder verify];

    [self assertString:[myObject name] equals:@"Another Persistent Thing"];
    [self assert:[myObject amount] equals:[NSNumber numberWithFloat:141.99]];
}

@end
