/*
  Copyright (C) 2000-2007

  Code contributed by Greg Collecutt, Joseph Hope and the xmds-devel team

  This file is part of xmds.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  $Id: xmds_argv.h 1507 2007-08-15 09:47:34Z paultcochrane $
*/

/*! @file xmds_argv.h
  @brief 

  More detailed explanation...
*/

#ifndef XMDS_ARGV_H
#define XMDS_ARGV_H

#include <xmds_element.h>

// *****************************************************************************
// *****************************************************************************
//                              xmdsArgv
// *****************************************************************************
// *****************************************************************************

class xmdsArg;

class xmdsArgElement;

//! xmds argv class
/*!
  The class that handles command line arguments to xmds simulations.
  This is equivalent to the **argv array in C.
*/
class xmdsArgv : public xmdsElement {

  public :

    //! Constructor of xmdsArgv object
    xmdsArgv(
       const xmdsSimulation *const yourSimulation,
       const bool& yourVerboseMode);

  //! Destructor
  ~xmdsArgv();

  //! Processes the xmds element
  void processElement(
                      const Element *const yourElement);

  //! Processes the args in the argument names list
  void processArgs(
                   const list<XMLString>& argNamesList,
                   const unsigned long& space) const;

  //! Gets the arg?
  /*!
    Why does this return boolean if it gets the argument?
  */
  bool getArg(
              const XMLString& argName,
              const xmdsArg*& theArg) const;

  //! Returns the argument names in a list
  void argNames(
                list<XMLString>& argNamesList) const;

  //! Creates an xmds argument
  xmdsArg* createxmdsArg();

 protected:
  //! Writes the globals code to the output file
  void writeGlobals(
                    FILE *const outfile) const;

  private :

    list<const xmdsArg*>  myArgsList;       //!< The list of arguments

  //! Create an xmds argument element object
  xmdsArgElement* createxmdsArgElement();
};


#endif // XMDS_ARGV_H
