//   This program is free software: you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//   You should have received a copy of the GNU General Public License
//   along with this program.  If not, see <http://www.gnu.org/licenses/>
//   
//   
// @author : pascal.fautrero@ac-versailles.fr


/*
 * 
 */
function XiaDetail(detail, idText) {
    "use strict";
    
    var that = this;
    
    this.title = detail.title;
    this.path = "";
    this.kineticElement = null;
    this.persistent = "";
    this.options = "";
    this.backgroundImage = null;
    this.tooltip = null;
    this.draggable_object = true;
    this.target_id = null;
    this.magnet_state = null;
    this.droparea = false;
    this.idText = idText;
    
    if ((typeof(detail.options) !== 'undefined')) {
        this.options = detail.options;
    }
    
    if (this.options.indexOf("disable-click") != -1) {
        this.draggable_object = false;
    };  
    if ($('article[data-target="' + $("#" + idText).data("kinetic_id") + '"]').length != 0) {
        this.draggable_object = false;
    }    
    if ($('article[data-tooltip="' + $("#" + idText).data("kinetic_id") + '"]').length != 0) {
        this.draggable_object = false;
    }  
    
    this.target_id = $('#' + idText).data("target");
    this.magnet_state = $("#" + idText).data("magnet");

    if ($('article[data-target="' + $("#" + idText).data("kinetic_id") + '"]').length != 0) {
        this.droparea = true;
        
    }    
    
}
