'\" t
.TH "MultiList" "3" "19 May 1992" "Version 3.4" "Free Widget Foundation"
.SH Name
MultiList \- list from which multiple entries can be selected
.SH Synopsis
#include <X11/Intrinsic.h>
#include <X11/MultiList.h>

widget = XtCreateManagedWidget(name, multiListWidgetClass, ...);
.SH Class Hierarchy
Core-->Simple-->MultiList
.SH Description

MultiList is a replacement for the Athena List widget, which allows
multiple selections to be made.  The aesthetics have also been
slightly improved: the highlight colors can now be selected, and the
selection extends across the entire width of the column rather than
just the length of the string.

The maximum number of multiple selections can be specified.  Items are
selected and unselected by an action interface.  By default, mouse
button 1 is used to select, unselect, and toggle items.  When the
mouse button is lifted, any callbacks in the callback list are called
with a data structure which describes the count of select items, and
lists the indices of the selected items.  The return structure
contains some additional information describing the last item modified
and the last action performed, which will probably not be of general
use, and I'd love to delete if I was sure that people didn't use them.
(The behavior of these fields has changed slightly in V3.4).

.SH Resources
In addition to the resources defined by superclasses, this widget
defines the following:
.TS
tab(/) ;
lB lB lB lB.
Name/Class/Type/Default
.T&
lB l l l.
XtNbackground/Background/Pixel/XtDefaultBackground
XtNborder/BorderColor/Pixel/XtDefaultForeground
XtNborderWidth/BorderWidth/Dimension/1
XtNcallback/Callback/XtCallbackList/NULL
XtNcolumnWidth/Width/Dimension/0
XtNcolumnSpacing/Spacing/Dimension/8
XtNcursor/Cursor/Cursor/left_ptr
XtNdefaultColumns/Columns/int/1
XtNdestroyCallback/Callback/Pointer/NULL 
XtNfont/Font/XFontStruct/XtDefaultFont
XtNforceColumns/Columns/Boolean/False
XtNforeground/Foreground/Pixel/XtDefaultForeground
XtNheight/Height/Dimension/0
XtNhighlightBackground/HBackground/Pixel/XtDefaultForeground
XtNhighlightForeground/HForeground/Pixel/XtDefaultBackground
XtNinsensitiveBorder/Insensitive/Pixmap/Gray
XtNlist/List/String/NULL
XtNlongest/Longest/int/0
XtNmappedWhenManaged/MappedWhenManaged/Boolean/True
XtNmaxSelectable/Value/int/1
XtNnumberStrings/NumberStrings/int/0
XtNpasteBuffer/Boolean/Boolean/False
XtNrowHeight/Height/Dimension/0
XtNrowSpacing/Spacing/Dimension/2
XtNsensitive/Sensitive/Boolean/True
XtNsensitiveArray/List/Boolean/NULL
XtNtablist/String/String/NULL
XtNtabs/List/int/NULL
XtNverticalList/Boolean/Boolean/False
XtNwidth/Width/Dimension/0
XtNx/Position/Position/0
XtNy/Position/Position/0
.TE
.ne 4
.SH Public Functions
.nf
.ta 3i
void XfwfMultiListHighlightItem(mlw,item_index)
XfwfMultiListWidget mlw;
int item_index;
.fi
.sp
.RS 5
This routine selects an item with index <item_index> in the MultiList
widget <mlw>.  If a maximum number of selections is specified and
exceeded, the earliest selection will be unselected.  If <item_index>
doesn't correspond to an item the most recently clicked item will be
set to -1 and this routine will immediately return, otherwise the most
recently clicked item will be set to the current item.
.RE
.sp
.nf
void XfwfMultiListHighlightAll(mlw)
XfwfMultiListWidget mlw;
.fi
.sp
.RS 5
This routine highlights all highlightable items in the MultiList
widget <mlw>, up to the maximum number of allowed highlightable items;
.RE
.sp
.nf
void XfwfMultiListUnhighlightItem(mlw,item_index)
XfwfMultiListWidget mlw;
int item_index;
.fi
.sp
.RS 5
This routine unselects the item with index <item_index> in the
MultiList widget <mlw>.  If <item_index> doesn't correspond to a
selected item, then nothing will happen.  Otherwise, the item is
unselected and the selection array and count are updated.
.RE
.sp
.nf
void XfwfMultiListUnhighlightAll(mlw)
XfwfMultiListWidget mlw;
.fi
.sp
.RS 5
This routine unhighlights all items in the MultiList widget <mlw>.
.RE
.sp
.nf
int XfwfMultiListToggleItem(mlw,item_index)
XfwfMultiListWidget mlw;
.fi
.sp
.RS 5
This routine highlights the item with index <item_index> if it is
unhighlighted and unhighlights it if it is already highlighted.  The
action performed by the toggle is returned (XfwfMultiListActionHighlight
or XfwfMultiListActionUnhighlight).
.RE
.sp
.nf
XfwfMultiListReturnStruct *MultiListGetHighlighted(mlw)
XfwfMultiListWidget mlw;
.fi
.sp
.RS 5
This routine takes a MultiList widget <mlw> and returns a
MultiListReturnStruct whose num_selected and selected_items fields
contain the highlight information.  The action field is set to
XfwfMultiListActionStatus, and the item_index and string fields are
invalid.
.RE
.sp
.nf
Boolean XfwfMultiListIsHighlighted(plw,item_index)
XfwfMultiListWidget mlw;
int item_index;
.fi
.sp
.RS 5
This routine checks if the item with index <item_index> is highlighted
and returns True or False depending.  If <item_index> is invalid,
False is returned.
.RE
.sp
.nf
Boolean XfwfMultiListGetItemInfo(mlw,item_index,str_ptr,h_ptr,s_ptr)
XfwfMultiListWidget mlw;
int item_index;
String *str_ptr;
Boolean *h_ptr,*s_ptr;
.fi
.sp
.RS 5
This routine returns the string, highlight status and sensitivity
information for the item with index <item_index> via the pointers
<str_ptr>, <h_ptr> and <s_ptr>.  If the item index is invalid, False
is returned, else True is returned.
.RE
.sp
.nf
void XfwfMultiListSetNewData(mlw,list,nitems,longest,resize,sensitivity_array)
MultiListWidget mlw;
String *list;
int nitems,longest;
Boolean resize;
Boolean *sensitivity_array;
.fi
.sp
.RS 5
This routine will set a new set of strings <list> into the MultiList
widget <mlw>.  If <resize> is True, the MultiList widget will try to
resize itself.
.RE
.sp
.nf
.ne 4
.SH Restrictions
.LP
There are likely to be inadequacies in this code.  Specifically, I am
not sure what the callback interface should look like when you can
select and unselect multiple items.  This is the reason for the
confusing return structure fields.  Please send bug reports and
feature requests to the email address below.
.SH Author
.sp
.nf
Brian Totty, \fItotty@cs.uiuc.edu\fR
Department of Computer Science,
University of Illinois at Urbana-Champaign
1304 W. Springfield Avenue
Urbana, IL 61801
.fi
