/*
 *========================================================================
 * $Id: xmlsysd_init_stats.c 133 2004-02-21 15:49:06Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */


#include "xmlsysd.h"

void init_stats()
{

 int i,j,numfields;

 if((verbose == D_ALL) || (verbose == D_INIT)){
   printf("D_INIT: Starting init_stats().  Use -v %d to focus.\n",D_INIT);
 }

 /*
  * We loop through all the stats files (in procpaths) and try to open
  * them.  If successful we put their file descriptors in stats_fd[] 
  * (else NULL).
  */
 for(i = 0; i < N_SOURCES;i++){
   if(stat_fd[i] == 0){
     stat_fd[i] = fopen(procpaths[i],"r");
     if((verbose == D_ALL) || (verbose == D_INIT)){
       printf("D_INIT: Opened %s as fd = %d\n",procpaths[i],stat_fd[i]);
     }
   } else {
     if((verbose == D_ALL) || (verbose == D_INIT)){
       printf("D_INIT: %s already open as fd = %d\n",procpaths[i],stat_fd[i]);
     }
   }
 }
 initialized = 1;

}

