/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.draw;

import edu.hws.jcm.awt.Computable;
import edu.hws.jcm.data.NumUtils;
import edu.hws.jcm.data.Value;
import edu.hws.jcm.draw.Drawable;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;

public class DrawString
extends Drawable
implements Computable {
    public static final int TOP_LEFT = 0;
    public static final int TOP_CENTER = 1;
    public static final int TOP_RIGHT = 2;
    public static final int CENTER_LEFT = 4;
    public static final int CENTER_CENTER = 5;
    public static final int CENTER_RIGHT = 6;
    public static final int BOTTOM_LEFT = 8;
    public static final int BOTTOM_CENTER = 9;
    public static final int BOTTOM_RIGHT = 10;
    public static final int CENTER = 5;
    public static final int LEFT = 0;
    public static final int RIGHT = 2;
    protected int position;
    protected String baseString;
    protected String[] strings;
    protected Value[] values;
    protected Value xPos;
    protected Value yPos;
    protected Color color;
    protected Font font;
    protected int offset = 3;
    protected boolean clamp = true;
    protected int justification = 0;
    protected int numSize = 10;
    protected Color backgroundColor;
    protected int frameWidth;
    protected Color frameColor;
    private double xRef;
    private double yRef;
    private boolean changed = true;

    public DrawString() {
        this(null, 0, null);
    }

    public DrawString(String string) {
        this(string, 0, null);
    }

    public DrawString(String string, int n) {
        this(string, n, null);
    }

    public DrawString(String string, int n, Value[] valueArray) {
        this.position = n;
        this.values = valueArray;
        this.setString(string);
    }

    public DrawString(String string, int n, Value value, Value value2, Value[] valueArray) {
        this.setReferencePoint(value, value2);
        this.position = n;
        this.values = valueArray;
        this.setString(string);
    }

    public void setColor(Color color) {
        this.color = color;
        this.needsRedraw();
    }

    public Color getColor() {
        return this.color == null ? Color.black : this.color;
    }

    public void setFont(Font font) {
        this.font = font;
        this.needsRedraw();
    }

    public Font getFont() {
        return this.font;
    }

    public void setValues(Value[] valueArray) {
        this.values = valueArray;
        this.changed = true;
        this.needsRedraw();
    }

    public Value[] getValues() {
        return this.values;
    }

    public void setPositioning(int n) {
        this.position = n;
        this.needsRedraw();
    }

    public int getPositioning() {
        return this.position;
    }

    public void setReferencePoint(Value value, Value value2) {
        this.xPos = value;
        this.yPos = value2;
        try {
            if (this.xPos != null) {
                this.xRef = this.xPos.getVal();
            }
            if (this.yPos != null) {
                this.yRef = this.yPos.getVal();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.needsRedraw();
    }

    public Value getXPos() {
        return this.xPos;
    }

    public Value getYPos() {
        return this.yPos;
    }

    public void setString(String string) {
        this.baseString = string;
        this.strings = null;
        this.changed = true;
        this.needsRedraw();
    }

    public String getString() {
        return this.baseString;
    }

    public void setOffset(int n) {
        this.offset = n;
        this.needsRedraw();
    }

    public int getOffset() {
        return this.offset;
    }

    public void setClamp(boolean bl) {
        this.clamp = bl;
        this.needsRedraw();
    }

    public boolean getClamp() {
        return this.clamp;
    }

    public void setJustification(int n) {
        this.justification = n == 2 || n == 5 ? n : 0;
        this.needsRedraw();
    }

    public int getJustification() {
        return this.justification;
    }

    public void setNumSize(int n) {
        this.numSize = Math.min(Math.max(n, 6), 25);
        this.changed = true;
        this.needsRedraw();
    }

    public int getNumSize() {
        return this.numSize;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.needsRedraw();
    }

    public Color getFrameColor() {
        return this.frameColor;
    }

    public void setFrameColor(Color color) {
        this.frameColor = color;
        this.needsRedraw();
    }

    public int getFrameWidth() {
        return this.frameWidth;
    }

    public void setFrameWidth(int n) {
        this.frameWidth = n < 0 ? 0 : (n > 25 ? 25 : n);
        this.needsRedraw();
    }

    @Override
    public void compute() {
        this.changed = true;
        this.needsRedraw();
    }

    private void getSubstitutedText() {
        this.changed = false;
        if (this.xPos != null) {
            this.xRef = this.xPos.getVal();
        }
        if (this.yPos != null) {
            this.yRef = this.yPos.getVal();
        }
        if (this.values == null && this.strings != null) {
            return;
        }
        if (this.baseString == null || this.baseString.trim().length() == 0) {
            this.strings = null;
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.baseString, "\n");
        int n = stringTokenizer.countTokens();
        this.strings = new String[n];
        if (this.values == null) {
            for (int i = 0; i < n; ++i) {
                this.strings[i] = stringTokenizer.nextToken();
            }
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string = stringTokenizer.nextToken();
            for (int j = 0; j < string.length(); ++j) {
                if (string.charAt(j) == '#') {
                    if (j != string.length() - 1 && string.charAt(j + 1) == '#') {
                        stringBuffer.append('#');
                        ++j;
                        continue;
                    }
                    if (n2 < this.values.length) {
                        try {
                            stringBuffer.append(NumUtils.realToString(this.values[n2].getVal(), this.numSize));
                        }
                        catch (RuntimeException runtimeException) {
                            stringBuffer.append("(error)");
                        }
                        ++n2;
                        continue;
                    }
                    stringBuffer.append("undefined");
                    continue;
                }
                stringBuffer.append(string.charAt(j));
            }
            this.strings[i] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
    }

    @Override
    public void draw(Graphics graphics, boolean bl) {
        int n;
        int n2;
        FontMetrics fontMetrics;
        if (this.changed) {
            this.getSubstitutedText();
        }
        if (this.strings == null) {
            return;
        }
        if (this.xPos != null && (Double.isNaN(this.xRef) || Double.isInfinite(this.xRef))) {
            return;
        }
        if (this.yPos != null && (Double.isNaN(this.yRef) || Double.isInfinite(this.yRef))) {
            return;
        }
        int n3 = this.offset;
        if (this.backgroundColor != null || this.frameWidth > 0) {
            n3 += 3;
        }
        n3 += this.frameWidth;
        Font font = null;
        if (this.font != null) {
            font = graphics.getFont();
            graphics.setFont(this.font);
            fontMetrics = graphics.getFontMetrics(this.font);
        } else {
            fontMetrics = graphics.getFontMetrics(graphics.getFont());
        }
        int n4 = fontMetrics.getHeight();
        int n5 = this.coords.getLeft();
        int n6 = this.coords.getWidth();
        int n7 = this.coords.getTop();
        int n8 = this.coords.getHeight();
        int n9 = n5 + n6;
        int n10 = n7 + n8;
        int n11 = 0;
        for (n2 = 0; n2 < this.strings.length; ++n2) {
            n11 = Math.max(n11, fontMetrics.stringWidth(this.strings[n2]));
        }
        n2 = this.strings.length * n4;
        if (this.backgroundColor == null && this.frameWidth <= 0) {
            n2 = n2 - fontMetrics.getLeading() - fontMetrics.getDescent();
        }
        int n12 = 0;
        int n13 = 0;
        int n14 = this.position % 4;
        int n15 = this.position / 4;
        if (this.position < 0 || n14 > 2 || n15 > 2) {
            n14 = 0;
            n15 = 0;
        }
        n12 = this.xPos == null ? (n14 == 0 ? n5 + n3 : (n14 == 1 ? (n5 + n9 - n11) / 2 : n9 - n11 - n3)) : (n14 == 0 ? this.coords.xToPixel(this.xRef) + n3 : (n14 == 1 ? this.coords.xToPixel(this.xRef) - n11 / 2 : this.coords.xToPixel(this.xRef) - n11 - n3));
        n13 = this.yPos == null ? (n15 == 0 ? n7 + n3 : (n15 == 1 ? (n7 + n10 - n2) / 2 : n10 - n2 - n3)) : (n15 == 0 ? this.coords.yToPixel(this.yRef) + n3 : (n15 == 1 ? this.coords.yToPixel(this.yRef) - n2 / 2 : this.coords.yToPixel(this.yRef) - n2 - n3));
        if (this.clamp) {
            if (n12 + n11 > n9) {
                n12 = n9 - n11;
            }
            if (n12 < n5) {
                n12 = n5;
            }
            if (n13 + n2 > n10) {
                n13 = n10 - n2;
            }
            if (n13 < n7) {
                n13 = n7;
            }
        }
        if (this.backgroundColor != null) {
            graphics.setColor(this.backgroundColor);
            graphics.fillRect(n12 - 3, n13 - 3, n11 + 6, n2 + 6);
        }
        if (this.frameWidth > 0) {
            if (this.frameColor != null) {
                graphics.setColor(this.frameColor);
            } else if (this.color != null) {
                graphics.setColor(this.color);
            } else {
                graphics.setColor(Color.black);
            }
            for (n = 1; n <= this.frameWidth; ++n) {
                graphics.drawRect(n12 - 3 - n, n13 - 3 - n, n11 + 5 + 2 * n, n2 + 5 + 2 * n);
            }
        }
        if (this.color != null) {
            graphics.setColor(this.color);
        } else {
            graphics.setColor(Color.black);
        }
        n13 += fontMetrics.getAscent();
        for (n = 0; n < this.strings.length; ++n) {
            int n16 = n12;
            if (this.justification == 5) {
                n16 += (n11 - fontMetrics.stringWidth(this.strings[n])) / 2;
            } else if (this.justification == 2) {
                n16 = n16 + n11 - fontMetrics.stringWidth(this.strings[n]);
            }
            graphics.drawString(this.strings[n], n16, n13);
            n13 += n4;
        }
        if (font != null) {
            graphics.setFont(font);
        }
    }
}

