#
# This script establishes list of primitive groups.
# You should run it when you update GAP to new version whose transtive
# groups database changes.

ulimit -d 30000
if [ ! -d prim ]; then exit; fi
cd prim
rm -f * &>/dev/null

gap.sh <<@
IsDihedralGroup:=function(dgrp)
 local siz, gens, ords;
 siz:=Size(dgrp);
 if Gcd(siz,2)<>2 then return false; else siz:=siz/2; fi;
 gens:=SmallGeneratingSet(dgrp); ords:=List(gens,Order);
 if (ords=[2,siz] or ords=[siz,2]) and Order((gens[1]*gens[2])^2)=1 then 
  return true; else return false;
 fi;
end;
naturecode:=function(grp)
local a; a:=0;
 if IsCyclic(grp) then a:=1; elif
    IsAbelian(grp) then a:=2; elif
    IsNilpotentGroup(grp) then a:=3; elif
    IsDihedralGroup(grp) then a:=5; elif
    IsSolvableGroup(grp) then a:=4; elif
    IsSimpleGroup(grp) then a:=11; elif
    IsPerfectGroup(grp) then a:=12; fi;
 return a; end;

 for s in [2..60] do
  n:=NrPrimitiveGroups(s);
  AppendTo("index","!set primtot_",s,"=",n,"\n");
  for i in [1..n] do
   G:=PrimitiveGroup(s,i);
   b:=Size(G);
   if b<1000000000000000000 then
    a:=naturecode(G);
    AppendTo(String(s),":",i,",",b,",",a,",",G,"\n"); 
   fi;
  od;
 od;
@

for i in [0-9]*
do
 cat $i | sed 's/</\&lt;/g;s/ = /=/g;s/ \[ /\[/g;s/ \] /\]/g;s/, /,/g;s/ \.\. /../g;s/(),//g' >$i..
 mv $i.. $i
done

exit

