/**
 * GraphInfo.java
 *
 * Created on Jul 3, 2006
 */
package graphe;

import java.awt.Graphics;

import maths.CoordSyst;

/**
 * Cette interface represente un objet qui peut se dessiner dans un 
 * {@link java.awt.Graphics Graphics}. Cela peut etre un rectagle
 * pour indiquer le zoom, une cible pour indiquer un point, un 
 * systeme de coordonees etc.
 *
 * @author Nicolae
 */
public interface GraphInfo {
	
	/**
	 * Dessine l'objet dans <code>g</code>.
	 *
	 * @param g l'espace de dessin.
	 */
	public void paint(Graphics g);
		
	/**
	 * Etablie les coordonees de l'objet.
	 *
	 * @param re coordonee reele.
	 * @param im coordonee imaginaire.
	 */
	public void setPoint(double re, double im);
		
	/**
	 * Etablie le ou les systemes de coordonees.
	 *
	 * @param princ le systeme de coordonees principal.
	 * @param sec le systeme de coordonees secondaire.
	 */
	public void setCoords(CoordSyst princ, CoordSyst sec);
	
	/**
	 * Renvoie la valeur de la propriete <code>under</code>.
	 * <code>true</code> pour dessiner en dessous du graphe.
	 *
	 * @return la valeur de la propriete <code>under</code>.
	 */
	public boolean isUnder();
	
	/**
	 * Etablit la valeur de la propriete <code>under</code>.
	 * <code>true</code> pour desinner en dessous du graphe.
	 *
	 * @param under la nouvelle valeur.
	 */
	public void setUnder(boolean under);
}
