/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.picking;

import java.util.HashMap;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLPickingSensorNodeType;
import org.web3d.vrml.renderer.common.nodes.picking.BasePickingNode;

public abstract class BaseVolumePicker
extends BasePickingNode {
    protected static final int LAST_VOLUME_INDEX = 8;
    protected static final int NUM_FIELDS = 9;
    protected static final String VOLUME_PROTO_MSG = "Proto does not describe a volumetric object type";
    protected static final String VOLUME_NODE_MSG = "Node does not describe a volumetric object type";
    private static final String PICK_GEOM_MSG = "The pickGeometry type is invalid for VolumePicker. It must be one of the X3DComposedGeometryNode node types ";
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;

    public BaseVolumePicker() {
        super("VolumePicker", PICK_GEOM_MSG);
        this.hasChanged = new boolean[9];
        this.validGeometryNodeNames.add("Box");
        this.validGeometryNodeNames.add("Cone");
        this.validGeometryNodeNames.add("Cylinder");
        this.validGeometryNodeNames.add("IndexedFaceSet");
        this.validGeometryNodeNames.add("TriangleSet");
        this.validGeometryNodeNames.add("IndexedTriangleSet");
        this.validGeometryNodeNames.add("TriangleFanSet");
        this.validGeometryNodeNames.add("IndexedTriangleFanSet");
        this.validGeometryNodeNames.add("TriangleStripSet");
        this.validGeometryNodeNames.add("IndexedTriangleStripSet");
    }

    public BaseVolumePicker(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLPickingSensorNodeType)vRMLNodeType);
    }

    public int getPickingType() {
        return 7;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 8) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    static {
        nodeFields = new int[]{4, 3, 0};
        fieldDecl = new VRMLFieldDeclaration[9];
        fieldMap = new HashMap(27);
        BaseVolumePicker.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseVolumePicker.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFNode", "pickingGeometry");
        BaseVolumePicker.fieldDecl[4] = new VRMLFieldDeclaration(3, "MFNode", "pickTarget");
        BaseVolumePicker.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseVolumePicker.fieldDecl[6] = new VRMLFieldDeclaration(4, "MFNode", "pickedGeometry");
        BaseVolumePicker.fieldDecl[2] = new VRMLFieldDeclaration(4, "SFBool", "isActive");
        BaseVolumePicker.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFString", "intersectionType");
        BaseVolumePicker.fieldDecl[7] = new VRMLFieldDeclaration(2, "SFString", "sortOrder");
        BaseVolumePicker.fieldDecl[8] = new VRMLFieldDeclaration(3, "MFString", "objectType");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(3);
        fieldMap.put("pickingGeometry", n);
        fieldMap.put("set_pickingGeometry", n);
        fieldMap.put("pickingGeometry_changed", n);
        n = new Integer(4);
        fieldMap.put("pickTarget", n);
        fieldMap.put("set_pickTarget", n);
        fieldMap.put("pickTarget_changed", n);
        n = new Integer(1);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        n = new Integer(8);
        fieldMap.put("objectType", n);
        fieldMap.put("set_objectType", n);
        fieldMap.put("objectType_changed", n);
        fieldMap.put("sortOrder", new Integer(7));
        fieldMap.put("intersectionType", new Integer(5));
        fieldMap.put("isActive", new Integer(2));
        fieldMap.put("pickedGeometry", new Integer(6));
    }
}

