/**
 * This file is a part of VideoCut package.
 * ---------------------------------------------------------------------- 
 * Copyright (C) 2007-2008 troorl
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ---------------------------------------------------------------------- 
 *
 * @author troorl <troorl@gmail.com>
 */

#ifndef _TLISTPANEL_H_
#define _TLISTPANEL_H_

#include <QGraphicsView>
#include <QGraphicsScene>
#include <QGraphicsTextItem>
#include <QRect>
#include <QWidget>
#include <QMessageBox>
#include "TFrameItem.h"
#include "../frameStruct.h"

class TListPanel : public QGraphicsView 
{
    Q_OBJECT
public:
    TListPanel(QWidget *parent = 0, Qt::WindowFlags f = 0);
    virtual ~TListPanel(void);

	void setActions(QAction &, QAction &);
    void addItem(QPixmap &);
	void setList(QList<frameStruct*> *);
	void createItems();
	void adjustItems();
    void removeAt(int);
	void removeAll();
	void deleteItem(int index);
	int count();
	int getCurrentIndex();

private slots:
    void S_SelectItem(TFrameItem &);
    void S_SaveItem(TFrameItem &);

signals:
    void changeItem(int);
    void onSave(int);

protected:

private:
    QGraphicsScene *scene;
    QGraphicsTextItem *infoText;
    QList<TFrameItem*> *frameItems;
	QList<frameStruct*> *listItems;
	
    int countItems; //count of items
    int currentIndex; // selected item
    int x, y;
    int w, h;
    int otst;
    int inc;
    QRectF sizeItem;
	
	QAction *delAct;
	QAction *saveAct;
};

#endif
