/*
 * ===========================
 * VDK Visual Development Kit
 * Version 2.0.3
 * January 2003
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include <vdk/vdkhlbuttonbar.h>
DEFINE_SIGNAL_LIST (VDKHLButtonBar, VDKFrame);
/*
*/
VDKHLButtonBar::VDKHLButtonBar (VDKForm* owner, int mode, 
      int shadow): VDKFrame (owner, NULL,  mode, shadow), 
  ButtonPressed ("ButtonPressed", this, -1)
{
}
/*
*/
VDKHLButtonBar::~VDKHLButtonBar ()
{
}
/*
*/
bool
VDKHLButtonBar::OnClick (VDKObject* sender)
{
  ButtonListIterator li (blist);
  int t = 0;
  for (;li;li++, t++)
    if (li.current () ==  sender)
      break;
  if (t < blist.size ())
    {
      ButtonPressed (t);
      SignalEmit (clicked_signal);
      SignalEmit ("clicked");
    }
  else
    ButtonPressed (-1);
  return true;
}
/*
*/
void 
VDKHLButtonBar::AddButton (const char** pixdata, 
                  const char* tip,
                  const char* text)
{
  VDKHLButton *button = new VDKHLButton (Owner (),pixdata, text);
  if (tip)
    button->SetTip ((char*) tip); 
  Add (button, l_justify, false, false, 0);
  blist.add (button);
  SignalConnect (button, "clicked", &VDKHLButtonBar::OnClick);
}
/*
*/
void 
VDKHLButtonBar::AddButton (const char* pixfile, 
                  const char* tip,
                  const char* text)
{
  VDKHLButton *button = new VDKHLButton (Owner (),pixfile, text);
  if (tip)
    button->SetTip ((char*) tip); 
  Add (button, l_justify, false, false, 0);
  blist.add (button);
  SignalConnect (button, "clicked", &VDKHLButtonBar::OnClick);
}
/*
 */
VDKHLButton* 
VDKHLButtonBar::operator[](int n)
{
  if( (n >= 0) && (n < blist.size()))
    return blist[n];
  else
    return NULL;
}
