/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.6
 * Revision 7
 * September 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
/*
OVERVIEW
--------
This file has the aim to be a footstep that shows how to make a
gtk+ widget wrapper in vdk.
We choose here to wrap gtk_calendar() widget.
*/

#include <vdk/vdkcalendar.h>
#include <vdk/forms.h>

/*
 */
VDKCalendar::VDKCalendar(VDKForm* owner):
  VDKObject(owner),
  /*
    this part initializes properties:
    args:
       name         conventionally we use a string equal to name
       this         obvious
       default      value the property init value
       setting fun  which function will be called
                    when the user writes: property = value;
       getting fun  which function will be called
                    when the user writes: value = property;
  */
  DisplayOptions("DisplayOptions",this,GTK_CALENDAR_SHOW_HEADING,
		 &VDKCalendar::SetDisplayOptions,
		 (GtkCalendarDisplayOptions (VDKCalendar::*)(void)) NULL),
  SelectedDate("SelectedDate",this,calendardate(),
	       &VDKCalendar::GetSelectedDate,
	       (void (VDKCalendar::*)(calendardate)) NULL),
  SelectedDay("SelectedDay",this,0,
	      &VDKCalendar::SetSelectedDay,
	      (int (VDKCalendar::*)(void)) NULL),
  SelectedMonth("SelectedMonth",this,VDKPoint(0,0),
		&VDKCalendar::SetSelectedMonth,
		(VDKPoint (VDKCalendar::*)(void)) NULL)

{
  // actually make the gtk widget
  // and assign widget pointer
  widget = gtk_calendar_new();
  calendardate today;
  // by default gtk_calendar opens on 1st day of the current month
  // we select today as well
  SelectedDay = today.Day(); 
  // marks today in bold face
  gtk_calendar_mark_day ( GTK_CALENDAR(widget), today.Day());
  // connecting signal handlers
  // we pass <this> as user data arg so static handler can
  // access to calendar
  gtk_signal_connect (GTK_OBJECT (widget), "day_selected",
                      GTK_SIGNAL_FUNC (VDKCalendar::DaySelectedHandler),
		      (gpointer) this);
  gtk_signal_connect (GTK_OBJECT (widget), "day_selected_double_click",
	      GTK_SIGNAL_FUNC (VDKCalendar::DaySelectedDoubleClickHandler),
		      (gpointer)this);
  ConnectDefaultSignals();
}

/*
 */
VDKCalendar::~VDKCalendar()
{
  // nothing to do
}

/*
-----------------------
signal handling section
----------------------
*/
void
VDKCalendar::DaySelectedHandler(GtkWidget* widget, gpointer p)
{
  /*
    some usual checks for safety
  */
  g_return_if_fail(widget != NULL);
  g_return_if_fail(p != NULL);
  /*
    cast to vdkcalendar
  */
  VDKCalendar* obj = reinterpret_cast<VDKCalendar*>(p);
  // month,year  selected  (month base = 1)
  VDKPoint point(GTK_CALENDAR(widget)->month+1,GTK_CALENDAR(widget)->year);
  // set properties using a raw write
  obj->SelectedDay(GTK_CALENDAR(widget)->selected_day);
  obj->SelectedMonth(point);
  // feeds signal into vdk system
  obj->SignalEmit(day_select_signal);
}

void
VDKCalendar::DaySelectedDoubleClickHandler(GtkWidget* widget, gpointer p)
{
  /*
    same as above
  */
  g_return_if_fail(widget != NULL);
  g_return_if_fail(p != NULL);
  VDKCalendar* obj = reinterpret_cast<VDKCalendar*>(p);
  VDKPoint point(GTK_CALENDAR(widget)->month+1,GTK_CALENDAR(widget)->year);
  obj->SelectedDay(GTK_CALENDAR(widget)->selected_day);
  obj->SelectedMonth(point);
  obj->SignalEmit(day_selected_double_click);
}

/*
----------------------------
properties handling section
----------------------------
*/
void
VDKCalendar::SetDisplayOptions(GtkCalendarDisplayOptions options)
{
  gtk_calendar_display_options (GTK_CALENDAR(widget),options);
}
/*
 */
calendardate
VDKCalendar::GetSelectedDate()
{
  unsigned int day,month,year;
  GtkCalendar* calendar = GTK_CALENDAR(widget);
  gtk_calendar_get_date(calendar, &year, &month, &day);
  // months base 0 in gtk+
  return calendardate(day,month+1,year);
}
/*
 */
void
VDKCalendar::SetSelectedDay(int day)
{
  gtk_calendar_select_day(GTK_CALENDAR(widget),day);
}
/*
 */
void
VDKCalendar::SetSelectedMonth(VDKPoint p)
{
  // gtk+ month base = 0	
  gtk_calendar_select_month(GTK_CALENDAR(widget), p.x-1, p.y);
}



