#!/usr/bin/perl -w

use strict;
use IO::Socket;
use IO::Select;
use IO::Handle;

my $rendezvous = shift or die "No socket name";
my ($lsn, $flag, $fh, $buf, $sel, @ready);

$SIG{INT} = sub {
  print "Close on SIGINT\n"; 
  $lsn->close(); 
  unlink $rendezvous;
  exit()
};

sub cleansock($)
{
  my $fh = $_[0];
  $sel->remove($fh);
  $fh->close();
}

$lsn = new IO::Socket::UNIX(Listen => 1,
			    Local => $rendezvous,
			    Proto => 'tcp',
			    Type => SOCK_STREAM) or die "bind $!";

$sel = new IO::Select or die "select $!";

$sel->add($lsn);

print "Listening\n";

while(@ready = $sel->can_read) 
{
  foreach $fh (@ready) 
  {
    if($fh == $lsn)
    {
      my $ns = $fh->accept;
      $sel->add($ns);
      print "\nConnect\n";
    }
    else
    {
      if($fh->recv($buf, 256, 0), $buf)
      {
	$fh->send((length($buf)-1)." -> ".$buf, 0);
      }
      else
      {
	print "Closed\n";		
	cleansock($fh);
      }
    }
  }
}


