/***************************************************************************
                          dctransferview.h  -  description
                             -------------------
    begin                : Sat Feb 23 2002
    copyright            : (C) 2002-2004 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCTRANSFERVIEW_H
#define DCTRANSFERVIEW_H

/**
  *@author Mathias Küster
  */

#include <QStringList>
#include <QList>
#include <QMutex>
#include <QMap>

#include <dclib/dcobject.h>
#include <dclib/cdownloadmanager.h>

#include "DCDialogTransfer.h"

class Q3ListViewItem;
class DCTransferQueueParent;
class DCTransferListItem;

class DCFileBrowser;
class QTimer;
class QTextEdit;
class QResizeEvent;
class QShowEvent;

typedef QMap<ulonglong, DCTransferListItem*> ActiveTransferMap;

typedef QMap<QString, DCTransferQueueParent*> QueueParentMap;
typedef QMap<QString, QueueParentMap*> TransferQueueMap;

class DCTransferView : public QWidget, private Ui::DCDialogTransfer, public CDownloadManager {
Q_OBJECT

public:
	/** construtor */
	DCTransferView( QWidget * parent = 0 );
	/** destructor */
	virtual ~DCTransferView();

	/** */
	void InitDocument();
	/** */
	void DeInitDocument();
	/** */
	void NewLocalFileBrowser( const bool lock );
	/** */
	void NewFileBrowser( QString nick, QString hubname, QString hubhost, QString share, QString jumpto = QString::null, QStringList dirs = QStringList() );
	/** */
	bool IsUserInQueue( QString Nick, QString Hubname );
	/** returns the list of the local files names in the queue list. The path is included.*/
	void GetLocalFilesList( QStringList & LocalFiles, ulonglong size = 0);
	/**
	 * Returns the list of the local files names in the queue list that match the TTH
	 * falling back to size if the queue TTH is empty. Use the method with just
	 * size if you have an empty TTH.
	 */
	void GetLocalFilesList( QStringList & LocalFiles, QString tth, ulonglong size );
	/** download manager callback function */
	virtual int DC_DownloadManagerCallBack( CDCMessage * );

protected:
	/** Adjust column sizes preserving user set size ratios */
	void SizeColumnsPreservingRatios();
	/** overridden so that the column widths are initialized on first show() */
	virtual void showEvent( QShowEvent * event );
	/** resize event handler */
	virtual void resizeEvent( QResizeEvent * );

private:
	/** */
	void MessageSlot( CMessageDMSlotObject * msg );
	/** */
	void MessageLog( CMessageLog * msg );
	/** */
	void MessageTransfer( CMessageDMTransferObject * msg );

	/** */
	void ConnectToAllHubs();
	/** */
	void SearchFileClone(QString filename, ulonglong size);
	/** */
	ulonglong FindTransferID( Q3ListViewItem * item );
	/** */
	eConnectionState GetTransferDirection( ulonglong sid );
	/** */
	bool GetTransferMessageObject( Q3ListViewItem * item, CMessageDMTransferObject * obj );

	/** */
	bool UpdateTransferWaitList( CMessageDMFileObject * msg );
	/** */
	bool UpdateLocalFileList( CMessageDMFileObject * msg );
	/** */
	void EditExistingTransfer( QString & nick, QString & hubname, QString & hubhost, CList<DCHubObject> * list );
	/** */
	QList<CDCMessage*> * pMessageList;
	/** */
	ActiveTransferMap m_ActiveTransferMap;
	/** */
	QMutex m_ActiveTransferMapMutex;
	/** */
	QMutex * m_pMessageQueueMutex;
	/** */
	QTimer * Timer;
	/** */
	TransferQueueMap m_QueueMap;
	/** */
	QMutex m_QueueMapMutex;
	/** */
	QueueParentMap m_QueueLocalMap;
	/** */
	QMutex m_QueueLocalMapMutex;
	/** Last width the transfer list has been adjusted for */
	int lastTransfersWidth;
	/** Last width the wait list has been adjusted for */
	int lastWaitWidth;
	/** Last width the files list has been adjusted for */
	int lastFilesWidth;
	/** Last width the slots list has been adjusted for */
	int lastSlotsWidth;

private slots:
	/** */
	void timerDone();
	/** */
	void slotRightButtonClickedTransferList( Q3ListViewItem*, const QPoint &, int );
	/** */
	void slotRightButtonClickedTransferWaitList( Q3ListViewItem*, const QPoint &, int );
	/** */
	void slotRightButtonClickedLocalFilesList( Q3ListViewItem*, const QPoint &, int );
	/** */
	void slotTabWidgetCurrentChange(QWidget*);
	/** */
	void slotDoubleClickedTransferWaitList( Q3ListViewItem* );
	/** */
	void slotContextMenuUserSlotList( const QPoint & );
	/** */
	void slotRightButtonClickedLog( const QPoint& );
};

/** */
extern DCTransferView * g_pTransferView;

#endif
