/* valainterface.c generated by valac, the Vala compiler
 * generated from valainterface.vala, do not modify */

/* valainterface.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

struct _ValaInterfacePrivate {
	ValaList* prerequisites;
	ValaList* virtuals;
};

static gint ValaInterface_private_offset;
static gpointer vala_interface_parent_class = NULL;

static void vala_interface_real_add_method (ValaSymbol* base,
                                     ValaMethod* m);
static void vala_interface_real_add_property (ValaSymbol* base,
                                       ValaProperty* prop);
static ValaList* vala_interface_real_get_virtuals (ValaInterface* self);
static void vala_interface_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor);
static void vala_interface_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor);
static gboolean vala_interface_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_interface_real_is_subtype_of (ValaTypeSymbol* base,
                                            ValaTypeSymbol* t);
static void vala_interface_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type);
static gboolean vala_interface_real_check (ValaCodeNode* base,
                                    ValaCodeContext* context);
static void vala_interface_finalize (ValaCodeNode * obj);
static GType vala_interface_get_type_once (void);

static inline gpointer
vala_interface_get_instance_private (ValaInterface* self)
{
	return G_STRUCT_MEMBER_P (self, ValaInterface_private_offset);
}

/**
 * Creates a new interface.
 *
 * @param name              type name
 * @param source_reference  reference to source code
 * @return                  newly created interface
 */
ValaInterface*
vala_interface_construct (GType object_type,
                          const gchar* name,
                          ValaSourceReference* source_reference,
                          ValaComment* comment)
{
	ValaInterface* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaInterface*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}

ValaInterface*
vala_interface_new (const gchar* name,
                    ValaSourceReference* source_reference,
                    ValaComment* comment)
{
	return vala_interface_construct (VALA_TYPE_INTERFACE, name, source_reference, comment);
}

/**
 * Adds the specified interface or class to the list of prerequisites of
 * this interface.
 *
 * @param type an interface or class reference
 */
void
vala_interface_add_prerequisite (ValaInterface* self,
                                 ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->prerequisites;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}

/**
 * Returns the base type list.
 *
 * @return list of base types
 */
ValaList*
vala_interface_get_prerequisites (ValaInterface* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prerequisites;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified method as a member to this interface.
 *
 * @param m a method
 */
static void
vala_interface_real_add_method (ValaSymbol* base,
                                ValaMethod* m)
{
	ValaInterface * self;
	ValaMemberBinding _tmp2_;
	ValaMemberBinding _tmp3_;
	gboolean _tmp16_ = FALSE;
	ValaDataType* _tmp17_;
	ValaDataType* _tmp18_;
	self = (ValaInterface*) base;
	g_return_if_fail (m != NULL);
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp1_ = _tmp0_;
		vala_report_error (_tmp1_, "construction methods may only be declared within classes and structs");
		vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		return;
	}
	_tmp2_ = vala_method_get_binding (m);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != VALA_MEMBER_BINDING_STATIC) {
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaParameter* _tmp6_;
		ValaParameter* _tmp7_;
		ValaScope* _tmp8_;
		ValaScope* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		ValaParameter* _tmp14_;
		ValaParameter* _tmp15_;
		_tmp4_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) m, (ValaTypeSymbol*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_parameter_new ("this", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		vala_method_set_this_parameter (m, _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
		_vala_code_node_unref0 (_tmp5_);
		_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_method_get_this_parameter (m);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_method_get_this_parameter (m);
		_tmp15_ = _tmp14_;
		vala_scope_add (_tmp9_, _tmp13_, (ValaSymbol*) _tmp15_);
	}
	_tmp17_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp18_ = _tmp17_;
	if (!VALA_IS_VOID_TYPE (_tmp18_)) {
		ValaList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		_tmp19_ = vala_method_get_postconditions (m);
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp16_ = _tmp21_ > 0;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		ValaDataType* _tmp22_;
		ValaDataType* _tmp23_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaLocalVariable* _tmp28_;
		ValaLocalVariable* _tmp29_;
		ValaLocalVariable* _tmp30_;
		ValaLocalVariable* _tmp31_;
		_tmp22_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_data_type_copy (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_local_variable_new (_tmp25_, "result", NULL, _tmp27_);
		_tmp29_ = _tmp28_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp29_);
		_vala_code_node_unref0 (_tmp29_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp30_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp31_ = _tmp30_;
		vala_local_variable_set_is_result (_tmp31_, TRUE);
	}
	VALA_SYMBOL_CLASS (vala_interface_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
}

/**
 * Adds the specified property as a member to this interface.
 *
 * @param prop a property
 */
static void
vala_interface_real_add_property (ValaSymbol* base,
                                  ValaProperty* prop)
{
	ValaInterface * self;
	ValaField* _tmp0_;
	ValaField* _tmp1_;
	ValaMemberBinding _tmp4_;
	ValaMemberBinding _tmp5_;
	self = (ValaInterface*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = vala_property_get_field (prop);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "interface properties should be `abstract' or have `get' accessor and/o" \
"r `set' mutator");
		vala_code_node_set_error ((ValaCodeNode*) prop, TRUE);
		return;
	}
	VALA_SYMBOL_CLASS (vala_interface_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp4_ = vala_property_get_binding (prop);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != VALA_MEMBER_BINDING_STATIC) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		ValaParameter* _tmp8_;
		ValaParameter* _tmp9_;
		ValaScope* _tmp10_;
		ValaScope* _tmp11_;
		ValaParameter* _tmp12_;
		ValaParameter* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		_tmp6_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) prop, (ValaTypeSymbol*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_parameter_new ("this", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		vala_property_set_this_parameter (prop, _tmp9_);
		_vala_code_node_unref0 (_tmp9_);
		_vala_code_node_unref0 (_tmp7_);
		_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) prop);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_property_get_this_parameter (prop);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_symbol_get_name ((ValaSymbol*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_property_get_this_parameter (prop);
		_tmp17_ = _tmp16_;
		vala_scope_add (_tmp11_, _tmp15_, (ValaSymbol*) _tmp17_);
	}
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static ValaList*
vala_interface_real_get_virtuals (ValaInterface* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	_tmp0_ = self->priv->virtuals;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

ValaList*
vala_interface_get_virtuals (ValaInterface* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_INTERFACE_GET_CLASS (self)->get_virtuals (self);
}

static void
vala_interface_real_accept (ValaCodeNode* base,
                            ValaCodeVisitor* visitor)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_interface (visitor, self);
}

static void
vala_interface_real_accept_children (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaDataType* _tmp7_;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp5_ = _type_list;
			_tmp6_ = vala_list_get (_tmp5_, _type_index);
			type = (ValaDataType*) _tmp6_;
			_tmp7_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	VALA_CODE_NODE_CLASS (vala_interface_parent_class)->accept_children ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), visitor);
}

static gboolean
vala_interface_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaInterface * self;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
vala_interface_real_is_subtype_of (ValaTypeSymbol* base,
                                   ValaTypeSymbol* t)
{
	ValaInterface * self;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _prerequisite_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _prerequisite_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _prerequisite_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_prerequisite_list = _tmp1_;
		_tmp2_ = _prerequisite_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_prerequisite_size = _tmp4_;
		_prerequisite_index = -1;
		while (TRUE) {
			ValaDataType* prerequisite = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			gboolean _tmp7_ = FALSE;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			_prerequisite_index = _prerequisite_index + 1;
			if (!(_prerequisite_index < _prerequisite_size)) {
				break;
			}
			_tmp5_ = _prerequisite_list;
			_tmp6_ = vala_list_get (_tmp5_, _prerequisite_index);
			prerequisite = (ValaDataType*) _tmp6_;
			_tmp8_ = prerequisite;
			_tmp9_ = vala_data_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ != NULL) {
				ValaDataType* _tmp11_;
				ValaTypeSymbol* _tmp12_;
				ValaTypeSymbol* _tmp13_;
				_tmp11_ = prerequisite;
				_tmp12_ = vala_data_type_get_type_symbol (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp7_ = vala_typesymbol_is_subtype_of (_tmp13_, t);
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				_vala_code_node_unref0 (prerequisite);
				_vala_iterable_unref0 (_prerequisite_list);
				return result;
			}
			_vala_code_node_unref0 (prerequisite);
		}
		_vala_iterable_unref0 (_prerequisite_list);
	}
	result = FALSE;
	return result;
}

static void
vala_interface_real_replace_type (ValaCodeNode* base,
                                  ValaDataType* old_type,
                                  ValaDataType* new_type)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->prerequisites;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->prerequisites;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->prerequisites;
					vala_list_set (_tmp9_, i, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_interface_real_check (ValaCodeNode* base,
                           ValaCodeContext* context)
{
	ValaInterface * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaClass* prereq_class = NULL;
	gboolean _tmp122_;
	gboolean _tmp123_;
	ValaMap* positions = NULL;
	GHashFunc _tmp245_;
	GEqualFunc _tmp246_;
	GEqualFunc _tmp247_;
	ValaHashMap* _tmp248_;
	gboolean ordered_seen = FALSE;
	gboolean unordered_seen = FALSE;
	ValaSemanticAnalyzer* _tmp322_;
	ValaSemanticAnalyzer* _tmp323_;
	ValaSourceFile* _tmp324_;
	ValaSemanticAnalyzer* _tmp325_;
	ValaSemanticAnalyzer* _tmp326_;
	ValaSymbol* _tmp327_;
	gboolean _tmp328_;
	gboolean _tmp329_;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _prerequisite_reference_list = NULL;
		ValaList* _tmp24_;
		ValaList* _tmp25_;
		gint _prerequisite_reference_size = 0;
		ValaList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _prerequisite_reference_index = 0;
		_tmp24_ = vala_interface_get_prerequisites (self);
		_tmp25_ = _vala_iterable_ref0 (_tmp24_);
		_prerequisite_reference_list = _tmp25_;
		_tmp26_ = _prerequisite_reference_list;
		_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_prerequisite_reference_size = _tmp28_;
		_prerequisite_reference_index = -1;
		while (TRUE) {
			ValaDataType* prerequisite_reference = NULL;
			ValaList* _tmp29_;
			gpointer _tmp30_;
			ValaSemanticAnalyzer* _tmp31_;
			ValaSemanticAnalyzer* _tmp32_;
			ValaDataType* _tmp33_;
			_prerequisite_reference_index = _prerequisite_reference_index + 1;
			if (!(_prerequisite_reference_index < _prerequisite_reference_size)) {
				break;
			}
			_tmp29_ = _prerequisite_reference_list;
			_tmp30_ = vala_list_get (_tmp29_, _prerequisite_reference_index);
			prerequisite_reference = (ValaDataType*) _tmp30_;
			_tmp31_ = vala_code_context_get_analyzer (context);
			_tmp32_ = _tmp31_;
			_tmp33_ = prerequisite_reference;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp32_, (ValaSymbol*) self, _tmp33_)) {
				ValaSourceReference* _tmp34_;
				ValaSourceReference* _tmp35_;
				ValaDataType* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp35_ = _tmp34_;
				_tmp36_ = prerequisite_reference;
				_tmp37_ = vala_code_node_to_string ((ValaCodeNode*) _tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp40_ = _tmp39_;
				_tmp41_ = g_strdup_printf ("prerequisite `%s' is less accessible than interface `%s'", _tmp38_, _tmp40_);
				_tmp42_ = _tmp41_;
				vala_report_error (_tmp35_, _tmp42_);
				_g_free0 (_tmp42_);
				_g_free0 (_tmp40_);
				_g_free0 (_tmp38_);
				result = FALSE;
				_vala_code_node_unref0 (prerequisite_reference);
				_vala_iterable_unref0 (_prerequisite_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (prerequisite_reference);
		}
		_vala_iterable_unref0 (_prerequisite_reference_list);
	}
	prereq_class = NULL;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp43_;
		ValaList* _tmp44_;
		gint _prereq_size = 0;
		ValaList* _tmp45_;
		gint _tmp46_;
		gint _tmp47_;
		gint _prereq_index = 0;
		_tmp43_ = vala_interface_get_prerequisites (self);
		_tmp44_ = _vala_iterable_ref0 (_tmp43_);
		_prereq_list = _tmp44_;
		_tmp45_ = _prereq_list;
		_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
		_tmp47_ = _tmp46_;
		_prereq_size = _tmp47_;
		_prereq_index = -1;
		while (TRUE) {
			ValaDataType* prereq = NULL;
			ValaList* _tmp48_;
			gpointer _tmp49_;
			ValaDataType* _tmp50_;
			ValaDataType* _tmp60_;
			ValaTypeSymbol* _tmp61_;
			ValaTypeSymbol* _tmp62_;
			_prereq_index = _prereq_index + 1;
			if (!(_prereq_index < _prereq_size)) {
				break;
			}
			_tmp48_ = _prereq_list;
			_tmp49_ = vala_list_get (_tmp48_, _prereq_index);
			prereq = (ValaDataType*) _tmp49_;
			_tmp50_ = prereq;
			if (!VALA_IS_OBJECT_TYPE (_tmp50_)) {
				ValaSourceReference* _tmp51_;
				ValaSourceReference* _tmp52_;
				ValaDataType* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				gchar* _tmp56_;
				gchar* _tmp57_;
				gchar* _tmp58_;
				gchar* _tmp59_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp51_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp52_ = _tmp51_;
				_tmp53_ = prereq;
				_tmp54_ = vala_code_node_to_string ((ValaCodeNode*) _tmp53_);
				_tmp55_ = _tmp54_;
				_tmp56_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp57_ = _tmp56_;
				_tmp58_ = g_strdup_printf ("Prerequisite `%s' of interface `%s' is not a class or interface", _tmp55_, _tmp57_);
				_tmp59_ = _tmp58_;
				vala_report_error (_tmp52_, _tmp59_);
				_g_free0 (_tmp59_);
				_g_free0 (_tmp57_);
				_g_free0 (_tmp55_);
				result = FALSE;
				_vala_code_node_unref0 (prereq);
				_vala_iterable_unref0 (_prereq_list);
				_vala_code_node_unref0 (prereq_class);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp60_ = prereq;
			_tmp61_ = vala_data_type_get_type_symbol (_tmp60_);
			_tmp62_ = _tmp61_;
			if (VALA_IS_CLASS (_tmp62_)) {
				ValaClass* _tmp63_;
				ValaDataType* _tmp78_;
				ValaTypeSymbol* _tmp79_;
				ValaTypeSymbol* _tmp80_;
				ValaClass* _tmp81_;
				_tmp63_ = prereq_class;
				if (_tmp63_ != NULL) {
					ValaSourceReference* _tmp64_;
					ValaSourceReference* _tmp65_;
					gchar* _tmp66_;
					gchar* _tmp67_;
					ValaDataType* _tmp68_;
					ValaTypeSymbol* _tmp69_;
					ValaTypeSymbol* _tmp70_;
					gchar* _tmp71_;
					gchar* _tmp72_;
					ValaClass* _tmp73_;
					gchar* _tmp74_;
					gchar* _tmp75_;
					gchar* _tmp76_;
					gchar* _tmp77_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp64_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp65_ = _tmp64_;
					_tmp66_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp67_ = _tmp66_;
					_tmp68_ = prereq;
					_tmp69_ = vala_data_type_get_type_symbol (_tmp68_);
					_tmp70_ = _tmp69_;
					_tmp71_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp70_);
					_tmp72_ = _tmp71_;
					_tmp73_ = prereq_class;
					_tmp74_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp73_);
					_tmp75_ = _tmp74_;
					_tmp76_ = g_strdup_printf ("%s: Interfaces cannot have multiple instantiable prerequisites (`%s' a" \
"nd `%s')", _tmp67_, _tmp72_, _tmp75_);
					_tmp77_ = _tmp76_;
					vala_report_error (_tmp65_, _tmp77_);
					_g_free0 (_tmp77_);
					_g_free0 (_tmp75_);
					_g_free0 (_tmp72_);
					_g_free0 (_tmp67_);
					result = FALSE;
					_vala_code_node_unref0 (prereq);
					_vala_iterable_unref0 (_prereq_list);
					_vala_code_node_unref0 (prereq_class);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_tmp78_ = prereq;
				_tmp79_ = vala_data_type_get_type_symbol (_tmp78_);
				_tmp80_ = _tmp79_;
				_tmp81_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, VALA_TYPE_CLASS, ValaClass));
				_vala_code_node_unref0 (prereq_class);
				prereq_class = _tmp81_;
			}
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp82_;
		ValaList* _tmp83_;
		gint _type_size = 0;
		ValaList* _tmp84_;
		gint _tmp85_;
		gint _tmp86_;
		gint _type_index = 0;
		_tmp82_ = self->priv->prerequisites;
		_tmp83_ = _vala_iterable_ref0 (_tmp82_);
		_type_list = _tmp83_;
		_tmp84_ = _type_list;
		_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
		_tmp86_ = _tmp85_;
		_type_size = _tmp86_;
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type = NULL;
			ValaList* _tmp87_;
			gpointer _tmp88_;
			ValaDataType* _tmp89_;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp87_ = _type_list;
			_tmp88_ = vala_list_get (_tmp87_, _type_index);
			type = (ValaDataType*) _tmp88_;
			_tmp89_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp89_, context);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp90_;
		ValaList* _tmp91_;
		gint _p_size = 0;
		ValaList* _tmp92_;
		gint _tmp93_;
		gint _tmp94_;
		gint _p_index = 0;
		_tmp90_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_tmp91_ = _vala_iterable_ref0 (_tmp90_);
		_p_list = _tmp91_;
		_tmp92_ = _p_list;
		_tmp93_ = vala_collection_get_size ((ValaCollection*) _tmp92_);
		_tmp94_ = _tmp93_;
		_p_size = _tmp94_;
		_p_index = -1;
		while (TRUE) {
			ValaTypeParameter* p = NULL;
			ValaList* _tmp95_;
			gpointer _tmp96_;
			ValaTypeParameter* _tmp97_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp95_ = _p_list;
			_tmp96_ = vala_list_get (_tmp95_, _p_index);
			p = (ValaTypeParameter*) _tmp96_;
			_tmp97_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp97_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp98_;
		ValaList* _tmp99_;
		gint _en_size = 0;
		ValaList* _tmp100_;
		gint _tmp101_;
		gint _tmp102_;
		gint _en_index = 0;
		_tmp98_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_tmp99_ = _vala_iterable_ref0 (_tmp98_);
		_en_list = _tmp99_;
		_tmp100_ = _en_list;
		_tmp101_ = vala_collection_get_size ((ValaCollection*) _tmp100_);
		_tmp102_ = _tmp101_;
		_en_size = _tmp102_;
		_en_index = -1;
		while (TRUE) {
			ValaEnum* en = NULL;
			ValaList* _tmp103_;
			gpointer _tmp104_;
			ValaEnum* _tmp105_;
			_en_index = _en_index + 1;
			if (!(_en_index < _en_size)) {
				break;
			}
			_tmp103_ = _en_list;
			_tmp104_ = vala_list_get (_tmp103_, _en_index);
			en = (ValaEnum*) _tmp104_;
			_tmp105_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp105_, context);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp106_;
		ValaList* _tmp107_;
		gint _f_size = 0;
		ValaList* _tmp108_;
		gint _tmp109_;
		gint _tmp110_;
		gint _f_index = 0;
		_tmp106_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_tmp107_ = _vala_iterable_ref0 (_tmp106_);
		_f_list = _tmp107_;
		_tmp108_ = _f_list;
		_tmp109_ = vala_collection_get_size ((ValaCollection*) _tmp108_);
		_tmp110_ = _tmp109_;
		_f_size = _tmp110_;
		_f_index = -1;
		while (TRUE) {
			ValaField* f = NULL;
			ValaList* _tmp111_;
			gpointer _tmp112_;
			ValaField* _tmp113_;
			_f_index = _f_index + 1;
			if (!(_f_index < _f_size)) {
				break;
			}
			_tmp111_ = _f_list;
			_tmp112_ = vala_list_get (_tmp111_, _f_index);
			f = (ValaField*) _tmp112_;
			_tmp113_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp113_, context);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp114_;
		ValaList* _tmp115_;
		gint _c_size = 0;
		ValaList* _tmp116_;
		gint _tmp117_;
		gint _tmp118_;
		gint _c_index = 0;
		_tmp114_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_tmp115_ = _vala_iterable_ref0 (_tmp114_);
		_c_list = _tmp115_;
		_tmp116_ = _c_list;
		_tmp117_ = vala_collection_get_size ((ValaCollection*) _tmp116_);
		_tmp118_ = _tmp117_;
		_c_size = _tmp118_;
		_c_index = -1;
		while (TRUE) {
			ValaConstant* c = NULL;
			ValaList* _tmp119_;
			gpointer _tmp120_;
			ValaConstant* _tmp121_;
			_c_index = _c_index + 1;
			if (!(_c_index < _c_size)) {
				break;
			}
			_tmp119_ = _c_list;
			_tmp120_ = vala_list_get (_tmp119_, _c_index);
			c = (ValaConstant*) _tmp120_;
			_tmp121_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp121_, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	_tmp122_ = vala_code_context_get_abi_stability (context);
	_tmp123_ = _tmp122_;
	if (_tmp123_) {
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp124_;
			ValaList* _tmp125_;
			gint _s_size = 0;
			ValaList* _tmp126_;
			gint _tmp127_;
			gint _tmp128_;
			gint _s_index = 0;
			_tmp124_ = vala_object_type_symbol_get_members ((ValaObjectTypeSymbol*) self);
			_tmp125_ = _vala_iterable_ref0 (_tmp124_);
			_s_list = _tmp125_;
			_tmp126_ = _s_list;
			_tmp127_ = vala_collection_get_size ((ValaCollection*) _tmp126_);
			_tmp128_ = _tmp127_;
			_s_size = _tmp128_;
			_s_index = -1;
			while (TRUE) {
				ValaSymbol* s = NULL;
				ValaList* _tmp129_;
				gpointer _tmp130_;
				ValaSymbol* _tmp131_;
				_s_index = _s_index + 1;
				if (!(_s_index < _s_size)) {
					break;
				}
				_tmp129_ = _s_list;
				_tmp130_ = vala_list_get (_tmp129_, _s_index);
				s = (ValaSymbol*) _tmp130_;
				_tmp131_ = s;
				if (VALA_IS_METHOD (_tmp131_)) {
					ValaMethod* m = NULL;
					ValaSymbol* _tmp132_;
					ValaMethod* _tmp133_;
					ValaMethod* _tmp134_;
					gboolean _tmp135_ = FALSE;
					ValaMethod* _tmp136_;
					gboolean _tmp137_;
					gboolean _tmp138_;
					_tmp132_ = s;
					_tmp133_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp132_, VALA_TYPE_METHOD, ValaMethod));
					m = _tmp133_;
					_tmp134_ = m;
					vala_code_node_check ((ValaCodeNode*) _tmp134_, context);
					_tmp136_ = m;
					_tmp137_ = vala_method_get_is_virtual (_tmp136_);
					_tmp138_ = _tmp137_;
					if (_tmp138_) {
						_tmp135_ = TRUE;
					} else {
						ValaMethod* _tmp139_;
						gboolean _tmp140_;
						gboolean _tmp141_;
						_tmp139_ = m;
						_tmp140_ = vala_method_get_is_abstract (_tmp139_);
						_tmp141_ = _tmp140_;
						_tmp135_ = _tmp141_;
					}
					if (_tmp135_) {
						ValaList* _tmp142_;
						ValaMethod* _tmp143_;
						_tmp142_ = self->priv->virtuals;
						_tmp143_ = m;
						vala_collection_add ((ValaCollection*) _tmp142_, (ValaSymbol*) _tmp143_);
					}
					_vala_code_node_unref0 (m);
				} else {
					ValaSymbol* _tmp144_;
					_tmp144_ = s;
					if (VALA_IS_SIGNAL (_tmp144_)) {
						ValaSignal* sig = NULL;
						ValaSymbol* _tmp145_;
						ValaSignal* _tmp146_;
						ValaSignal* _tmp147_;
						ValaSignal* _tmp148_;
						gboolean _tmp149_;
						gboolean _tmp150_;
						_tmp145_ = s;
						_tmp146_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, VALA_TYPE_SIGNAL, ValaSignal));
						sig = _tmp146_;
						_tmp147_ = sig;
						vala_code_node_check ((ValaCodeNode*) _tmp147_, context);
						_tmp148_ = sig;
						_tmp149_ = vala_signal_get_is_virtual (_tmp148_);
						_tmp150_ = _tmp149_;
						if (_tmp150_) {
							ValaList* _tmp151_;
							ValaSignal* _tmp152_;
							_tmp151_ = self->priv->virtuals;
							_tmp152_ = sig;
							vala_collection_add ((ValaCollection*) _tmp151_, (ValaSymbol*) _tmp152_);
						}
						_vala_code_node_unref0 (sig);
					} else {
						ValaSymbol* _tmp153_;
						_tmp153_ = s;
						if (VALA_IS_PROPERTY (_tmp153_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp154_;
							ValaProperty* _tmp155_;
							ValaProperty* _tmp156_;
							gboolean _tmp157_ = FALSE;
							ValaProperty* _tmp158_;
							gboolean _tmp159_;
							gboolean _tmp160_;
							_tmp154_ = s;
							_tmp155_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp154_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp155_;
							_tmp156_ = prop;
							vala_code_node_check ((ValaCodeNode*) _tmp156_, context);
							_tmp158_ = prop;
							_tmp159_ = vala_property_get_is_virtual (_tmp158_);
							_tmp160_ = _tmp159_;
							if (_tmp160_) {
								_tmp157_ = TRUE;
							} else {
								ValaProperty* _tmp161_;
								gboolean _tmp162_;
								gboolean _tmp163_;
								_tmp161_ = prop;
								_tmp162_ = vala_property_get_is_abstract (_tmp161_);
								_tmp163_ = _tmp162_;
								_tmp157_ = _tmp163_;
							}
							if (_tmp157_) {
								ValaList* _tmp164_;
								ValaProperty* _tmp165_;
								_tmp164_ = self->priv->virtuals;
								_tmp165_ = prop;
								vala_collection_add ((ValaCollection*) _tmp164_, (ValaSymbol*) _tmp165_);
							}
							_vala_code_node_unref0 (prop);
						}
					}
				}
				_vala_code_node_unref0 (s);
			}
			_vala_iterable_unref0 (_s_list);
		}
	} else {
		{
			ValaList* _m_list = NULL;
			ValaList* _tmp166_;
			ValaList* _tmp167_;
			gint _m_size = 0;
			ValaList* _tmp168_;
			gint _tmp169_;
			gint _tmp170_;
			gint _m_index = 0;
			_tmp166_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
			_tmp167_ = _vala_iterable_ref0 (_tmp166_);
			_m_list = _tmp167_;
			_tmp168_ = _m_list;
			_tmp169_ = vala_collection_get_size ((ValaCollection*) _tmp168_);
			_tmp170_ = _tmp169_;
			_m_size = _tmp170_;
			_m_index = -1;
			while (TRUE) {
				ValaMethod* m = NULL;
				ValaList* _tmp171_;
				gpointer _tmp172_;
				ValaMethod* _tmp173_;
				gboolean _tmp174_ = FALSE;
				ValaMethod* _tmp175_;
				gboolean _tmp176_;
				gboolean _tmp177_;
				_m_index = _m_index + 1;
				if (!(_m_index < _m_size)) {
					break;
				}
				_tmp171_ = _m_list;
				_tmp172_ = vala_list_get (_tmp171_, _m_index);
				m = (ValaMethod*) _tmp172_;
				_tmp173_ = m;
				vala_code_node_check ((ValaCodeNode*) _tmp173_, context);
				_tmp175_ = m;
				_tmp176_ = vala_method_get_is_virtual (_tmp175_);
				_tmp177_ = _tmp176_;
				if (_tmp177_) {
					_tmp174_ = TRUE;
				} else {
					ValaMethod* _tmp178_;
					gboolean _tmp179_;
					gboolean _tmp180_;
					_tmp178_ = m;
					_tmp179_ = vala_method_get_is_abstract (_tmp178_);
					_tmp180_ = _tmp179_;
					_tmp174_ = _tmp180_;
				}
				if (_tmp174_) {
					ValaList* _tmp181_;
					ValaMethod* _tmp182_;
					_tmp181_ = self->priv->virtuals;
					_tmp182_ = m;
					vala_collection_add ((ValaCollection*) _tmp181_, (ValaSymbol*) _tmp182_);
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		{
			ValaList* _sig_list = NULL;
			ValaList* _tmp183_;
			ValaList* _tmp184_;
			gint _sig_size = 0;
			ValaList* _tmp185_;
			gint _tmp186_;
			gint _tmp187_;
			gint _sig_index = 0;
			_tmp183_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
			_tmp184_ = _vala_iterable_ref0 (_tmp183_);
			_sig_list = _tmp184_;
			_tmp185_ = _sig_list;
			_tmp186_ = vala_collection_get_size ((ValaCollection*) _tmp185_);
			_tmp187_ = _tmp186_;
			_sig_size = _tmp187_;
			_sig_index = -1;
			while (TRUE) {
				ValaSignal* sig = NULL;
				ValaList* _tmp188_;
				gpointer _tmp189_;
				ValaSignal* _tmp190_;
				ValaSignal* _tmp191_;
				gboolean _tmp192_;
				gboolean _tmp193_;
				_sig_index = _sig_index + 1;
				if (!(_sig_index < _sig_size)) {
					break;
				}
				_tmp188_ = _sig_list;
				_tmp189_ = vala_list_get (_tmp188_, _sig_index);
				sig = (ValaSignal*) _tmp189_;
				_tmp190_ = sig;
				vala_code_node_check ((ValaCodeNode*) _tmp190_, context);
				_tmp191_ = sig;
				_tmp192_ = vala_signal_get_is_virtual (_tmp191_);
				_tmp193_ = _tmp192_;
				if (_tmp193_) {
					ValaList* _tmp194_;
					ValaSignal* _tmp195_;
					_tmp194_ = self->priv->virtuals;
					_tmp195_ = sig;
					vala_collection_add ((ValaCollection*) _tmp194_, (ValaSymbol*) _tmp195_);
				}
				_vala_code_node_unref0 (sig);
			}
			_vala_iterable_unref0 (_sig_list);
		}
		{
			ValaList* _prop_list = NULL;
			ValaList* _tmp196_;
			ValaList* _tmp197_;
			gint _prop_size = 0;
			ValaList* _tmp198_;
			gint _tmp199_;
			gint _tmp200_;
			gint _prop_index = 0;
			_tmp196_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
			_tmp197_ = _vala_iterable_ref0 (_tmp196_);
			_prop_list = _tmp197_;
			_tmp198_ = _prop_list;
			_tmp199_ = vala_collection_get_size ((ValaCollection*) _tmp198_);
			_tmp200_ = _tmp199_;
			_prop_size = _tmp200_;
			_prop_index = -1;
			while (TRUE) {
				ValaProperty* prop = NULL;
				ValaList* _tmp201_;
				gpointer _tmp202_;
				ValaProperty* _tmp203_;
				gboolean _tmp204_ = FALSE;
				ValaProperty* _tmp205_;
				gboolean _tmp206_;
				gboolean _tmp207_;
				_prop_index = _prop_index + 1;
				if (!(_prop_index < _prop_size)) {
					break;
				}
				_tmp201_ = _prop_list;
				_tmp202_ = vala_list_get (_tmp201_, _prop_index);
				prop = (ValaProperty*) _tmp202_;
				_tmp203_ = prop;
				vala_code_node_check ((ValaCodeNode*) _tmp203_, context);
				_tmp205_ = prop;
				_tmp206_ = vala_property_get_is_virtual (_tmp205_);
				_tmp207_ = _tmp206_;
				if (_tmp207_) {
					_tmp204_ = TRUE;
				} else {
					ValaProperty* _tmp208_;
					gboolean _tmp209_;
					gboolean _tmp210_;
					_tmp208_ = prop;
					_tmp209_ = vala_property_get_is_abstract (_tmp208_);
					_tmp210_ = _tmp209_;
					_tmp204_ = _tmp210_;
				}
				if (_tmp204_) {
					ValaList* _tmp211_;
					ValaProperty* _tmp212_;
					_tmp211_ = self->priv->virtuals;
					_tmp212_ = prop;
					vala_collection_add ((ValaCollection*) _tmp211_, (ValaSymbol*) _tmp212_);
				}
				_vala_code_node_unref0 (prop);
			}
			_vala_iterable_unref0 (_prop_list);
		}
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp213_;
		ValaList* _tmp214_;
		gint _cl_size = 0;
		ValaList* _tmp215_;
		gint _tmp216_;
		gint _tmp217_;
		gint _cl_index = 0;
		_tmp213_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_tmp214_ = _vala_iterable_ref0 (_tmp213_);
		_cl_list = _tmp214_;
		_tmp215_ = _cl_list;
		_tmp216_ = vala_collection_get_size ((ValaCollection*) _tmp215_);
		_tmp217_ = _tmp216_;
		_cl_size = _tmp217_;
		_cl_index = -1;
		while (TRUE) {
			ValaClass* cl = NULL;
			ValaList* _tmp218_;
			gpointer _tmp219_;
			ValaClass* _tmp220_;
			_cl_index = _cl_index + 1;
			if (!(_cl_index < _cl_size)) {
				break;
			}
			_tmp218_ = _cl_list;
			_tmp219_ = vala_list_get (_tmp218_, _cl_index);
			cl = (ValaClass*) _tmp219_;
			_tmp220_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp220_, context);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _iface_list = NULL;
		ValaList* _tmp221_;
		ValaList* _tmp222_;
		gint _iface_size = 0;
		ValaList* _tmp223_;
		gint _tmp224_;
		gint _tmp225_;
		gint _iface_index = 0;
		_tmp221_ = vala_object_type_symbol_get_interfaces ((ValaObjectTypeSymbol*) self);
		_tmp222_ = _vala_iterable_ref0 (_tmp221_);
		_iface_list = _tmp222_;
		_tmp223_ = _iface_list;
		_tmp224_ = vala_collection_get_size ((ValaCollection*) _tmp223_);
		_tmp225_ = _tmp224_;
		_iface_size = _tmp225_;
		_iface_index = -1;
		while (TRUE) {
			ValaInterface* iface = NULL;
			ValaList* _tmp226_;
			gpointer _tmp227_;
			ValaInterface* _tmp228_;
			_iface_index = _iface_index + 1;
			if (!(_iface_index < _iface_size)) {
				break;
			}
			_tmp226_ = _iface_list;
			_tmp227_ = vala_list_get (_tmp226_, _iface_index);
			iface = (ValaInterface*) _tmp227_;
			_tmp228_ = iface;
			vala_code_node_check ((ValaCodeNode*) _tmp228_, context);
			_vala_code_node_unref0 (iface);
		}
		_vala_iterable_unref0 (_iface_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp229_;
		ValaList* _tmp230_;
		gint _st_size = 0;
		ValaList* _tmp231_;
		gint _tmp232_;
		gint _tmp233_;
		gint _st_index = 0;
		_tmp229_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_tmp230_ = _vala_iterable_ref0 (_tmp229_);
		_st_list = _tmp230_;
		_tmp231_ = _st_list;
		_tmp232_ = vala_collection_get_size ((ValaCollection*) _tmp231_);
		_tmp233_ = _tmp232_;
		_st_size = _tmp233_;
		_st_index = -1;
		while (TRUE) {
			ValaStruct* st = NULL;
			ValaList* _tmp234_;
			gpointer _tmp235_;
			ValaStruct* _tmp236_;
			_st_index = _st_index + 1;
			if (!(_st_index < _st_size)) {
				break;
			}
			_tmp234_ = _st_list;
			_tmp235_ = vala_list_get (_tmp234_, _st_index);
			st = (ValaStruct*) _tmp235_;
			_tmp236_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp236_, context);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp237_;
		ValaList* _tmp238_;
		gint _d_size = 0;
		ValaList* _tmp239_;
		gint _tmp240_;
		gint _tmp241_;
		gint _d_index = 0;
		_tmp237_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_tmp238_ = _vala_iterable_ref0 (_tmp237_);
		_d_list = _tmp238_;
		_tmp239_ = _d_list;
		_tmp240_ = vala_collection_get_size ((ValaCollection*) _tmp239_);
		_tmp241_ = _tmp240_;
		_d_size = _tmp241_;
		_d_index = -1;
		while (TRUE) {
			ValaDelegate* d = NULL;
			ValaList* _tmp242_;
			gpointer _tmp243_;
			ValaDelegate* _tmp244_;
			_d_index = _d_index + 1;
			if (!(_d_index < _d_size)) {
				break;
			}
			_tmp242_ = _d_list;
			_tmp243_ = vala_list_get (_tmp242_, _d_index);
			d = (ValaDelegate*) _tmp243_;
			_tmp244_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp244_, context);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp245_ = g_direct_hash;
	_tmp246_ = g_direct_equal;
	_tmp247_ = g_direct_equal;
	_tmp248_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp245_, _tmp246_, _tmp247_);
	positions = (ValaMap*) _tmp248_;
	ordered_seen = FALSE;
	unordered_seen = FALSE;
	{
		ValaList* _sym_list = NULL;
		ValaList* _tmp249_;
		ValaList* _tmp250_;
		gint _sym_size = 0;
		ValaList* _tmp251_;
		gint _tmp252_;
		gint _tmp253_;
		gint _sym_index = 0;
		_tmp249_ = self->priv->virtuals;
		_tmp250_ = _vala_iterable_ref0 (_tmp249_);
		_sym_list = _tmp250_;
		_tmp251_ = _sym_list;
		_tmp252_ = vala_collection_get_size ((ValaCollection*) _tmp251_);
		_tmp253_ = _tmp252_;
		_sym_size = _tmp253_;
		_sym_index = -1;
		while (TRUE) {
			ValaSymbol* sym = NULL;
			ValaList* _tmp254_;
			gpointer _tmp255_;
			gint ordering = 0;
			ValaSymbol* _tmp256_;
			gboolean ordered = FALSE;
			gboolean _tmp265_ = FALSE;
			gboolean _tmp266_ = FALSE;
			gboolean _tmp275_ = FALSE;
			gboolean _tmp276_ = FALSE;
			gboolean _tmp277_ = FALSE;
			gboolean _tmp286_ = FALSE;
			gboolean _tmp287_ = FALSE;
			_sym_index = _sym_index + 1;
			if (!(_sym_index < _sym_size)) {
				break;
			}
			_tmp254_ = _sym_list;
			_tmp255_ = vala_list_get (_tmp254_, _sym_index);
			sym = (ValaSymbol*) _tmp255_;
			_tmp256_ = sym;
			ordering = vala_code_node_get_attribute_integer ((ValaCodeNode*) _tmp256_, "CCode", "ordering", -1);
			if (ordering < -1) {
				ValaSymbol* _tmp257_;
				ValaSourceReference* _tmp258_;
				ValaSourceReference* _tmp259_;
				ValaSymbol* _tmp260_;
				gchar* _tmp261_;
				gchar* _tmp262_;
				gchar* _tmp263_;
				gchar* _tmp264_;
				_tmp257_ = sym;
				_tmp258_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp257_);
				_tmp259_ = _tmp258_;
				_tmp260_ = sym;
				_tmp261_ = vala_symbol_get_full_name (_tmp260_);
				_tmp262_ = _tmp261_;
				_tmp263_ = g_strdup_printf ("%s: Invalid ordering", _tmp262_);
				_tmp264_ = _tmp263_;
				vala_report_error (_tmp259_, _tmp264_);
				_g_free0 (_tmp264_);
				_g_free0 (_tmp262_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				ordered_seen = TRUE;
				unordered_seen = TRUE;
				_vala_code_node_unref0 (sym);
				continue;
			}
			ordered = ordering != -1;
			if (ordered) {
				_tmp266_ = unordered_seen;
			} else {
				_tmp266_ = FALSE;
			}
			if (_tmp266_) {
				_tmp265_ = !ordered_seen;
			} else {
				_tmp265_ = FALSE;
			}
			if (_tmp265_) {
				ValaSymbol* _tmp267_;
				ValaSourceReference* _tmp268_;
				ValaSourceReference* _tmp269_;
				ValaSymbol* _tmp270_;
				gchar* _tmp271_;
				gchar* _tmp272_;
				gchar* _tmp273_;
				gchar* _tmp274_;
				_tmp267_ = sym;
				_tmp268_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp267_);
				_tmp269_ = _tmp268_;
				_tmp270_ = sym;
				_tmp271_ = vala_symbol_get_full_name (_tmp270_);
				_tmp272_ = _tmp271_;
				_tmp273_ = g_strdup_printf ("%s: Cannot mix ordered and unordered virtuals", _tmp272_);
				_tmp274_ = _tmp273_;
				vala_report_error (_tmp269_, _tmp274_);
				_g_free0 (_tmp274_);
				_g_free0 (_tmp272_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			if (ordered_seen) {
				_tmp275_ = TRUE;
			} else {
				_tmp275_ = ordered;
			}
			ordered_seen = _tmp275_;
			if (!ordered) {
				_tmp277_ = !unordered_seen;
			} else {
				_tmp277_ = FALSE;
			}
			if (_tmp277_) {
				_tmp276_ = ordered_seen;
			} else {
				_tmp276_ = FALSE;
			}
			if (_tmp276_) {
				ValaSymbol* _tmp278_;
				ValaSourceReference* _tmp279_;
				ValaSourceReference* _tmp280_;
				ValaSymbol* _tmp281_;
				gchar* _tmp282_;
				gchar* _tmp283_;
				gchar* _tmp284_;
				gchar* _tmp285_;
				_tmp278_ = sym;
				_tmp279_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp278_);
				_tmp280_ = _tmp279_;
				_tmp281_ = sym;
				_tmp282_ = vala_symbol_get_full_name (_tmp281_);
				_tmp283_ = _tmp282_;
				_tmp284_ = g_strdup_printf ("%s: Cannot mix ordered and unordered virtuals", _tmp283_);
				_tmp285_ = _tmp284_;
				vala_report_error (_tmp280_, _tmp285_);
				_g_free0 (_tmp285_);
				_g_free0 (_tmp283_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			if (unordered_seen) {
				_tmp286_ = TRUE;
			} else {
				_tmp286_ = !ordered;
			}
			unordered_seen = _tmp286_;
			if (!ordered_seen) {
				_tmp287_ = TRUE;
			} else {
				_tmp287_ = !unordered_seen;
			}
			if (_tmp287_) {
				if (ordered) {
					ValaSymbol* prev = NULL;
					ValaMap* _tmp288_;
					gpointer _tmp289_;
					ValaSymbol* _tmp290_;
					ValaMap* _tmp302_;
					ValaSymbol* _tmp303_;
					_tmp288_ = positions;
					_tmp289_ = vala_map_get (_tmp288_, (gpointer) ((gintptr) ordering));
					prev = (ValaSymbol*) _tmp289_;
					_tmp290_ = prev;
					if (_tmp290_ != NULL) {
						ValaSymbol* _tmp291_;
						ValaSourceReference* _tmp292_;
						ValaSourceReference* _tmp293_;
						ValaSymbol* _tmp294_;
						gchar* _tmp295_;
						gchar* _tmp296_;
						ValaSymbol* _tmp297_;
						const gchar* _tmp298_;
						const gchar* _tmp299_;
						gchar* _tmp300_;
						gchar* _tmp301_;
						_tmp291_ = sym;
						_tmp292_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp291_);
						_tmp293_ = _tmp292_;
						_tmp294_ = sym;
						_tmp295_ = vala_symbol_get_full_name (_tmp294_);
						_tmp296_ = _tmp295_;
						_tmp297_ = prev;
						_tmp298_ = vala_symbol_get_name (_tmp297_);
						_tmp299_ = _tmp298_;
						_tmp300_ = g_strdup_printf ("%s: Duplicate ordering (previous virtual with the same position is %s)", _tmp296_, _tmp299_);
						_tmp301_ = _tmp300_;
						vala_report_error (_tmp293_, _tmp301_);
						_g_free0 (_tmp301_);
						_g_free0 (_tmp296_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp302_ = positions;
					_tmp303_ = sym;
					vala_map_set (_tmp302_, (gpointer) ((gintptr) ordering), _tmp303_);
					_vala_code_node_unref0 (prev);
				}
			}
			_vala_code_node_unref0 (sym);
		}
		_vala_iterable_unref0 (_sym_list);
	}
	if (ordered_seen) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp304_ = FALSE;
				_tmp304_ = TRUE;
				while (TRUE) {
					ValaList* _tmp306_;
					gint _tmp307_;
					gint _tmp308_;
					ValaSymbol* sym = NULL;
					ValaMap* _tmp309_;
					gpointer _tmp310_;
					ValaSymbol* _tmp311_;
					gboolean _tmp318_;
					gboolean _tmp319_;
					if (!_tmp304_) {
						gint _tmp305_;
						_tmp305_ = i;
						i = _tmp305_ + 1;
					}
					_tmp304_ = FALSE;
					_tmp306_ = self->priv->virtuals;
					_tmp307_ = vala_collection_get_size ((ValaCollection*) _tmp306_);
					_tmp308_ = _tmp307_;
					if (!(i < _tmp308_)) {
						break;
					}
					_tmp309_ = positions;
					_tmp310_ = vala_map_get (_tmp309_, (gpointer) ((gintptr) i));
					sym = (ValaSymbol*) _tmp310_;
					_tmp311_ = sym;
					if (_tmp311_ == NULL) {
						ValaSourceReference* _tmp312_;
						ValaSourceReference* _tmp313_;
						gchar* _tmp314_;
						gchar* _tmp315_;
						gchar* _tmp316_;
						gchar* _tmp317_;
						_tmp312_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp313_ = _tmp312_;
						_tmp314_ = vala_symbol_get_full_name ((ValaSymbol*) self);
						_tmp315_ = _tmp314_;
						_tmp316_ = g_strdup_printf ("%s: Gap in ordering in position %d", _tmp315_, i);
						_tmp317_ = _tmp316_;
						vala_report_error (_tmp313_, _tmp317_);
						_g_free0 (_tmp317_);
						_g_free0 (_tmp315_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp318_ = vala_code_node_get_error ((ValaCodeNode*) self);
					_tmp319_ = _tmp318_;
					if (!_tmp319_) {
						ValaList* _tmp320_;
						ValaSymbol* _tmp321_;
						_tmp320_ = self->priv->virtuals;
						_tmp321_ = sym;
						vala_list_set (_tmp320_, i, _tmp321_);
					}
					_vala_code_node_unref0 (sym);
				}
			}
		}
	}
	_tmp322_ = vala_code_context_get_analyzer (context);
	_tmp323_ = _tmp322_;
	_tmp324_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp323_, _tmp324_);
	_tmp325_ = vala_code_context_get_analyzer (context);
	_tmp326_ = _tmp325_;
	_tmp327_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp326_, _tmp327_);
	_tmp328_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp329_ = _tmp328_;
	result = !_tmp329_;
	_vala_map_unref0 (positions);
	_vala_code_node_unref0 (prereq_class);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_interface_class_init (ValaInterfaceClass * klass,
                           gpointer klass_data)
{
	vala_interface_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_interface_finalize;
	g_type_class_adjust_private_offset (klass, &ValaInterface_private_offset);
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_interface_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_interface_real_add_property;
	((ValaInterfaceClass *) klass)->get_virtuals = (ValaList* (*) (ValaInterface*)) vala_interface_real_get_virtuals;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_interface_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_interface_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_interface_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_interface_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_interface_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_interface_real_check;
}

static void
vala_interface_instance_init (ValaInterface * self,
                              gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_interface_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->prerequisites = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->virtuals = (ValaList*) _tmp3_;
}

static void
vala_interface_finalize (ValaCodeNode * obj)
{
	ValaInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INTERFACE, ValaInterface);
	_vala_iterable_unref0 (self->priv->prerequisites);
	_vala_iterable_unref0 (self->priv->virtuals);
	VALA_CODE_NODE_CLASS (vala_interface_parent_class)->finalize (obj);
}

/**
 * Represents a class declaration in the source code.
 */
static GType
vala_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInterface), 0, (GInstanceInitFunc) vala_interface_instance_init, NULL };
	GType vala_interface_type_id;
	vala_interface_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaInterface", &g_define_type_info, 0);
	ValaInterface_private_offset = g_type_add_instance_private (vala_interface_type_id, sizeof (ValaInterfacePrivate));
	return vala_interface_type_id;
}

GType
vala_interface_get_type (void)
{
	static volatile gsize vala_interface_type_id__volatile = 0;
	if (g_once_init_enter (&vala_interface_type_id__volatile)) {
		GType vala_interface_type_id;
		vala_interface_type_id = vala_interface_get_type_once ();
		g_once_init_leave (&vala_interface_type_id__volatile, vala_interface_type_id);
	}
	return vala_interface_type_id__volatile;
}

