/* valaconstant.c generated by valac, the Vala compiler
 * generated from valaconstant.vala, do not modify */

/* valaconstant.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaConstantPrivate {
	gboolean lock_used;
	ValaDataType* _data_type;
	ValaExpression* _value;
};


static gpointer vala_constant_parent_class = NULL;
static ValaLockableIface * vala_constant_vala_lockable_parent_iface = NULL;

#define VALA_CONSTANT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CONSTANT, ValaConstantPrivate))
static void vala_constant_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor);
static void vala_constant_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static gboolean vala_constant_real_get_lock_used (ValaLockable* base);
static void vala_constant_real_set_lock_used (ValaLockable* base,
                                       gboolean used);
static void vala_constant_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node);
static void vala_constant_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type);
static gboolean vala_constant_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context);
static gboolean vala_constant_check_const_type (ValaConstant* self,
                                         ValaDataType* type,
                                         ValaCodeContext* context);
static void vala_constant_finalize (ValaCodeNode * obj);


/**
 * Creates a new constant.
 *
 * @param name             constant name
 * @param type_reference   constant type
 * @param value            constant value
 * @param source_reference reference to source code
 * @return                 newly created constant
 */
ValaConstant*
vala_constant_construct (GType object_type,
                         const gchar* name,
                         ValaDataType* type_reference,
                         ValaExpression* value,
                         ValaSourceReference* source_reference,
                         ValaComment* comment)
{
	ValaConstant* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaConstant*) vala_symbol_construct (object_type, name, source_reference, comment);
	if (type_reference != NULL) {
		vala_constant_set_type_reference (self, type_reference);
	}
	vala_constant_set_value (self, value);
	return self;
}


ValaConstant*
vala_constant_new (const gchar* name,
                   ValaDataType* type_reference,
                   ValaExpression* value,
                   ValaSourceReference* source_reference,
                   ValaComment* comment)
{
	return vala_constant_construct (VALA_TYPE_CONSTANT, name, type_reference, value, source_reference, comment);
}


static void
vala_constant_real_accept (ValaCodeNode* base,
                           ValaCodeVisitor* visitor)
{
	ValaConstant * self;
	self = (ValaConstant*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_constant (visitor, self);
}


static void
vala_constant_real_accept_children (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaConstant * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaConstant*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_constant_get_type_reference (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_constant_get_value (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_constant_get_value (self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
}


static gboolean
vala_constant_real_get_lock_used (ValaLockable* base)
{
	ValaConstant * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (ValaConstant*) base;
	_tmp0_ = self->priv->lock_used;
	result = _tmp0_;
	return result;
}


static void
vala_constant_real_set_lock_used (ValaLockable* base,
                                  gboolean used)
{
	ValaConstant * self;
	self = (ValaConstant*) base;
	self->priv->lock_used = used;
}


static void
vala_constant_real_replace_expression (ValaCodeNode* base,
                                       ValaExpression* old_node,
                                       ValaExpression* new_node)
{
	ValaConstant * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaConstant*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_constant_get_value (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_constant_set_value (self, new_node);
	}
}


static void
vala_constant_real_replace_type (ValaCodeNode* base,
                                 ValaDataType* old_type,
                                 ValaDataType* new_type)
{
	ValaConstant * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaConstant*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_constant_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_constant_set_type_reference (self, new_type);
	}
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_constant_real_check (ValaCodeNode* base,
                          ValaCodeContext* context)
{
	ValaConstant * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSymbol* _tmp22_;
	ValaSymbol* _tmp23_;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	gboolean _tmp38_;
	gboolean _tmp39_;
	gboolean _tmp107_ = FALSE;
	gboolean _tmp108_ = FALSE;
	gboolean _tmp109_;
	gboolean _tmp110_;
	ValaSemanticAnalyzer* _tmp125_;
	ValaSemanticAnalyzer* _tmp126_;
	ValaSourceFile* _tmp127_;
	ValaSemanticAnalyzer* _tmp128_;
	ValaSemanticAnalyzer* _tmp129_;
	ValaSymbol* _tmp130_;
	gboolean _tmp131_;
	gboolean _tmp132_;
	self = (ValaConstant*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp23_ = _tmp22_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, VALA_TYPE_BLOCK)) {
		ValaSemanticAnalyzer* _tmp24_;
		ValaSemanticAnalyzer* _tmp25_;
		_tmp24_ = vala_code_context_get_analyzer (context);
		_tmp25_ = _tmp24_;
		vala_semantic_analyzer_set_current_symbol (_tmp25_, (ValaSymbol*) self);
	}
	_tmp26_ = vala_constant_get_type_reference (self);
	_tmp27_ = _tmp26_;
	vala_code_node_check ((ValaCodeNode*) _tmp27_, context);
	_tmp28_ = vala_constant_get_type_reference (self);
	_tmp29_ = _tmp28_;
	if (!vala_constant_check_const_type (self, _tmp29_, context)) {
		ValaSourceReference* _tmp30_;
		ValaSourceReference* _tmp31_;
		ValaDataType* _tmp32_;
		ValaDataType* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_constant_get_type_reference (self);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_code_node_to_string ((ValaCodeNode*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strdup_printf ("`%s' not supported as type for constants", _tmp35_);
		_tmp37_ = _tmp36_;
		vala_report_error (_tmp31_, _tmp37_);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp35_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp38_ = vala_symbol_get_external ((ValaSymbol*) self);
	_tmp39_ = _tmp38_;
	if (!_tmp39_) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		_tmp40_ = vala_constant_get_value (self);
		_tmp41_ = _tmp40_;
		if (_tmp41_ == NULL) {
			ValaSourceReference* _tmp42_;
			ValaSourceReference* _tmp43_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp43_ = _tmp42_;
			vala_report_error (_tmp43_, "A const field requires a value to be provided");
		} else {
			ValaExpression* _tmp44_;
			ValaExpression* _tmp45_;
			ValaDataType* _tmp46_;
			ValaDataType* _tmp47_;
			ValaExpression* _tmp48_;
			ValaExpression* _tmp49_;
			ValaExpression* _tmp50_;
			ValaExpression* _tmp51_;
			ValaDataType* _tmp52_;
			ValaDataType* _tmp53_;
			ValaDataType* _tmp54_;
			ValaDataType* _tmp55_;
			ValaMethodCall* call = NULL;
			ValaExpression* _tmp70_;
			ValaExpression* _tmp71_;
			ValaMethodCall* _tmp72_;
			ValaMethodCall* _tmp73_;
			ValaExpression* _tmp97_;
			ValaExpression* _tmp98_;
			_tmp44_ = vala_constant_get_value (self);
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_constant_get_type_reference (self);
			_tmp47_ = _tmp46_;
			vala_expression_set_target_type (_tmp45_, _tmp47_);
			_tmp48_ = vala_constant_get_value (self);
			_tmp49_ = _tmp48_;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp49_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp50_ = vala_constant_get_value (self);
			_tmp51_ = _tmp50_;
			_tmp52_ = vala_expression_get_value_type (_tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_constant_get_type_reference (self);
			_tmp55_ = _tmp54_;
			if (!vala_data_type_compatible (_tmp53_, _tmp55_)) {
				ValaSourceReference* _tmp56_;
				ValaSourceReference* _tmp57_;
				ValaExpression* _tmp58_;
				ValaExpression* _tmp59_;
				ValaDataType* _tmp60_;
				ValaDataType* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				ValaDataType* _tmp64_;
				ValaDataType* _tmp65_;
				gchar* _tmp66_;
				gchar* _tmp67_;
				gchar* _tmp68_;
				gchar* _tmp69_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp56_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp57_ = _tmp56_;
				_tmp58_ = vala_constant_get_value (self);
				_tmp59_ = _tmp58_;
				_tmp60_ = vala_expression_get_value_type (_tmp59_);
				_tmp61_ = _tmp60_;
				_tmp62_ = vala_code_node_to_string ((ValaCodeNode*) _tmp61_);
				_tmp63_ = _tmp62_;
				_tmp64_ = vala_constant_get_type_reference (self);
				_tmp65_ = _tmp64_;
				_tmp66_ = vala_code_node_to_string ((ValaCodeNode*) _tmp65_);
				_tmp67_ = _tmp66_;
				_tmp68_ = g_strdup_printf ("Cannot convert from `%s' to `%s'", _tmp63_, _tmp67_);
				_tmp69_ = _tmp68_;
				vala_report_error (_tmp57_, _tmp69_);
				_g_free0 (_tmp69_);
				_g_free0 (_tmp67_);
				_g_free0 (_tmp63_);
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp70_ = vala_constant_get_value (self);
			_tmp71_ = _tmp70_;
			_tmp72_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp71_, VALA_TYPE_METHOD_CALL) ? ((ValaMethodCall*) _tmp71_) : NULL);
			call = _tmp72_;
			_tmp73_ = call;
			if (_tmp73_ != NULL) {
				ValaMethodType* method_type = NULL;
				ValaMethodCall* _tmp74_;
				ValaExpression* _tmp75_;
				ValaExpression* _tmp76_;
				ValaDataType* _tmp77_;
				ValaDataType* _tmp78_;
				ValaMethodType* _tmp79_;
				gboolean _tmp80_ = FALSE;
				ValaMethodType* _tmp81_;
				_tmp74_ = call;
				_tmp75_ = vala_method_call_get_call (_tmp74_);
				_tmp76_ = _tmp75_;
				_tmp77_ = vala_expression_get_value_type (_tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp78_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp78_) : NULL);
				method_type = _tmp79_;
				_tmp81_ = method_type;
				if (_tmp81_ != NULL) {
					ValaMethodType* _tmp82_;
					ValaMethod* _tmp83_;
					ValaMethod* _tmp84_;
					gchar* _tmp85_;
					gchar* _tmp86_;
					_tmp82_ = method_type;
					_tmp83_ = vala_method_type_get_method_symbol (_tmp82_);
					_tmp84_ = _tmp83_;
					_tmp85_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp84_);
					_tmp86_ = _tmp85_;
					_tmp80_ = g_strcmp0 (_tmp86_, "GLib._") == 0;
					_g_free0 (_tmp86_);
				} else {
					_tmp80_ = FALSE;
				}
				if (_tmp80_) {
					ValaStringLiteral* literal = NULL;
					ValaMethodCall* _tmp87_;
					ValaList* _tmp88_;
					ValaList* _tmp89_;
					gpointer _tmp90_;
					ValaExpression* _tmp91_;
					ValaStringLiteral* _tmp92_;
					ValaStringLiteral* _tmp93_;
					ValaStringLiteral* _tmp94_;
					_tmp87_ = call;
					_tmp88_ = vala_method_call_get_argument_list (_tmp87_);
					_tmp89_ = _tmp88_;
					_tmp90_ = vala_list_get (_tmp89_, 0);
					_tmp91_ = (ValaExpression*) _tmp90_;
					_tmp92_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp91_, VALA_TYPE_STRING_LITERAL) ? ((ValaStringLiteral*) _tmp91_) : NULL;
					if (_tmp92_ == NULL) {
						_vala_code_node_unref0 (_tmp91_);
					}
					_tmp93_ = _tmp92_;
					_vala_iterable_unref0 (_tmp89_);
					literal = _tmp93_;
					_tmp94_ = literal;
					if (_tmp94_ != NULL) {
						ValaStringLiteral* _tmp95_;
						ValaStringLiteral* _tmp96_;
						_tmp95_ = literal;
						vala_constant_set_value (self, (ValaExpression*) _tmp95_);
						_tmp96_ = literal;
						vala_string_literal_set_translate (_tmp96_, TRUE);
					}
					_vala_code_node_unref0 (literal);
				}
				_vala_code_node_unref0 (method_type);
			}
			_tmp97_ = vala_constant_get_value (self);
			_tmp98_ = _tmp97_;
			if (!vala_expression_is_constant (_tmp98_)) {
				ValaExpression* _tmp99_;
				ValaExpression* _tmp100_;
				ValaSourceReference* _tmp101_;
				ValaSourceReference* _tmp102_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp99_ = vala_constant_get_value (self);
				_tmp100_ = _tmp99_;
				_tmp101_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp100_);
				_tmp102_ = _tmp101_;
				vala_report_error (_tmp102_, "Value must be constant");
				result = FALSE;
				_vala_code_node_unref0 (call);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (call);
		}
	} else {
		ValaExpression* _tmp103_;
		ValaExpression* _tmp104_;
		_tmp103_ = vala_constant_get_value (self);
		_tmp104_ = _tmp103_;
		if (_tmp104_ != NULL) {
			ValaSourceReference* _tmp105_;
			ValaSourceReference* _tmp106_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp105_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp106_ = _tmp105_;
			vala_report_error (_tmp106_, "External constants cannot use values");
		}
	}
	_tmp109_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp110_ = _tmp109_;
	if (!_tmp110_) {
		gboolean _tmp111_;
		gboolean _tmp112_;
		_tmp111_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp112_ = _tmp111_;
		_tmp108_ = !_tmp112_;
	} else {
		_tmp108_ = FALSE;
	}
	if (_tmp108_) {
		ValaSymbol* _tmp113_;
		ValaSymbol* _tmp114_;
		_tmp113_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp114_ = _tmp113_;
		_tmp107_ = _tmp114_ != NULL;
		_vala_code_node_unref0 (_tmp114_);
	} else {
		_tmp107_ = FALSE;
	}
	if (_tmp107_) {
		ValaSourceReference* _tmp115_;
		ValaSourceReference* _tmp116_;
		gchar* _tmp117_;
		gchar* _tmp118_;
		ValaSymbol* _tmp119_;
		ValaSymbol* _tmp120_;
		gchar* _tmp121_;
		gchar* _tmp122_;
		gchar* _tmp123_;
		gchar* _tmp124_;
		_tmp115_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp116_ = _tmp115_;
		_tmp117_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp118_ = _tmp117_;
		_tmp119_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp120_ = _tmp119_;
		_tmp121_ = vala_symbol_get_full_name (_tmp120_);
		_tmp122_ = _tmp121_;
		_tmp123_ = g_strdup_printf ("%s hides inherited constant `%s'. Use the `new' keyword if hiding was " \
"intentional", _tmp118_, _tmp122_);
		_tmp124_ = _tmp123_;
		vala_report_warning (_tmp116_, _tmp124_);
		_g_free0 (_tmp124_);
		_g_free0 (_tmp122_);
		_vala_code_node_unref0 (_tmp120_);
		_g_free0 (_tmp118_);
	}
	_tmp125_ = vala_code_context_get_analyzer (context);
	_tmp126_ = _tmp125_;
	_tmp127_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp126_, _tmp127_);
	_tmp128_ = vala_code_context_get_analyzer (context);
	_tmp129_ = _tmp128_;
	_tmp130_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp129_, _tmp130_);
	vala_symbol_set_active ((ValaSymbol*) self, TRUE);
	_tmp131_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp132_ = _tmp131_;
	result = !_tmp132_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


static gboolean
vala_constant_check_const_type (ValaConstant* self,
                                ValaDataType* type,
                                ValaCodeContext* context)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_VALUE_TYPE)) {
		result = TRUE;
		return result;
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_ARRAY_TYPE)) {
			ValaArrayType* array_type = NULL;
			ValaArrayType* _tmp0_;
			ValaArrayType* _tmp1_;
			ValaDataType* _tmp2_;
			ValaDataType* _tmp3_;
			_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) type) : NULL);
			array_type = _tmp0_;
			_tmp1_ = array_type;
			_tmp2_ = vala_array_type_get_element_type (_tmp1_);
			_tmp3_ = _tmp2_;
			result = vala_constant_check_const_type (self, _tmp3_, context);
			_vala_code_node_unref0 (array_type);
			return result;
		} else {
			ValaTypeSymbol* _tmp4_;
			ValaTypeSymbol* _tmp5_;
			ValaSemanticAnalyzer* _tmp6_;
			ValaSemanticAnalyzer* _tmp7_;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			_tmp4_ = vala_data_type_get_data_type (type);
			_tmp5_ = _tmp4_;
			_tmp6_ = vala_code_context_get_analyzer (context);
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_->string_type;
			_tmp9_ = vala_data_type_get_data_type (_tmp8_);
			_tmp10_ = _tmp9_;
			if (vala_typesymbol_is_subtype_of (_tmp5_, _tmp10_)) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}


ValaDataType*
vala_constant_get_type_reference (ValaConstant* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}


void
vala_constant_set_type_reference (ValaConstant* self,
                                  ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	_tmp1_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


ValaExpression*
vala_constant_get_value (ValaConstant* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value;
	result = _tmp0_;
	return result;
}


void
vala_constant_set_value (ValaConstant* self,
                         ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_value);
	self->priv->_value = _tmp0_;
	_tmp1_ = self->priv->_value;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_value;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}


static void
vala_constant_class_init (ValaConstantClass * klass)
{
	vala_constant_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_constant_finalize;
	g_type_class_add_private (klass, sizeof (ValaConstantPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_constant_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_constant_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_constant_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_constant_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_constant_real_check;
}


static void
vala_constant_vala_lockable_interface_init (ValaLockableIface * iface)
{
	vala_constant_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = (gboolean (*) (ValaLockable *)) vala_constant_real_get_lock_used;
	iface->set_lock_used = (void (*) (ValaLockable *, gboolean)) vala_constant_real_set_lock_used;
}


static void
vala_constant_instance_init (ValaConstant * self)
{
	self->priv = VALA_CONSTANT_GET_PRIVATE (self);
	self->priv->lock_used = FALSE;
}


static void
vala_constant_finalize (ValaCodeNode * obj)
{
	ValaConstant * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CONSTANT, ValaConstant);
	_vala_code_node_unref0 (self->priv->_data_type);
	_vala_code_node_unref0 (self->priv->_value);
	VALA_CODE_NODE_CLASS (vala_constant_parent_class)->finalize (obj);
}


/**
 * Represents a type member with a constant value.
 */
GType
vala_constant_get_type (void)
{
	static volatile gsize vala_constant_type_id__volatile = 0;
	if (g_once_init_enter (&vala_constant_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaConstantClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_constant_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaConstant), 0, (GInstanceInitFunc) vala_constant_instance_init, NULL };
		static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_constant_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_constant_type_id;
		vala_constant_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaConstant", &g_define_type_info, 0);
		g_type_add_interface_static (vala_constant_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
		g_once_init_leave (&vala_constant_type_id__volatile, vala_constant_type_id);
	}
	return vala_constant_type_id__volatile;
}



