/* valaunaryexpression.c generated by valac, the Vala compiler
 * generated from valaunaryexpression.vala, do not modify */

/* valaunaryexpression.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaUnaryExpressionPrivate {
	ValaUnaryOperator _operator;
	ValaExpression* _inner;
};


static gpointer vala_unary_expression_parent_class = NULL;

#define VALA_UNARY_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpressionPrivate))
static void vala_unary_expression_real_accept (ValaCodeNode* base,
                                        ValaCodeVisitor* visitor);
static void vala_unary_expression_real_accept_children (ValaCodeNode* base,
                                                 ValaCodeVisitor* visitor);
static void vala_unary_expression_real_replace_expression (ValaCodeNode* base,
                                                    ValaExpression* old_node,
                                                    ValaExpression* new_node);
static const gchar* vala_unary_expression_get_operator_string (ValaUnaryExpression* self);
static gchar* vala_unary_expression_real_to_string (ValaCodeNode* base);
static gboolean vala_unary_expression_real_is_constant (ValaExpression* base);
static gboolean vala_unary_expression_real_is_pure (ValaExpression* base);
static gboolean vala_unary_expression_real_is_accessible (ValaExpression* base,
                                                   ValaSymbol* sym);
static gboolean vala_unary_expression_is_numeric_type (ValaUnaryExpression* self,
                                                ValaDataType* type);
static gboolean vala_unary_expression_is_integer_type (ValaUnaryExpression* self,
                                                ValaDataType* type);
static ValaMemberAccess* vala_unary_expression_find_member_access (ValaUnaryExpression* self,
                                                            ValaExpression* expr);
static gboolean vala_unary_expression_real_check (ValaCodeNode* base,
                                           ValaCodeContext* context);
static void vala_unary_expression_real_emit (ValaCodeNode* base,
                                      ValaCodeGenerator* codegen);
static void vala_unary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                       ValaCollection* collection);
static void vala_unary_expression_real_get_used_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_unary_expression_finalize (ValaCodeNode * obj);


/**
 * Creates a new unary expression.
 *
 * @param op     unary operator
 * @param _inner operand
 * @param source reference to source code
 * @return       newly created binary expression
 */
ValaUnaryExpression*
vala_unary_expression_construct (GType object_type,
                                 ValaUnaryOperator op,
                                 ValaExpression* _inner,
                                 ValaSourceReference* source)
{
	ValaUnaryExpression* self = NULL;
	g_return_val_if_fail (_inner != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	self = (ValaUnaryExpression*) vala_expression_construct (object_type);
	vala_unary_expression_set_operator (self, op);
	vala_unary_expression_set_inner (self, _inner);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}


ValaUnaryExpression*
vala_unary_expression_new (ValaUnaryOperator op,
                           ValaExpression* _inner,
                           ValaSourceReference* source)
{
	return vala_unary_expression_construct (VALA_TYPE_UNARY_EXPRESSION, op, _inner, source);
}


static void
vala_unary_expression_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor)
{
	ValaUnaryExpression * self;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_unary_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_unary_expression_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor)
{
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
}


static void
vala_unary_expression_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node)
{
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_unary_expression_set_inner (self, new_node);
	}
}


static const gchar*
vala_unary_expression_get_operator_string (ValaUnaryExpression* self)
{
	const gchar* result = NULL;
	ValaUnaryOperator _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_operator;
	switch (_tmp0_) {
		case VALA_UNARY_OPERATOR_PLUS:
		{
			result = "+";
			return result;
		}
		case VALA_UNARY_OPERATOR_MINUS:
		{
			result = "-";
			return result;
		}
		case VALA_UNARY_OPERATOR_LOGICAL_NEGATION:
		{
			result = "!";
			return result;
		}
		case VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT:
		{
			result = "~";
			return result;
		}
		case VALA_UNARY_OPERATOR_INCREMENT:
		{
			result = "++";
			return result;
		}
		case VALA_UNARY_OPERATOR_DECREMENT:
		{
			result = "--";
			return result;
		}
		case VALA_UNARY_OPERATOR_REF:
		{
			result = "ref ";
			return result;
		}
		case VALA_UNARY_OPERATOR_OUT:
		{
			result = "out ";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static gchar*
vala_unary_expression_real_to_string (ValaCodeNode* base)
{
	ValaUnaryExpression * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	ValaExpression* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self = (ValaUnaryExpression*) base;
	_tmp0_ = vala_unary_expression_get_operator_string (self);
	_tmp1_ = self->priv->_inner;
	_tmp2_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp0_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_unary_expression_real_is_constant (ValaExpression* base)
{
	ValaUnaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaUnaryOperator _tmp1_;
	gboolean _tmp3_ = FALSE;
	ValaUnaryOperator _tmp4_;
	ValaExpression* _tmp16_;
	ValaExpression* _tmp17_;
	self = (ValaUnaryExpression*) base;
	_tmp1_ = self->priv->_operator;
	if (_tmp1_ == VALA_UNARY_OPERATOR_INCREMENT) {
		_tmp0_ = TRUE;
	} else {
		ValaUnaryOperator _tmp2_;
		_tmp2_ = self->priv->_operator;
		_tmp0_ = _tmp2_ == VALA_UNARY_OPERATOR_DECREMENT;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->_operator;
	if (_tmp4_ == VALA_UNARY_OPERATOR_REF) {
		_tmp3_ = TRUE;
	} else {
		ValaUnaryOperator _tmp5_;
		_tmp5_ = self->priv->_operator;
		_tmp3_ = _tmp5_ == VALA_UNARY_OPERATOR_OUT;
	}
	if (_tmp3_) {
		ValaField* field = NULL;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaField* _tmp10_;
		gboolean _tmp11_ = FALSE;
		ValaField* _tmp12_;
		_tmp6_ = vala_unary_expression_get_inner (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_expression_get_symbol_reference (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _vala_code_node_ref0 (VALA_IS_FIELD (_tmp9_) ? ((ValaField*) _tmp9_) : NULL);
		field = _tmp10_;
		_tmp12_ = field;
		if (_tmp12_ != NULL) {
			ValaField* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp13_ = field;
			_tmp14_ = vala_field_get_binding (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp11_ = _tmp15_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			result = TRUE;
			_vala_code_node_unref0 (field);
			return result;
		} else {
			result = FALSE;
			_vala_code_node_unref0 (field);
			return result;
		}
		_vala_code_node_unref0 (field);
	}
	_tmp16_ = vala_unary_expression_get_inner (self);
	_tmp17_ = _tmp16_;
	result = vala_expression_is_constant (_tmp17_);
	return result;
}


static gboolean
vala_unary_expression_real_is_pure (ValaExpression* base)
{
	ValaUnaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaUnaryOperator _tmp1_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	self = (ValaUnaryExpression*) base;
	_tmp1_ = self->priv->_operator;
	if (_tmp1_ == VALA_UNARY_OPERATOR_INCREMENT) {
		_tmp0_ = TRUE;
	} else {
		ValaUnaryOperator _tmp2_;
		_tmp2_ = self->priv->_operator;
		_tmp0_ = _tmp2_ == VALA_UNARY_OPERATOR_DECREMENT;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = vala_unary_expression_get_inner (self);
	_tmp4_ = _tmp3_;
	result = vala_expression_is_pure (_tmp4_);
	return result;
}


static gboolean
vala_unary_expression_real_is_accessible (ValaExpression* base,
                                          ValaSymbol* sym)
{
	ValaUnaryExpression * self;
	gboolean result = FALSE;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaUnaryExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	result = vala_expression_is_accessible (_tmp1_, sym);
	return result;
}


static gboolean
vala_unary_expression_is_numeric_type (ValaUnaryExpression* self,
                                       ValaDataType* type)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaStruct* st = NULL;
	ValaTypeSymbol* _tmp5_;
	ValaTypeSymbol* _tmp6_;
	ValaStruct* _tmp7_;
	gboolean _tmp8_ = FALSE;
	ValaStruct* _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp1_ = vala_data_type_get_nullable (type);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		ValaTypeSymbol* _tmp3_;
		ValaTypeSymbol* _tmp4_;
		_tmp3_ = vala_data_type_get_data_type (type);
		_tmp4_ = _tmp3_;
		_tmp0_ = !VALA_IS_STRUCT (_tmp4_);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = vala_data_type_get_data_type (type);
	_tmp6_ = _tmp5_;
	_tmp7_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_STRUCT, ValaStruct));
	st = _tmp7_;
	_tmp9_ = st;
	if (vala_struct_is_integer_type (_tmp9_)) {
		_tmp8_ = TRUE;
	} else {
		ValaStruct* _tmp10_;
		_tmp10_ = st;
		_tmp8_ = vala_struct_is_floating_type (_tmp10_);
	}
	result = _tmp8_;
	_vala_code_node_unref0 (st);
	return result;
}


static gboolean
vala_unary_expression_is_integer_type (ValaUnaryExpression* self,
                                       ValaDataType* type)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaStruct* st = NULL;
	ValaTypeSymbol* _tmp5_;
	ValaTypeSymbol* _tmp6_;
	ValaStruct* _tmp7_;
	ValaStruct* _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp1_ = vala_data_type_get_nullable (type);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		ValaTypeSymbol* _tmp3_;
		ValaTypeSymbol* _tmp4_;
		_tmp3_ = vala_data_type_get_data_type (type);
		_tmp4_ = _tmp3_;
		_tmp0_ = !VALA_IS_STRUCT (_tmp4_);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = vala_data_type_get_data_type (type);
	_tmp6_ = _tmp5_;
	_tmp7_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_STRUCT, ValaStruct));
	st = _tmp7_;
	_tmp8_ = st;
	result = vala_struct_is_integer_type (_tmp8_);
	_vala_code_node_unref0 (st);
	return result;
}


static ValaMemberAccess*
vala_unary_expression_find_member_access (ValaUnaryExpression* self,
                                          ValaExpression* expr)
{
	ValaMemberAccess* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	if (VALA_IS_MEMBER_ACCESS (expr)) {
		ValaMemberAccess* _tmp0_;
		_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (expr, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		result = _tmp0_;
		return result;
	}
	result = NULL;
	return result;
}


static gboolean
vala_unary_expression_real_check (ValaCodeNode* base,
                                  ValaCodeContext* context)
{
	ValaUnaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	ValaUnaryOperator _tmp5_;
	ValaExpression* _tmp18_;
	ValaExpression* _tmp19_;
	gboolean _tmp20_ = FALSE;
	ValaExpression* _tmp21_;
	ValaExpression* _tmp22_;
	ValaDataType* _tmp23_;
	ValaDataType* _tmp24_;
	gboolean _tmp41_ = FALSE;
	ValaUnaryOperator _tmp42_;
	gboolean _tmp209_;
	gboolean _tmp210_;
	self = (ValaUnaryExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = self->priv->_operator;
	if (_tmp5_ == VALA_UNARY_OPERATOR_REF) {
		_tmp4_ = TRUE;
	} else {
		ValaUnaryOperator _tmp6_;
		_tmp6_ = self->priv->_operator;
		_tmp4_ = _tmp6_ == VALA_UNARY_OPERATOR_OUT;
	}
	if (_tmp4_) {
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		_tmp7_ = vala_unary_expression_get_inner (self);
		_tmp8_ = _tmp7_;
		vala_expression_set_lvalue (_tmp8_, TRUE);
		_tmp9_ = vala_unary_expression_get_inner (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp12_ = _tmp11_;
		vala_expression_set_target_type (_tmp10_, _tmp12_);
	} else {
		gboolean _tmp13_ = FALSE;
		ValaUnaryOperator _tmp14_;
		_tmp14_ = self->priv->_operator;
		if (_tmp14_ == VALA_UNARY_OPERATOR_INCREMENT) {
			_tmp13_ = TRUE;
		} else {
			ValaUnaryOperator _tmp15_;
			_tmp15_ = self->priv->_operator;
			_tmp13_ = _tmp15_ == VALA_UNARY_OPERATOR_DECREMENT;
		}
		if (_tmp13_) {
			ValaExpression* _tmp16_;
			ValaExpression* _tmp17_;
			_tmp16_ = vala_unary_expression_get_inner (self);
			_tmp17_ = _tmp16_;
			vala_expression_set_lvalue (_tmp17_, TRUE);
		}
	}
	_tmp18_ = vala_unary_expression_get_inner (self);
	_tmp19_ = _tmp18_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp19_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp21_ = vala_unary_expression_get_inner (self);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_expression_get_value_type (_tmp22_);
	_tmp24_ = _tmp23_;
	if (VALA_IS_FIELD_PROTOTYPE (_tmp24_)) {
		_tmp20_ = TRUE;
	} else {
		ValaExpression* _tmp25_;
		ValaExpression* _tmp26_;
		ValaDataType* _tmp27_;
		ValaDataType* _tmp28_;
		_tmp25_ = vala_unary_expression_get_inner (self);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_expression_get_value_type (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp20_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp28_);
	}
	if (_tmp20_) {
		ValaExpression* _tmp29_;
		ValaExpression* _tmp30_;
		ValaSourceReference* _tmp31_;
		ValaSourceReference* _tmp32_;
		ValaExpression* _tmp33_;
		ValaExpression* _tmp34_;
		ValaSymbol* _tmp35_;
		ValaSymbol* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp29_ = vala_unary_expression_get_inner (self);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = vala_unary_expression_get_inner (self);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_expression_get_symbol_reference (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = vala_symbol_get_full_name (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp38_);
		_tmp40_ = _tmp39_;
		vala_report_error (_tmp32_, _tmp40_);
		_g_free0 (_tmp40_);
		_g_free0 (_tmp38_);
		result = FALSE;
		return result;
	}
	_tmp42_ = self->priv->_operator;
	if (_tmp42_ == VALA_UNARY_OPERATOR_PLUS) {
		_tmp41_ = TRUE;
	} else {
		ValaUnaryOperator _tmp43_;
		_tmp43_ = self->priv->_operator;
		_tmp41_ = _tmp43_ == VALA_UNARY_OPERATOR_MINUS;
	}
	if (_tmp41_) {
		ValaExpression* _tmp44_;
		ValaExpression* _tmp45_;
		ValaDataType* _tmp46_;
		ValaDataType* _tmp47_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaDataType* _tmp60_;
		ValaDataType* _tmp61_;
		_tmp44_ = vala_unary_expression_get_inner (self);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_expression_get_value_type (_tmp45_);
		_tmp47_ = _tmp46_;
		if (!vala_unary_expression_is_numeric_type (self, _tmp47_)) {
			ValaSourceReference* _tmp48_;
			ValaSourceReference* _tmp49_;
			ValaExpression* _tmp50_;
			ValaExpression* _tmp51_;
			ValaDataType* _tmp52_;
			ValaDataType* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp48_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp49_ = _tmp48_;
			_tmp50_ = vala_unary_expression_get_inner (self);
			_tmp51_ = _tmp50_;
			_tmp52_ = vala_expression_get_value_type (_tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_code_node_to_string ((ValaCodeNode*) _tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = g_strdup_printf ("Operator not supported for `%s'", _tmp55_);
			_tmp57_ = _tmp56_;
			vala_report_error (_tmp49_, _tmp57_);
			_g_free0 (_tmp57_);
			_g_free0 (_tmp55_);
			result = FALSE;
			return result;
		}
		_tmp58_ = vala_unary_expression_get_inner (self);
		_tmp59_ = _tmp58_;
		_tmp60_ = vala_expression_get_value_type (_tmp59_);
		_tmp61_ = _tmp60_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp61_);
	} else {
		ValaUnaryOperator _tmp62_;
		_tmp62_ = self->priv->_operator;
		if (_tmp62_ == VALA_UNARY_OPERATOR_LOGICAL_NEGATION) {
			gboolean _tmp63_ = FALSE;
			ValaExpression* _tmp64_;
			ValaExpression* _tmp65_;
			ValaDataType* _tmp66_;
			ValaDataType* _tmp67_;
			gboolean _tmp68_;
			gboolean _tmp69_;
			ValaExpression* _tmp87_;
			ValaExpression* _tmp88_;
			ValaDataType* _tmp89_;
			ValaDataType* _tmp90_;
			_tmp64_ = vala_unary_expression_get_inner (self);
			_tmp65_ = _tmp64_;
			_tmp66_ = vala_expression_get_value_type (_tmp65_);
			_tmp67_ = _tmp66_;
			_tmp68_ = vala_data_type_get_nullable (_tmp67_);
			_tmp69_ = _tmp68_;
			if (_tmp69_) {
				_tmp63_ = TRUE;
			} else {
				ValaExpression* _tmp70_;
				ValaExpression* _tmp71_;
				ValaDataType* _tmp72_;
				ValaDataType* _tmp73_;
				ValaSemanticAnalyzer* _tmp74_;
				ValaSemanticAnalyzer* _tmp75_;
				ValaDataType* _tmp76_;
				_tmp70_ = vala_unary_expression_get_inner (self);
				_tmp71_ = _tmp70_;
				_tmp72_ = vala_expression_get_value_type (_tmp71_);
				_tmp73_ = _tmp72_;
				_tmp74_ = vala_code_context_get_analyzer (context);
				_tmp75_ = _tmp74_;
				_tmp76_ = _tmp75_->bool_type;
				_tmp63_ = !vala_data_type_compatible (_tmp73_, _tmp76_);
			}
			if (_tmp63_) {
				ValaSourceReference* _tmp77_;
				ValaSourceReference* _tmp78_;
				ValaExpression* _tmp79_;
				ValaExpression* _tmp80_;
				ValaDataType* _tmp81_;
				ValaDataType* _tmp82_;
				gchar* _tmp83_;
				gchar* _tmp84_;
				gchar* _tmp85_;
				gchar* _tmp86_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp77_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp78_ = _tmp77_;
				_tmp79_ = vala_unary_expression_get_inner (self);
				_tmp80_ = _tmp79_;
				_tmp81_ = vala_expression_get_value_type (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp83_ = vala_code_node_to_string ((ValaCodeNode*) _tmp82_);
				_tmp84_ = _tmp83_;
				_tmp85_ = g_strdup_printf ("Operator not supported for `%s'", _tmp84_);
				_tmp86_ = _tmp85_;
				vala_report_error (_tmp78_, _tmp86_);
				_g_free0 (_tmp86_);
				_g_free0 (_tmp84_);
				result = FALSE;
				return result;
			}
			_tmp87_ = vala_unary_expression_get_inner (self);
			_tmp88_ = _tmp87_;
			_tmp89_ = vala_expression_get_value_type (_tmp88_);
			_tmp90_ = _tmp89_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp90_);
		} else {
			ValaUnaryOperator _tmp91_;
			_tmp91_ = self->priv->_operator;
			if (_tmp91_ == VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT) {
				gboolean _tmp92_ = FALSE;
				ValaExpression* _tmp93_;
				ValaExpression* _tmp94_;
				ValaDataType* _tmp95_;
				ValaDataType* _tmp96_;
				ValaExpression* _tmp111_;
				ValaExpression* _tmp112_;
				ValaDataType* _tmp113_;
				ValaDataType* _tmp114_;
				_tmp93_ = vala_unary_expression_get_inner (self);
				_tmp94_ = _tmp93_;
				_tmp95_ = vala_expression_get_value_type (_tmp94_);
				_tmp96_ = _tmp95_;
				if (!vala_unary_expression_is_integer_type (self, _tmp96_)) {
					ValaExpression* _tmp97_;
					ValaExpression* _tmp98_;
					ValaDataType* _tmp99_;
					ValaDataType* _tmp100_;
					_tmp97_ = vala_unary_expression_get_inner (self);
					_tmp98_ = _tmp97_;
					_tmp99_ = vala_expression_get_value_type (_tmp98_);
					_tmp100_ = _tmp99_;
					_tmp92_ = !VALA_IS_ENUM_VALUE_TYPE (_tmp100_);
				} else {
					_tmp92_ = FALSE;
				}
				if (_tmp92_) {
					ValaSourceReference* _tmp101_;
					ValaSourceReference* _tmp102_;
					ValaExpression* _tmp103_;
					ValaExpression* _tmp104_;
					ValaDataType* _tmp105_;
					ValaDataType* _tmp106_;
					gchar* _tmp107_;
					gchar* _tmp108_;
					gchar* _tmp109_;
					gchar* _tmp110_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp101_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp102_ = _tmp101_;
					_tmp103_ = vala_unary_expression_get_inner (self);
					_tmp104_ = _tmp103_;
					_tmp105_ = vala_expression_get_value_type (_tmp104_);
					_tmp106_ = _tmp105_;
					_tmp107_ = vala_code_node_to_string ((ValaCodeNode*) _tmp106_);
					_tmp108_ = _tmp107_;
					_tmp109_ = g_strdup_printf ("Operator not supported for `%s'", _tmp108_);
					_tmp110_ = _tmp109_;
					vala_report_error (_tmp102_, _tmp110_);
					_g_free0 (_tmp110_);
					_g_free0 (_tmp108_);
					result = FALSE;
					return result;
				}
				_tmp111_ = vala_unary_expression_get_inner (self);
				_tmp112_ = _tmp111_;
				_tmp113_ = vala_expression_get_value_type (_tmp112_);
				_tmp114_ = _tmp113_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp114_);
			} else {
				gboolean _tmp115_ = FALSE;
				ValaUnaryOperator _tmp116_;
				_tmp116_ = self->priv->_operator;
				if (_tmp116_ == VALA_UNARY_OPERATOR_INCREMENT) {
					_tmp115_ = TRUE;
				} else {
					ValaUnaryOperator _tmp117_;
					_tmp117_ = self->priv->_operator;
					_tmp115_ = _tmp117_ == VALA_UNARY_OPERATOR_DECREMENT;
				}
				if (_tmp115_) {
					ValaExpression* _tmp118_;
					ValaExpression* _tmp119_;
					ValaDataType* _tmp120_;
					ValaDataType* _tmp121_;
					ValaMemberAccess* ma = NULL;
					ValaExpression* _tmp132_;
					ValaExpression* _tmp133_;
					ValaMemberAccess* _tmp134_;
					ValaMemberAccess* _tmp135_;
					ValaMemberAccess* old_value = NULL;
					ValaMemberAccess* _tmp138_;
					ValaExpression* _tmp139_;
					ValaExpression* _tmp140_;
					ValaMemberAccess* _tmp141_;
					const gchar* _tmp142_;
					const gchar* _tmp143_;
					ValaExpression* _tmp144_;
					ValaExpression* _tmp145_;
					ValaSourceReference* _tmp146_;
					ValaSourceReference* _tmp147_;
					ValaMemberAccess* _tmp148_;
					ValaBinaryOperator _tmp149_ = 0;
					ValaUnaryOperator _tmp150_;
					ValaBinaryExpression* bin = NULL;
					ValaMemberAccess* _tmp151_;
					ValaIntegerLiteral* _tmp152_;
					ValaIntegerLiteral* _tmp153_;
					ValaSourceReference* _tmp154_;
					ValaSourceReference* _tmp155_;
					ValaBinaryExpression* _tmp156_;
					ValaBinaryExpression* _tmp157_;
					ValaAssignment* assignment = NULL;
					ValaMemberAccess* _tmp158_;
					ValaBinaryExpression* _tmp159_;
					ValaSourceReference* _tmp160_;
					ValaSourceReference* _tmp161_;
					ValaAssignment* _tmp162_;
					ValaAssignment* _tmp163_;
					ValaDataType* _tmp164_;
					ValaDataType* _tmp165_;
					ValaSemanticAnalyzer* _tmp166_;
					ValaSemanticAnalyzer* _tmp167_;
					ValaList* _tmp168_;
					ValaCodeNode* _tmp169_;
					ValaCodeNode* _tmp170_;
					ValaAssignment* _tmp171_;
					ValaAssignment* _tmp172_;
					_tmp118_ = vala_unary_expression_get_inner (self);
					_tmp119_ = _tmp118_;
					_tmp120_ = vala_expression_get_value_type (_tmp119_);
					_tmp121_ = _tmp120_;
					if (!vala_unary_expression_is_integer_type (self, _tmp121_)) {
						ValaSourceReference* _tmp122_;
						ValaSourceReference* _tmp123_;
						ValaExpression* _tmp124_;
						ValaExpression* _tmp125_;
						ValaDataType* _tmp126_;
						ValaDataType* _tmp127_;
						gchar* _tmp128_;
						gchar* _tmp129_;
						gchar* _tmp130_;
						gchar* _tmp131_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp122_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp123_ = _tmp122_;
						_tmp124_ = vala_unary_expression_get_inner (self);
						_tmp125_ = _tmp124_;
						_tmp126_ = vala_expression_get_value_type (_tmp125_);
						_tmp127_ = _tmp126_;
						_tmp128_ = vala_code_node_to_string ((ValaCodeNode*) _tmp127_);
						_tmp129_ = _tmp128_;
						_tmp130_ = g_strdup_printf ("Operator not supported for `%s'", _tmp129_);
						_tmp131_ = _tmp130_;
						vala_report_error (_tmp123_, _tmp131_);
						_g_free0 (_tmp131_);
						_g_free0 (_tmp129_);
						result = FALSE;
						return result;
					}
					_tmp132_ = vala_unary_expression_get_inner (self);
					_tmp133_ = _tmp132_;
					_tmp134_ = vala_unary_expression_find_member_access (self, _tmp133_);
					ma = _tmp134_;
					_tmp135_ = ma;
					if (_tmp135_ == NULL) {
						ValaSourceReference* _tmp136_;
						ValaSourceReference* _tmp137_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp136_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp137_ = _tmp136_;
						vala_report_error (_tmp137_, "Prefix operators not supported for this expression");
						result = FALSE;
						_vala_code_node_unref0 (ma);
						return result;
					}
					_tmp138_ = ma;
					_tmp139_ = vala_member_access_get_inner (_tmp138_);
					_tmp140_ = _tmp139_;
					_tmp141_ = ma;
					_tmp142_ = vala_member_access_get_member_name (_tmp141_);
					_tmp143_ = _tmp142_;
					_tmp144_ = vala_unary_expression_get_inner (self);
					_tmp145_ = _tmp144_;
					_tmp146_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp145_);
					_tmp147_ = _tmp146_;
					_tmp148_ = vala_member_access_new (_tmp140_, _tmp143_, _tmp147_);
					old_value = _tmp148_;
					_tmp150_ = self->priv->_operator;
					if (_tmp150_ == VALA_UNARY_OPERATOR_INCREMENT) {
						_tmp149_ = VALA_BINARY_OPERATOR_PLUS;
					} else {
						_tmp149_ = VALA_BINARY_OPERATOR_MINUS;
					}
					_tmp151_ = old_value;
					_tmp152_ = vala_integer_literal_new ("1", NULL);
					_tmp153_ = _tmp152_;
					_tmp154_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp155_ = _tmp154_;
					_tmp156_ = vala_binary_expression_new (_tmp149_, (ValaExpression*) _tmp151_, (ValaExpression*) _tmp153_, _tmp155_);
					_tmp157_ = _tmp156_;
					_vala_code_node_unref0 (_tmp153_);
					bin = _tmp157_;
					_tmp158_ = ma;
					_tmp159_ = bin;
					_tmp160_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp161_ = _tmp160_;
					_tmp162_ = vala_assignment_new ((ValaExpression*) _tmp158_, (ValaExpression*) _tmp159_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp161_);
					assignment = _tmp162_;
					_tmp163_ = assignment;
					_tmp164_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp165_ = _tmp164_;
					vala_expression_set_target_type ((ValaExpression*) _tmp163_, _tmp165_);
					_tmp166_ = vala_code_context_get_analyzer (context);
					_tmp167_ = _tmp166_;
					_tmp168_ = _tmp167_->replaced_nodes;
					vala_collection_add ((ValaCollection*) _tmp168_, (ValaCodeNode*) self);
					_tmp169_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp170_ = _tmp169_;
					_tmp171_ = assignment;
					vala_code_node_replace_expression (_tmp170_, (ValaExpression*) self, (ValaExpression*) _tmp171_);
					_tmp172_ = assignment;
					vala_code_node_check ((ValaCodeNode*) _tmp172_, context);
					result = TRUE;
					_vala_code_node_unref0 (assignment);
					_vala_code_node_unref0 (bin);
					_vala_code_node_unref0 (old_value);
					_vala_code_node_unref0 (ma);
					return result;
				} else {
					gboolean _tmp173_ = FALSE;
					ValaUnaryOperator _tmp174_;
					_tmp174_ = self->priv->_operator;
					if (_tmp174_ == VALA_UNARY_OPERATOR_REF) {
						_tmp173_ = TRUE;
					} else {
						ValaUnaryOperator _tmp175_;
						_tmp175_ = self->priv->_operator;
						_tmp173_ = _tmp175_ == VALA_UNARY_OPERATOR_OUT;
					}
					if (_tmp173_) {
						ValaElementAccess* ea = NULL;
						ValaExpression* _tmp176_;
						ValaExpression* _tmp177_;
						ValaElementAccess* _tmp178_;
						gboolean _tmp179_ = FALSE;
						gboolean _tmp180_ = FALSE;
						gboolean _tmp181_ = FALSE;
						ValaExpression* _tmp182_;
						ValaExpression* _tmp183_;
						ValaSymbol* _tmp184_;
						ValaSymbol* _tmp185_;
						_tmp176_ = vala_unary_expression_get_inner (self);
						_tmp177_ = _tmp176_;
						_tmp178_ = _vala_code_node_ref0 (VALA_IS_ELEMENT_ACCESS (_tmp177_) ? ((ValaElementAccess*) _tmp177_) : NULL);
						ea = _tmp178_;
						_tmp182_ = vala_unary_expression_get_inner (self);
						_tmp183_ = _tmp182_;
						_tmp184_ = vala_expression_get_symbol_reference (_tmp183_);
						_tmp185_ = _tmp184_;
						if (VALA_IS_FIELD (_tmp185_)) {
							_tmp181_ = TRUE;
						} else {
							ValaExpression* _tmp186_;
							ValaExpression* _tmp187_;
							ValaSymbol* _tmp188_;
							ValaSymbol* _tmp189_;
							_tmp186_ = vala_unary_expression_get_inner (self);
							_tmp187_ = _tmp186_;
							_tmp188_ = vala_expression_get_symbol_reference (_tmp187_);
							_tmp189_ = _tmp188_;
							_tmp181_ = VALA_IS_PARAMETER (_tmp189_);
						}
						if (_tmp181_) {
							_tmp180_ = TRUE;
						} else {
							ValaExpression* _tmp190_;
							ValaExpression* _tmp191_;
							ValaSymbol* _tmp192_;
							ValaSymbol* _tmp193_;
							_tmp190_ = vala_unary_expression_get_inner (self);
							_tmp191_ = _tmp190_;
							_tmp192_ = vala_expression_get_symbol_reference (_tmp191_);
							_tmp193_ = _tmp192_;
							_tmp180_ = VALA_IS_LOCAL_VARIABLE (_tmp193_);
						}
						if (_tmp180_) {
							_tmp179_ = TRUE;
						} else {
							gboolean _tmp194_ = FALSE;
							ValaElementAccess* _tmp195_;
							_tmp195_ = ea;
							if (_tmp195_ != NULL) {
								ValaElementAccess* _tmp196_;
								ValaExpression* _tmp197_;
								ValaExpression* _tmp198_;
								ValaDataType* _tmp199_;
								ValaDataType* _tmp200_;
								_tmp196_ = ea;
								_tmp197_ = vala_element_access_get_container (_tmp196_);
								_tmp198_ = _tmp197_;
								_tmp199_ = vala_expression_get_value_type (_tmp198_);
								_tmp200_ = _tmp199_;
								_tmp194_ = VALA_IS_ARRAY_TYPE (_tmp200_);
							} else {
								_tmp194_ = FALSE;
							}
							_tmp179_ = _tmp194_;
						}
						if (_tmp179_) {
							ValaExpression* _tmp201_;
							ValaExpression* _tmp202_;
							ValaDataType* _tmp203_;
							ValaDataType* _tmp204_;
							vala_expression_set_lvalue ((ValaExpression*) self, TRUE);
							_tmp201_ = vala_unary_expression_get_inner (self);
							_tmp202_ = _tmp201_;
							_tmp203_ = vala_expression_get_value_type (_tmp202_);
							_tmp204_ = _tmp203_;
							vala_expression_set_value_type ((ValaExpression*) self, _tmp204_);
						} else {
							ValaSourceReference* _tmp205_;
							ValaSourceReference* _tmp206_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp205_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp206_ = _tmp205_;
							vala_report_error (_tmp206_, "ref and out method arguments can only be used with fields, parameters," \
" local variables, and array element access");
							result = FALSE;
							_vala_code_node_unref0 (ea);
							return result;
						}
						_vala_code_node_unref0 (ea);
					} else {
						ValaSourceReference* _tmp207_;
						ValaSourceReference* _tmp208_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp207_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp208_ = _tmp207_;
						vala_report_error (_tmp208_, "internal error: unsupported unary operator");
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	_tmp209_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp210_ = _tmp209_;
	result = !_tmp210_;
	return result;
}


static void
vala_unary_expression_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen)
{
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
	vala_code_visitor_visit_unary_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_unary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                  ValaCollection* collection)
{
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaUnaryOperator _tmp3_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp3_ = self->priv->_operator;
	if (_tmp3_ == VALA_UNARY_OPERATOR_OUT) {
		_tmp2_ = TRUE;
	} else {
		ValaUnaryOperator _tmp4_;
		_tmp4_ = self->priv->_operator;
		_tmp2_ = _tmp4_ == VALA_UNARY_OPERATOR_REF;
	}
	if (_tmp2_) {
		ValaLocalVariable* local = NULL;
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaLocalVariable* _tmp9_;
		ValaParameter* param = NULL;
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaSymbol* _tmp13_;
		ValaParameter* _tmp14_;
		ValaLocalVariable* _tmp15_;
		gboolean _tmp17_ = FALSE;
		ValaParameter* _tmp18_;
		_tmp5_ = vala_unary_expression_get_inner (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_expression_get_symbol_reference (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _vala_code_node_ref0 (VALA_IS_LOCAL_VARIABLE (_tmp8_) ? ((ValaLocalVariable*) _tmp8_) : NULL);
		local = _tmp9_;
		_tmp10_ = vala_unary_expression_get_inner (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _vala_code_node_ref0 (VALA_IS_PARAMETER (_tmp13_) ? ((ValaParameter*) _tmp13_) : NULL);
		param = _tmp14_;
		_tmp15_ = local;
		if (_tmp15_ != NULL) {
			ValaLocalVariable* _tmp16_;
			_tmp16_ = local;
			vala_collection_add (collection, (ValaVariable*) _tmp16_);
		}
		_tmp18_ = param;
		if (_tmp18_ != NULL) {
			ValaParameter* _tmp19_;
			ValaParameterDirection _tmp20_;
			ValaParameterDirection _tmp21_;
			_tmp19_ = param;
			_tmp20_ = vala_parameter_get_direction (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp17_ = _tmp21_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			ValaParameter* _tmp22_;
			_tmp22_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp22_);
		}
		_vala_code_node_unref0 (param);
		_vala_code_node_unref0 (local);
	}
}


static void
vala_unary_expression_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaUnaryExpression * self;
	ValaUnaryOperator _tmp0_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->priv->_operator;
	if (_tmp0_ != VALA_UNARY_OPERATOR_OUT) {
		ValaExpression* _tmp1_;
		ValaExpression* _tmp2_;
		_tmp1_ = vala_unary_expression_get_inner (self);
		_tmp2_ = _tmp1_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp2_, collection);
	}
}


ValaUnaryOperator
vala_unary_expression_get_operator (ValaUnaryExpression* self)
{
	ValaUnaryOperator result;
	ValaUnaryOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}


void
vala_unary_expression_set_operator (ValaUnaryExpression* self,
                                    ValaUnaryOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}


ValaExpression*
vala_unary_expression_get_inner (ValaUnaryExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}


void
vala_unary_expression_set_inner (ValaUnaryExpression* self,
                                 ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


static void
vala_unary_expression_class_init (ValaUnaryExpressionClass * klass)
{
	vala_unary_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_unary_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaUnaryExpressionPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_unary_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_unary_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_unary_expression_real_replace_expression;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_unary_expression_real_to_string;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_unary_expression_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_unary_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_unary_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_unary_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_unary_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_unary_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_unary_expression_real_get_used_variables;
}


static void
vala_unary_expression_instance_init (ValaUnaryExpression * self)
{
	self->priv = VALA_UNARY_EXPRESSION_GET_PRIVATE (self);
}


static void
vala_unary_expression_finalize (ValaCodeNode * obj)
{
	ValaUnaryExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
	_vala_code_node_unref0 (self->priv->_inner);
	VALA_CODE_NODE_CLASS (vala_unary_expression_parent_class)->finalize (obj);
}


/**
 * Represents an expression with one operand in the source code.
 *
 * Supports +, -, !, ~, ref, out.
 */
GType
vala_unary_expression_get_type (void)
{
	static volatile gsize vala_unary_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_unary_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaUnaryExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_unary_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaUnaryExpression), 0, (GInstanceInitFunc) vala_unary_expression_instance_init, NULL };
		GType vala_unary_expression_type_id;
		vala_unary_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaUnaryExpression", &g_define_type_info, 0);
		g_once_init_leave (&vala_unary_expression_type_id__volatile, vala_unary_expression_type_id);
	}
	return vala_unary_expression_type_id__volatile;
}


GType
vala_unary_operator_get_type (void)
{
	static volatile gsize vala_unary_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_unary_operator_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_UNARY_OPERATOR_NONE, "VALA_UNARY_OPERATOR_NONE", "none"}, {VALA_UNARY_OPERATOR_PLUS, "VALA_UNARY_OPERATOR_PLUS", "plus"}, {VALA_UNARY_OPERATOR_MINUS, "VALA_UNARY_OPERATOR_MINUS", "minus"}, {VALA_UNARY_OPERATOR_LOGICAL_NEGATION, "VALA_UNARY_OPERATOR_LOGICAL_NEGATION", "logical-negation"}, {VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT, "VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT", "bitwise-complement"}, {VALA_UNARY_OPERATOR_INCREMENT, "VALA_UNARY_OPERATOR_INCREMENT", "increment"}, {VALA_UNARY_OPERATOR_DECREMENT, "VALA_UNARY_OPERATOR_DECREMENT", "decrement"}, {VALA_UNARY_OPERATOR_REF, "VALA_UNARY_OPERATOR_REF", "ref"}, {VALA_UNARY_OPERATOR_OUT, "VALA_UNARY_OPERATOR_OUT", "out"}, {0, NULL, NULL}};
		GType vala_unary_operator_type_id;
		vala_unary_operator_type_id = g_enum_register_static ("ValaUnaryOperator", values);
		g_once_init_leave (&vala_unary_operator_type_id__volatile, vala_unary_operator_type_id);
	}
	return vala_unary_operator_type_id__volatile;
}



