/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

//----------------------------------------------------------------------------
//
//  File:       EventMessages.h
//
//  Contents:   Linux Event Messages.
//----------------------------------------------------------------------------

#ifndef EVENT_MESSAGES_H
#define EVENT_MESSAGES_H

#include <vector>
#include <string>

using namespace std;
// This class holds a single event message.
class SingleEvent
{
private:
	int		_priority;	// corresponding to the syslog priority
	unsigned long	_eventid;
	string		_message;
public:
	SingleEvent() {};
	SingleEvent(	const int priority,
			const unsigned long eventid,
			const string &message):
			_priority(priority),
			_eventid(eventid),
			_message(message) {}
	const	string& getMessage	()	{return _message;}
	int		getEventid	()	{return _eventid;}
	int		getPriority	()	{return _priority;}
};

// Singleton class, user cannot create instance of it.
class EventMessages
{
private:
	vector<SingleEvent> _events;
	vector<string>	    _categories;
	EventMessages();
public:
	// Use this method to get the single instance of this class.
	static EventMessages& instance() {	static EventMessages _instance;
						return _instance;}

	const string& getMessage	(int eventid)	{ return _events[eventid].getMessage();}
	int		getPriority	(int eventid)	{ return _events[eventid].getPriority();}
	int		getEventid	(int eventid)	{ return _events[eventid].getEventid();}
	string&	getCategory	(int category)	{ return _categories[category];}
};

#endif

