// $Id$
// $Source$

//@HEADER
// ************************************************************************
//
//            LOCA: Library of Continuation Algorithms Package
//                 Copyright (2005) Sandia Corporation
//
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the Corporation nor the names of the
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Questions? Contact Glen Hansen (gahanse@sandia.gov), Sandia National Laboratories.
// ************************************************************************
//  CVS Information
//  $Source$
//  $Author$
//  $Date$
//  $Revision$
// ************************************************************************
//@HEADER

#include "LOCA_Thyra_GroupWrapper.H"              // class definition

LOCA::Thyra::GroupWrapper::GroupWrapper(
        const Teuchos::RCP<LOCA::GlobalData>& global_data,
        const NOX::Thyra::Vector& initial_guess,
        const Teuchos::RCP< ::Thyra::ModelEvaluator<double> >& model,
        const LOCA::ParameterVector& p,
        int p_index,
        bool impl_dfdp) :
  NOX::Thyra::Group(initial_guess, model),
  LOCA::Abstract::Group(global_data),
  LOCA::Thyra::Group(global_data, initial_guess, model, p, p_index, impl_dfdp)
{
}

LOCA::Thyra::GroupWrapper::GroupWrapper(const LOCA::Thyra::GroupWrapper& source,
               NOX::CopyType type) :
  NOX::Thyra::Group(source, type),
  LOCA::Abstract::Group(source, type),
  LOCA::Thyra::Group(source, type)
{
}

LOCA::Thyra::GroupWrapper::~GroupWrapper()
{
}

LOCA::Thyra::GroupWrapper&
LOCA::Thyra::GroupWrapper::operator=(const LOCA::Thyra::GroupWrapper& source)
{
  if (this != &source) {
    LOCA::Thyra::Group::operator=(source);
  }
  return *this;
}

NOX::Abstract::Group&
LOCA::Thyra::GroupWrapper::operator=(const NOX::Abstract::Group& source)
{
  operator=(dynamic_cast<const GroupWrapper&> (source));
  return *this;
}

NOX::Abstract::Group&
LOCA::Thyra::GroupWrapper::operator=(const NOX::Thyra::Group& source)
{
  operator=(dynamic_cast<const GroupWrapper&> (source));
  return *this;
}

LOCA::Thyra::Group&
LOCA::Thyra::GroupWrapper::operator=(const LOCA::Thyra::Group& source)
{
  operator=(dynamic_cast<const GroupWrapper&> (source));
  return *this;
}

Teuchos::RCP<NOX::Abstract::Group>
LOCA::Thyra::GroupWrapper::clone(NOX::CopyType type) const
{
  return Teuchos::rcp(new LOCA::Thyra::GroupWrapper(*this, type));
}

