/* Copyright (c) 2010 People Power Co.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the
 *   distribution.
 * - Neither the name of the People Power Corporation nor the names of
 *   its contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * PEOPLE POWER CO. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE
 *
 */

#ifndef MULTIPLEX_ALARM_H_
#define MULTIPLEX_ALARM_H_

/** Unique marker for multiplexed 16-bit whole-second alarms */
#define UQ_MuxAlarmSecond16 "UQ_MuxAlarmSecond16"
/** Unique marker for multiplexed 32-bit whole-second alarms */
#define UQ_MuxAlarmSecond32 "UQ_MuxAlarmSecond32"
/** Unique marker for multiplexed 16-bit millisecond alarms */
#define UQ_MuxAlarmMilli16 "UQ_MuxAlarmMilli16"
/** Unique marker for multiplexed 32-bit millisecond alarms */
#define UQ_MuxAlarmMilli32 "UQ_MuxAlarmMilli32"
/** Unique marker for multiplexed 16-bit 32KHz alarms */
#define UQ_MuxAlarm32khz16 "UQ_MuxAlarm32khz16"
/** Unique marker for multiplexed 32-bit 32KHz alarms */
#define UQ_MuxAlarm32khz32 "UQ_MuxAlarm32khz32"

#endif /* MULTIPLEX_ALARM_H_ */
