/* Copyright (c) 2003 Ecole centrale de Lyon
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "fdtd3d.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "utils.h"

/* Reads the contents of a file.

Don't forget to free() the returned buffer. */
char *read_file(char *path)
{
  FILE *thefile;
  char *buffer;
  int read_chars=0;
  int bufsize=FILE_BUFFER;
  int i;

  thefile=fopen(path,"r");
  if(thefile==NULL)
    {
      perror(path);
      return NULL;
    }
  
  if((buffer=malloc(bufsize))==NULL)
    panic("Not enough memory");
  while((i=fread(buffer+read_chars,1,FILE_BUFFER,thefile))==FILE_BUFFER)
    {
      read_chars+=i;
      if(read_chars+FILE_BUFFER>bufsize)
	{
	  bufsize*=2;
	  buffer=realloc(buffer,bufsize);
	}
    }
  fclose(thefile);
  read_chars+=i;
  buffer=realloc(buffer,read_chars+1);
  buffer[read_chars]='\0';
  return buffer;
}


/* Write in a file, overwriting it if necessary. */
int write_file(char *path,char *buffer)
{
  FILE *thefile;
  int i;

  thefile=fopen(path,"w");
  if(thefile==NULL)
    {
      perror(path);
      return -1;
    }

  i=strlen(buffer);
  if(fwrite(buffer,1,i,thefile)<i)
    {
      perror(path);
      fclose(thefile);
      return -2;
    }

  fclose(thefile);
  return 0;
}
