// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/sensu/sensu-go/api/core/v2/authentication.proto

package v2

import (
	bytes "bytes"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Tokens contains the structure for exchanging tokens with the API
type Tokens struct {
	// Access token is used by client to make request
	Access string `protobuf:"bytes,1,opt,name=access,proto3" json:"access_token"`
	// ExpiresAt unix timestamp describing when the access token is no longer
	// valid
	ExpiresAt int64 `protobuf:"varint,2,opt,name=expires_at,json=expiresAt,proto3" json:"expires_at"`
	// Refresh token is used by client to request a new access token
	Refresh              string   `protobuf:"bytes,3,opt,name=refresh,proto3" json:"refresh_token"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Tokens) Reset()         { *m = Tokens{} }
func (m *Tokens) String() string { return proto.CompactTextString(m) }
func (*Tokens) ProtoMessage()    {}
func (*Tokens) Descriptor() ([]byte, []int) {
	return fileDescriptor_bff1baf5955c2888, []int{0}
}
func (m *Tokens) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tokens) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tokens.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tokens) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tokens.Merge(m, src)
}
func (m *Tokens) XXX_Size() int {
	return m.Size()
}
func (m *Tokens) XXX_DiscardUnknown() {
	xxx_messageInfo_Tokens.DiscardUnknown(m)
}

var xxx_messageInfo_Tokens proto.InternalMessageInfo

func (m *Tokens) GetAccess() string {
	if m != nil {
		return m.Access
	}
	return ""
}

func (m *Tokens) GetExpiresAt() int64 {
	if m != nil {
		return m.ExpiresAt
	}
	return 0
}

func (m *Tokens) GetRefresh() string {
	if m != nil {
		return m.Refresh
	}
	return ""
}

func init() {
	proto.RegisterType((*Tokens)(nil), "sensu.core.v2.Tokens")
}

func init() {
	proto.RegisterFile("github.com/sensu/sensu-go/api/core/v2/authentication.proto", fileDescriptor_bff1baf5955c2888)
}

var fileDescriptor_bff1baf5955c2888 = []byte{
	// 261 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe2, 0xb2, 0x4a, 0xcf, 0x2c, 0xc9,
	0x28, 0x4d, 0xd2, 0x4b, 0xce, 0xcf, 0xd5, 0x2f, 0x4e, 0xcd, 0x2b, 0x2e, 0x85, 0x90, 0xba, 0xe9,
	0xf9, 0xfa, 0x89, 0x05, 0x99, 0xfa, 0xc9, 0xf9, 0x45, 0xa9, 0xfa, 0x65, 0x46, 0xfa, 0x89, 0xa5,
	0x25, 0x19, 0xa9, 0x79, 0x25, 0x99, 0xc9, 0x89, 0x25, 0x99, 0xf9, 0x79, 0x7a, 0x05, 0x45, 0xf9,
	0x25, 0xf9, 0x42, 0xbc, 0x60, 0xa5, 0x7a, 0x20, 0x35, 0x7a, 0x65, 0x46, 0x52, 0x26, 0x48, 0x46,
	0xa5, 0xe7, 0xa7, 0xe7, 0xeb, 0x83, 0x55, 0x25, 0x95, 0xa6, 0x39, 0x94, 0x19, 0xea, 0x19, 0xeb,
	0x19, 0x82, 0x05, 0xc1, 0x62, 0x60, 0x16, 0xc4, 0x10, 0xa5, 0x3e, 0x46, 0x2e, 0xb6, 0x90, 0xfc,
	0xec, 0xd4, 0xbc, 0x62, 0x21, 0x0d, 0x2e, 0xb6, 0xc4, 0xe4, 0xe4, 0xd4, 0xe2, 0x62, 0x09, 0x46,
	0x05, 0x46, 0x0d, 0x4e, 0x27, 0x81, 0x57, 0xf7, 0xe4, 0x79, 0x20, 0x22, 0xf1, 0x25, 0x20, 0x25,
	0x41, 0x50, 0x79, 0x21, 0x5d, 0x2e, 0xae, 0xd4, 0x8a, 0x82, 0xcc, 0xa2, 0xd4, 0xe2, 0xf8, 0xc4,
	0x12, 0x09, 0x26, 0x05, 0x46, 0x0d, 0x66, 0x27, 0xbe, 0x57, 0xf7, 0xe4, 0x91, 0x44, 0x83, 0x38,
	0xa1, 0x6c, 0xc7, 0x12, 0x21, 0x6d, 0x2e, 0xf6, 0xa2, 0xd4, 0xb4, 0xa2, 0xd4, 0xe2, 0x0c, 0x09,
	0x66, 0xb0, 0xc9, 0x82, 0xaf, 0xee, 0xc9, 0xf3, 0x42, 0x85, 0xa0, 0x46, 0xc3, 0x54, 0x38, 0x29,
	0xfc, 0x78, 0x28, 0xc7, 0xb8, 0xe2, 0x91, 0x1c, 0xe3, 0x8e, 0x47, 0x72, 0x8c, 0x27, 0x1e, 0xc9,
	0x31, 0x5e, 0x78, 0x24, 0xc7, 0xf8, 0xe0, 0x91, 0x1c, 0xe3, 0x8c, 0xc7, 0x72, 0x0c, 0x51, 0x4c,
	0x65, 0x46, 0x49, 0x6c, 0x60, 0x97, 0x1b, 0x03, 0x02, 0x00, 0x00, 0xff, 0xff, 0xdc, 0x56, 0x8a,
	0x64, 0x3c, 0x01, 0x00, 0x00,
}

func (this *Tokens) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Tokens)
	if !ok {
		that2, ok := that.(Tokens)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Access != that1.Access {
		return false
	}
	if this.ExpiresAt != that1.ExpiresAt {
		return false
	}
	if this.Refresh != that1.Refresh {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (m *Tokens) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tokens) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tokens) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Refresh) > 0 {
		i -= len(m.Refresh)
		copy(dAtA[i:], m.Refresh)
		i = encodeVarintAuthentication(dAtA, i, uint64(len(m.Refresh)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ExpiresAt != 0 {
		i = encodeVarintAuthentication(dAtA, i, uint64(m.ExpiresAt))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Access) > 0 {
		i -= len(m.Access)
		copy(dAtA[i:], m.Access)
		i = encodeVarintAuthentication(dAtA, i, uint64(len(m.Access)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintAuthentication(dAtA []byte, offset int, v uint64) int {
	offset -= sovAuthentication(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func NewPopulatedTokens(r randyAuthentication, easy bool) *Tokens {
	this := &Tokens{}
	this.Access = string(randStringAuthentication(r))
	this.ExpiresAt = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.ExpiresAt *= -1
	}
	this.Refresh = string(randStringAuthentication(r))
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedAuthentication(r, 4)
	}
	return this
}

type randyAuthentication interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneAuthentication(r randyAuthentication) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringAuthentication(r randyAuthentication) string {
	v1 := r.Intn(100)
	tmps := make([]rune, v1)
	for i := 0; i < v1; i++ {
		tmps[i] = randUTF8RuneAuthentication(r)
	}
	return string(tmps)
}
func randUnrecognizedAuthentication(r randyAuthentication, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldAuthentication(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldAuthentication(dAtA []byte, r randyAuthentication, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateAuthentication(dAtA, uint64(key))
		v2 := r.Int63()
		if r.Intn(2) == 0 {
			v2 *= -1
		}
		dAtA = encodeVarintPopulateAuthentication(dAtA, uint64(v2))
	case 1:
		dAtA = encodeVarintPopulateAuthentication(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateAuthentication(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateAuthentication(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateAuthentication(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateAuthentication(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *Tokens) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Access)
	if l > 0 {
		n += 1 + l + sovAuthentication(uint64(l))
	}
	if m.ExpiresAt != 0 {
		n += 1 + sovAuthentication(uint64(m.ExpiresAt))
	}
	l = len(m.Refresh)
	if l > 0 {
		n += 1 + l + sovAuthentication(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovAuthentication(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozAuthentication(x uint64) (n int) {
	return sovAuthentication(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Tokens) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAuthentication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Tokens: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Tokens: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Access", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthentication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuthentication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAuthentication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Access = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpiresAt", wireType)
			}
			m.ExpiresAt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthentication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ExpiresAt |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Refresh", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthentication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuthentication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAuthentication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Refresh = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAuthentication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAuthentication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAuthentication(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAuthentication
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAuthentication
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAuthentication
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthAuthentication
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupAuthentication
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthAuthentication
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthAuthentication        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAuthentication          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupAuthentication = fmt.Errorf("proto: unexpected end of group")
)
