package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBInstanceMetrics invokes the rds.DescribeDBInstanceMetrics API synchronously
func (client *Client) DescribeDBInstanceMetrics(request *DescribeDBInstanceMetricsRequest) (response *DescribeDBInstanceMetricsResponse, err error) {
	response = CreateDescribeDBInstanceMetricsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBInstanceMetricsWithChan invokes the rds.DescribeDBInstanceMetrics API asynchronously
func (client *Client) DescribeDBInstanceMetricsWithChan(request *DescribeDBInstanceMetricsRequest) (<-chan *DescribeDBInstanceMetricsResponse, <-chan error) {
	responseChan := make(chan *DescribeDBInstanceMetricsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBInstanceMetrics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBInstanceMetricsWithCallback invokes the rds.DescribeDBInstanceMetrics API asynchronously
func (client *Client) DescribeDBInstanceMetricsWithCallback(request *DescribeDBInstanceMetricsRequest, callback func(response *DescribeDBInstanceMetricsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBInstanceMetricsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBInstanceMetrics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBInstanceMetricsRequest is the request struct for api DescribeDBInstanceMetrics
type DescribeDBInstanceMetricsRequest struct {
	*requests.RpcRequest
	DBInstanceName       string           `position:"Query" name:"DBInstanceName"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDBInstanceMetricsResponse is the response struct for api DescribeDBInstanceMetrics
type DescribeDBInstanceMetricsResponse struct {
	*responses.BaseResponse
	TotalRecordCount int       `json:"TotalRecordCount" xml:"TotalRecordCount"`
	RequestId        string    `json:"RequestId" xml:"RequestId"`
	Items            []Metrics `json:"Items" xml:"Items"`
}

// CreateDescribeDBInstanceMetricsRequest creates a request to invoke DescribeDBInstanceMetrics API
func CreateDescribeDBInstanceMetricsRequest() (request *DescribeDBInstanceMetricsRequest) {
	request = &DescribeDBInstanceMetricsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeDBInstanceMetrics", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDBInstanceMetricsResponse creates a response to parse from DescribeDBInstanceMetrics response
func CreateDescribeDBInstanceMetricsResponse() (response *DescribeDBInstanceMetricsResponse) {
	response = &DescribeDBInstanceMetricsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
