package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateOnlineDatabaseTask invokes the rds.CreateOnlineDatabaseTask API synchronously
func (client *Client) CreateOnlineDatabaseTask(request *CreateOnlineDatabaseTaskRequest) (response *CreateOnlineDatabaseTaskResponse, err error) {
	response = CreateCreateOnlineDatabaseTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateOnlineDatabaseTaskWithChan invokes the rds.CreateOnlineDatabaseTask API asynchronously
func (client *Client) CreateOnlineDatabaseTaskWithChan(request *CreateOnlineDatabaseTaskRequest) (<-chan *CreateOnlineDatabaseTaskResponse, <-chan error) {
	responseChan := make(chan *CreateOnlineDatabaseTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateOnlineDatabaseTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateOnlineDatabaseTaskWithCallback invokes the rds.CreateOnlineDatabaseTask API asynchronously
func (client *Client) CreateOnlineDatabaseTaskWithCallback(request *CreateOnlineDatabaseTaskRequest, callback func(response *CreateOnlineDatabaseTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateOnlineDatabaseTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateOnlineDatabaseTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateOnlineDatabaseTaskRequest is the request struct for api CreateOnlineDatabaseTask
type CreateOnlineDatabaseTaskRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	MigrateTaskId        string           `position:"Query" name:"MigrateTaskId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	DBName               string           `position:"Query" name:"DBName"`
	CheckDBMode          string           `position:"Query" name:"CheckDBMode"`
}

// CreateOnlineDatabaseTaskResponse is the response struct for api CreateOnlineDatabaseTask
type CreateOnlineDatabaseTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateOnlineDatabaseTaskRequest creates a request to invoke CreateOnlineDatabaseTask API
func CreateCreateOnlineDatabaseTaskRequest() (request *CreateOnlineDatabaseTaskRequest) {
	request = &CreateOnlineDatabaseTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "CreateOnlineDatabaseTask", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateOnlineDatabaseTaskResponse creates a response to parse from CreateOnlineDatabaseTask response
func CreateCreateOnlineDatabaseTaskResponse() (response *CreateOnlineDatabaseTaskResponse) {
	response = &CreateOnlineDatabaseTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
