package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAlertLogCount invokes the cms.DescribeAlertLogCount API synchronously
func (client *Client) DescribeAlertLogCount(request *DescribeAlertLogCountRequest) (response *DescribeAlertLogCountResponse, err error) {
	response = CreateDescribeAlertLogCountResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAlertLogCountWithChan invokes the cms.DescribeAlertLogCount API asynchronously
func (client *Client) DescribeAlertLogCountWithChan(request *DescribeAlertLogCountRequest) (<-chan *DescribeAlertLogCountResponse, <-chan error) {
	responseChan := make(chan *DescribeAlertLogCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAlertLogCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAlertLogCountWithCallback invokes the cms.DescribeAlertLogCount API asynchronously
func (client *Client) DescribeAlertLogCountWithCallback(request *DescribeAlertLogCountRequest, callback func(response *DescribeAlertLogCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAlertLogCountResponse
		var err error
		defer close(result)
		response, err = client.DescribeAlertLogCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAlertLogCountRequest is the request struct for api DescribeAlertLogCount
type DescribeAlertLogCountRequest struct {
	*requests.RpcRequest
	SendStatus   string           `position:"Query" name:"SendStatus"`
	ContactGroup string           `position:"Query" name:"ContactGroup"`
	SearchKey    string           `position:"Query" name:"SearchKey"`
	RuleName     string           `position:"Query" name:"RuleName"`
	StartTime    requests.Integer `position:"Query" name:"StartTime"`
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
	LastMin      string           `position:"Query" name:"LastMin"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	MetricName   string           `position:"Query" name:"MetricName"`
	Product      string           `position:"Query" name:"Product"`
	Level        string           `position:"Query" name:"Level"`
	GroupId      string           `position:"Query" name:"GroupId"`
	EndTime      requests.Integer `position:"Query" name:"EndTime"`
	GroupBy      string           `position:"Query" name:"GroupBy"`
	Namespace    string           `position:"Query" name:"Namespace"`
}

// DescribeAlertLogCountResponse is the response struct for api DescribeAlertLogCount
type DescribeAlertLogCountResponse struct {
	*responses.BaseResponse
	Code          string              `json:"Code" xml:"Code"`
	Message       string              `json:"Message" xml:"Message"`
	RequestId     string              `json:"RequestId" xml:"RequestId"`
	Success       bool                `json:"Success" xml:"Success"`
	AlertLogCount []AlertLogCountItem `json:"AlertLogCount" xml:"AlertLogCount"`
}

// CreateDescribeAlertLogCountRequest creates a request to invoke DescribeAlertLogCount API
func CreateDescribeAlertLogCountRequest() (request *DescribeAlertLogCountRequest) {
	request = &DescribeAlertLogCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DescribeAlertLogCount", "Cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAlertLogCountResponse creates a response to parse from DescribeAlertLogCount response
func CreateDescribeAlertLogCountResponse() (response *DescribeAlertLogCountResponse) {
	response = &DescribeAlertLogCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
