// Macintosh port of the tnc extension for tDOM for Tcl
// Author: Bernard Desgraupes
// e-mail: bdesgraupes@easyconnect.fr
// web-page: http://webperso.easyconnect.fr/bdesgraupes/
// Last modification : 2003-02-19 08:53:51

#include <Types.r>
#include <SysTypes.r>

#define TNC_MAJOR 		0
#define TNC_MINOR 		3
#define TNC_SUBMINOR	0
#define TCL_MAJOR 		8
#define TCL_MINOR 		4

// developStage, alphaStage, betaStage, finalStage
#define TNC_STAGE 		betaStage

#if	(TNC_STAGE == developStage)
#		define	TNC_STAGE_CODE	'd'
#elif	(TNC_STAGE == alphaStage)
#		define	TNC_STAGE_CODE	'a'
#elif	(TNC_STAGE == betaStage)
#	 	define	TNC_STAGE_CODE	'b'
#elif	(TNC_STAGE == finalStage)
#	 	define	TNC_STAGE_CODE	'f'
#endif

#define	TNC_MAJOR_BCD	((TNC_MAJOR / 10) * 16) + (TNC_MAJOR % 10)
#define	TNC_MINOR_BCD	(TNC_MINOR * 16)

// #define	TNC_VERSION_STRING	$$Format("%d.%d%c%d", TNC_MAJOR, TNC_MINOR, \
// 											TNC_STAGE_CODE, TNC_SUBMINOR)

#define	TNC_VERSION_STRING	$$Format("%d.%d.%d", TNC_MAJOR, TNC_MINOR, TNC_SUBMINOR)

resource 'vers' (1) {
	TNC_MAJOR_BCD, 
	TNC_MINOR_BCD,
	TNC_STAGE, 
	0x00, 
	verUS,
	TNC_VERSION_STRING,
	$$Format("%s %s  %d\nported to Mac by B. Desgraupes", 
					"tnc", TNC_VERSION_STRING, $$YEAR)
};


resource 'vers' (2) {
	TNC_MAJOR_BCD, 
	TNC_MINOR_BCD,
	TNC_STAGE, 
	0x00, 
	verUS,
	TNC_VERSION_STRING,
	"Mac port of tnc extension for tDOM"
};


/*
 * The -16397 string will be displayed by Finder when a user
 * tries to open the shared library. The string should
 * give the user a little detail about the library's capabilities
 * and enough information to install the library in the correct location.  
 * A similar string should be placed in all shared libraries.
 */
resource 'STR ' (-16397, purgeable) {
	"tnc Library\n\n"
	"This library implements a set of tDOM C Handlers."
	" It should be placed in the Tool Command Language folder "
	"within the Extensions folder. To load it: "
	"'package require tnc'"
};

data 'TEXT' (1000,"pkgIndex",purgeable, preload) {
		$$Format("# Tcl package index file, version 1.0\npackage ifneeded tnc %d.%d.%d \"package require tdom;\nload [list [file join $dir tnc%d.%d[info sharedlibextension]]] tnc\"\n", TNC_MAJOR, TNC_MINOR, TNC_SUBMINOR, TCL_MAJOR, TCL_MINOR)
};

