const char misc_lua[] =
"-- misc.lua (internal file)\n"
"\n"
"--\n"
"-- Simple counter.\n"
"--\n"
"box.counter = {}\n"
"\n"
"--\n"
"-- Increment counter identified by primary key.\n"
"-- Create counter if not exists.\n"
"-- Returns updated value of the counter.\n"
"--\n"
"function box.counter.inc(space, ...)\n"
"    local key = {...}\n"
"    local cnt_index = #key\n"
"\n"
"    local tuple\n"
"    while true do\n"
"        tuple = box.update(space, key, '+p', cnt_index, 1)\n"
"        if tuple ~= nil then break end\n"
"        local data = {...}\n"
"        table.insert(data, 1)\n"
"        tuple = box.insert(space, unpack(data))\n"
"        if tuple ~= nil then break end\n"
"    end\n"
"\n"
"    return box.unpack('i', tuple[cnt_index])\n"
"end\n"
"\n"
"--\n"
"-- Decrement counter identified by primary key.\n"
"-- Delete counter if it decreased to zero.\n"
"-- Returns updated value of the counter.\n"
"--\n"
"function box.counter.dec(space, ...)\n"
"    local key = {...}\n"
"    local cnt_index = #key\n"
"\n"
"    local tuple = box.select(space, 0, ...)\n"
"    if tuple == nil then return 0 end\n"
"    if box.unpack('i', tuple[cnt_index]) == 1 then\n"
"        box.delete(space, ...)\n"
"        return 0\n"
"    else\n"
"        tuple = box.update(space, key, '-p', cnt_index, 1)\n"
"        return box.unpack('i', tuple[cnt_index])\n"
"    end\n"
"end\n"
"\n"
"\n"
"-- vim: set et ts=4 sts\n"
"-- Assumes that spaceno has a TREE int32 (NUM) or int64 (NUM64) primary key\n"
"-- inserts a tuple after getting the next value of the\n"
"-- primary key and returns it back to the user\n"
"function box.auto_increment(spaceno, ...)\n"
"    spaceno = tonumber(spaceno)\n"
"    local max_tuple = box.space[spaceno].index[0].idx:max()\n"
"    local max = 0\n"
"    if max_tuple ~= nil then\n"
"        max = max_tuple[0]\n"
"        local fmt = 'i'\n"
"        if #max == 8 then fmt = 'l' end\n"
"        max = box.unpack(fmt, max)\n"
"    else\n"
"        -- first time\n"
"        if box.space[spaceno].index[0].key_field[0].type == \"NUM64\" then\n"
"            max = tonumber64(max)\n"
"        end\n"
"    end\n"
"    return box.insert(spaceno, max + 1, ...)\n"
"end\n"
"\n"
"\n"
"-- vim: set et ts=4 sts\n"
""
;
