#
# * NON-GEOSTATIONARY EQUATORIAL-RING PROPOSALS
# *
# * O3b
# *
# * Named for 'the other three billion people' without good network
# * service.
# *
# * Announced with much publicity in September 2008. Some investment
# * from Google and others. Not yet built; first launch now expected
# * in 2013.
# *
# * See http://www.o3bnetworks.com/
# *
# * Satellite altitude has been altered slightly over time. See:
# *
# * Sea Launch signs launch agreement with O3b Networks, press release,
# * 23 September 2008.
# * ("equatorial injection orbit of 7,825 kilometers above the earth")
# *
# * O3b signs agreement with Arianespace, press release, 17 March 2010.
# * ("nearly 8,000 kilometers from the earth")
# *
# * http://www.o3bnetworks.com/AboutUs/faq.html checked 8 April 2011.
# * ("O3b is positioning its satellites in an orbit 8,063km from
# * Earth.")
# *
# * O3b satellites are under construction in France by Thales Alenia
# * Space.

# this script for SaVi by Lloyd Wood (lloydwood@users.sourceforge.net)
# http://www.ee.surrey.ac.uk/Personal/L.Wood/software/SaVi/
#
# $Id: o3b-networks.tcl,v 1.11 2013/05/05 05:19:25 lloydwood Exp $

# * An initial deployment of eight satellites.
set NUM_SATS 8

# sixteen more to follow.
# http://www.o3bnetworks.com/AboutUs/faq.html 24 May 2010.
# Contract signed for four more, taking to 12:
# O3b Networks set to virtually double fleet capacity as financing is
# secured to build four more satellites, O3b press release, 10 November 
# 2012.

# setup orbital elements
set a [expr 8063.0+$RADIUS_OF_EARTH]
set e 0.0
set inc 0.0
set omega 0.0
set T_per [expr 2 * $PI * pow($a,1.5) / sqrt($MU)]

# We're told coverage between 45 degrees of latitude.
# Ka-band, so a relatively high mask angle can be expected.
# But mask must be low to cover up to 45 deg lat consistently.
set coverage_angle 15.0

satellites GV_BEGIN

set T [expr $T_per ]
for {set j 0} {$j < $NUM_SATS} {incr j} {
	set Omega [expr $j * 360.0 / $NUM_SATS]
	satellites LOAD $a $e $inc $Omega $omega $T "03b Networks-$j"
}
satellites GV_END
