/* argscan.l - a flex scanner for the command line arguments
 *
 * Copyright (C) 2000  Jochen Voss.  */

	static  const char  rcsid [] = "$Id: argscan.l 4974 2003-05-09 23:07:09Z voss $";

	#include "sandcommon.h"
	#include "argparse.h"

	static  YY_BUFFER_STATE  arg_buffer;

%option batch
%option caseless
%option nodefault
%option nounput
%option noyywrap
%%
days		return DAYS;
hours		return HOURS;
min		return MINUTES;
sec		return SECONDS;
d		return DAYS;
h		return HOURS;
m		return MINUTES;
s		return SECONDS;
[[:digit:]]+	{
		  yylval.number = strtol (yytext, NULL, 10);
		  return  NUMBER;
		}
[[:space:]]+	/* eat up whitespace */
.		return (int)yytext[0];
%%
void
begin_arg (const char *arg)
{
  arg_buffer = yy_scan_string (arg);
}

void
end_arg (void)
{
  yy_delete_buffer (arg_buffer);
}
