/* test-ba.c - Use Gnome's bonobo-activation to instantiate the SandUhr.
 *
 * Copyright (C) 2003  Jochen Voss.  */

static const  char  rcsid[] = "$Id: test-ba.c 5727 2004-06-01 22:11:03Z voss $";

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <orbit/orbit.h>
#include <bonobo-activation/bonobo-activation.h>

#include "sanduhr.h"


static  CORBA_Environment  ev;

static void
check_err (void)
{
  switch (ev._major) {
  case CORBA_SYSTEM_EXCEPTION:
    g_warning ("CORBA system exception %s", CORBA_exception_id (&ev));
    break;
  case CORBA_USER_EXCEPTION:
    g_warning ("CORBA user exception %s", CORBA_exception_id (&ev));
    break;
  default:
    break;
  }
}


int
main (int argc, char **argv)
{
  CORBA_Object  factory, timer;
  CORBA_ORB  orb;
  const char *msg;

  CORBA_exception_init (&ev);
  orb = bonobo_activation_init (argc, argv);

  factory = bonobo_activation_activate_from_id
    ("OAFIID:sanduhr:c31c770f-1043-43b1-a843-660eba410128", 0, NULL, &ev);
  check_err ();
  if (factory == CORBA_OBJECT_NIL) {
    g_error ("error: bonobo_activation_activate_from_id failed");
    return 1;
  }

  timer = SandUhr_TimerFactory_CreateTimer
    (factory,
     "16:00",
     "Hund fttern damit er nicht jault",
     &ev);
  check_err ();

  msg = SandUhr_Timer__get_Message (timer, &ev);
  check_err ();
  printf ("timer::Message = %s\n", msg);

  msg = SandUhr_Timer__get_TimeSpec (timer, &ev);
  check_err ();
  printf ("timer::TimeSpec = %s\n", msg);

  puts ("Test exceptions:");
  SandUhr_Timer__set_TimeSpec (timer, "Hpf", &ev);
  check_err ();

  CORBA_exception_free (&ev);
  return 0;
}
