//===- LoongArchSubtarget.h - Define Subtarget for the LoongArch -*- C++ -*-==//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//
//
// This file declares the LoongArch specific subclass of TargetSubtargetInfo.
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_LIB_TARGET_LOONGARCH_LOONGARCHSUBTARGET_H
#define LLVM_LIB_TARGET_LOONGARCH_LOONGARCHSUBTARGET_H

#include "LoongArchFrameLowering.h"
#include "LoongArchISelLowering.h"
#include "LoongArchInstrInfo.h"
#include "LoongArchRegisterInfo.h"
#include "MCTargetDesc/LoongArchBaseInfo.h"
#include "llvm/CodeGen/SelectionDAGTargetInfo.h"
#include "llvm/CodeGen/TargetSubtargetInfo.h"
#include "llvm/IR/DataLayout.h"
#include "llvm/Target/TargetMachine.h"

#define GET_SUBTARGETINFO_HEADER
#include "LoongArchGenSubtargetInfo.inc"

namespace llvm {
class StringRef;

class LoongArchSubtarget : public LoongArchGenSubtargetInfo {
  virtual void anchor();
  bool HasLA32 = false;
  bool HasLA64 = false;
  bool HasBasicF = false;
  bool HasBasicD = false;
  bool HasExtLSX = false;
  bool HasExtLASX = false;
  bool HasExtLVZ = false;
  bool HasExtLBT = false;
  bool HasLaGlobalWithPcrel = false;
  bool HasLaGlobalWithAbs = false;
  bool HasLaLocalWithAbs = false;
  bool HasUAL = false;
  bool HasLinkerRelax = false;
  bool HasExpAutoVec = false;
  bool HasFrecipe = false;
  unsigned GRLen = 32;
  MVT GRLenVT = MVT::i32;
  LoongArchABI::ABI TargetABI = LoongArchABI::ABI_Unknown;
  LoongArchFrameLowering FrameLowering;
  LoongArchInstrInfo InstrInfo;
  LoongArchRegisterInfo RegInfo;
  LoongArchTargetLowering TLInfo;
  SelectionDAGTargetInfo TSInfo;

  Align PrefFunctionAlignment;
  Align PrefLoopAlignment;
  unsigned MaxBytesForAlignment;

  /// Initializes using the passed in CPU and feature strings so that we can
  /// use initializer lists for subtarget initialization.
  LoongArchSubtarget &initializeSubtargetDependencies(const Triple &TT,
                                                      StringRef CPU,
                                                      StringRef TuneCPU,
                                                      StringRef FS,
                                                      StringRef ABIName);

  /// Initialize properties based on the selected processor family.
  void initializeProperties(StringRef TuneCPU);

public:
  // Initializes the data members to match that of the specified triple.
  LoongArchSubtarget(const Triple &TT, StringRef CPU, StringRef TuneCPU,
                     StringRef FS, StringRef ABIName, const TargetMachine &TM);

  // Parses features string setting specified subtarget options. The
  // definition of this function is auto-generated by tblgen.
  void ParseSubtargetFeatures(StringRef CPU, StringRef TuneCPU, StringRef FS);

  const LoongArchFrameLowering *getFrameLowering() const override {
    return &FrameLowering;
  }
  const LoongArchInstrInfo *getInstrInfo() const override { return &InstrInfo; }
  const LoongArchRegisterInfo *getRegisterInfo() const override {
    return &RegInfo;
  }
  const LoongArchTargetLowering *getTargetLowering() const override {
    return &TLInfo;
  }
  const SelectionDAGTargetInfo *getSelectionDAGInfo() const override {
    return &TSInfo;
  }
  bool is64Bit() const { return HasLA64; }
  bool hasBasicF() const { return HasBasicF; }
  bool hasBasicD() const { return HasBasicD; }
  bool hasExtLSX() const { return HasExtLSX; }
  bool hasExtLASX() const { return HasExtLASX; }
  bool hasExtLVZ() const { return HasExtLVZ; }
  bool hasExtLBT() const { return HasExtLBT; }
  bool hasLaGlobalWithPcrel() const { return HasLaGlobalWithPcrel; }
  bool hasLaGlobalWithAbs() const { return HasLaGlobalWithAbs; }
  bool hasLaLocalWithAbs() const { return HasLaLocalWithAbs; }
  bool hasUAL() const { return HasUAL; }
  bool hasLinkerRelax() const { return HasLinkerRelax; }
  bool hasExpAutoVec() const { return HasExpAutoVec; }
  bool hasFrecipe() const { return HasFrecipe; }
  MVT getGRLenVT() const { return GRLenVT; }
  unsigned getGRLen() const { return GRLen; }
  LoongArchABI::ABI getTargetABI() const { return TargetABI; }
  bool isXRaySupported() const override { return is64Bit(); }
  Align getPrefFunctionAlignment() const { return PrefFunctionAlignment; }
  Align getPrefLoopAlignment() const { return PrefLoopAlignment; }
  unsigned getMaxBytesForAlignment() const { return MaxBytesForAlignment; }
};
} // end namespace llvm

#endif // LLVM_LIB_TARGET_LOONGARCH_LOONGARCHSUBTARGET_H
