
#line 1 "ragel/i18n/sk.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "ragel/i18n/sk.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_sk/gherkin_lexer_sk.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 21, 22, 23, 43, 44, 45, 
	47, 49, 54, 59, 64, 69, 73, 77, 
	79, 80, 81, 82, 83, 84, 85, 86, 
	87, 88, 89, 90, 91, 92, 93, 94, 
	95, 97, 99, 104, 111, 116, 119, 123, 
	127, 130, 133, 136, 139, 142, 145, 148, 
	151, 154, 157, 160, 163, 166, 169, 172, 
	173, 174, 175, 176, 177, 178, 179, 180, 
	181, 182, 195, 197, 199, 201, 203, 205, 
	207, 209, 211, 213, 215, 217, 219, 221, 
	223, 225, 227, 229, 231, 233, 235, 237, 
	257, 258, 259, 260, 261, 262, 263, 264, 
	265, 266, 267, 268, 269, 270, 271, 272, 
	273, 274, 276, 277, 278, 279, 295, 297, 
	299, 301, 303, 305, 307, 309, 311, 313, 
	315, 317, 319, 321, 323, 325, 329, 351, 
	352, 353, 354, 355, 356, 357, 358, 359, 
	360, 361, 362, 363, 364, 365, 367, 371, 
	372, 373, 374, 375, 376, 377, 378, 379, 
	380, 381, 382, 383, 384, 385, 386, 387, 
	388, 389, 390, 391, 409, 411, 413, 415, 
	417, 419, 421, 423, 425, 427, 429, 431, 
	433, 435, 437, 439, 443, 465, 466, 467, 
	468, 469, 470, 471, 472, 473, 474, 492, 
	494, 496, 498, 500, 502, 504, 506, 508, 
	510, 512, 514, 516, 518, 520, 522, 526, 
	548, 549, 550, 551, 552, 553, 554, 555, 
	556, 557, 558, 559, 560, 561, 562, 563, 
	564, 565, 566, 567, 568, 569, 570, 571, 
	572, 574, 575, 576, 577, 578, 579, 580, 
	581, 582, 583, 584, 585, 586, 587, 588, 
	589, 593, 599, 602, 604, 610, 630, 632, 
	634, 636, 638, 640, 642, 644, 646, 648, 
	650, 652, 654, 656, 658, 660, 662, 664, 
	666, 668, 670, 672, 674, 676, 678, 680, 
	683, 685, 687, 689, 691, 693, 695, 697, 
	699, 701, 703, 705, 707, 709, 711, 716, 
	718, 720, 722, 724, 726, 728, 730, 732, 
	734, 736, 738, 740, 742, 744, 746, 748, 
	750, 752, 754, 756, 758, 760, 762, 764, 
	766, 768, 770, 772, 774, 776, 778, 780, 
	782, 784, 786, 788, 790, 792, 794, 796, 
	798, 800, 802, 804, 806, 808, 810, 812, 
	813, 814, 815, 816, 817, 818, 819, 820, 
	821, 822, 823, 824, 825, 826, 827, 829, 
	831, 833, 835, 837, 839, 841, 843, 845, 
	847, 849, 851, 853, 855, 857, 859, 861, 
	863, 865, 867, 869, 871, 873, 875, 877, 
	880, 882, 884, 886, 888, 890, 892, 894, 
	896, 898, 900, 902, 904, 906, 908, 912, 
	914, 916, 918, 920, 922, 924, 926, 928, 
	930, 932, 934, 936, 938, 940, 942, 944, 
	946, 948, 950, 952, 954, 956, 958, 960, 
	962, 964, 966, 968, 970, 972, 974, 976, 
	978, 980, 982, 984, 986, 988, 990, 992, 
	994, 996, 998, 999, 1000, 1001, 1002, 1003, 
	1004, 1005, 1006, 1007, 1008, 1017, 1019, 1021, 
	1023, 1025, 1027, 1029, 1031, 1033, 1035, 1037, 
	1039, 1041, 1043, 1045, 1047, 1049, 1051, 1053, 
	1055, 1057, 1059, 1061, 1063, 1065, 1067, 1069, 
	1070, 1071, 1072, 1073, 1074, 1075, 1076, 1077, 
	1078, 1079, 1080, 1081, 1082, 1083, 1084, 1086, 
	1088, 1090, 1092, 1094, 1096, 1098, 1100, 1102, 
	1104, 1106, 1108, 1112, 1114, 1116, 1118, 1120, 
	1122, 1124, 1126, 1128, 1130, 1132, 1134, 1136, 
	1138, 1140, 1142, 1144, 1146, 1148, 1150, 1152, 
	1154, 1156, 1158, 1160, 1162, 1164, 1166, 1168, 
	1170, 1172, 1174, 1176, 1178, 1180, 1182, 1184, 
	1186, 1188, 1190, 1192, 1194, 1196, 1198, 1200, 
	1202, 1204, 1206, 1208, 1210, 1212, 1214, 1216, 
	1218, 1220, 1222, 1224, 1226, 1229, 1231, 1233, 
	1235, 1237, 1239, 1241, 1243, 1245, 1247, 1249, 
	1251, 1253, 1255, 1258, 1261, 1263, 1265, 1267, 
	1269, 1271, 1273, 1275, 1277, 1279, 1281, 1283, 
	1285, 1287, 1289, 1291, 1293, 1295, 1297, 1299, 
	1301, 1303, 1305, 1307, 1309, 1311, 1313, 1315, 
	1317, 1319, 1321, 1323, 1325, 1327
};

static const char _lexer_trans_keys[] = {
	-17, 10, 32, 34, 35, 37, 42, 64, 
	65, 70, 75, 78, 79, 80, 83, 84, 
	86, 90, 124, 9, 13, -69, -65, 10, 
	32, 34, 35, 37, 42, 64, 65, 70, 
	75, 78, 79, 80, 83, 84, 86, 90, 
	124, 9, 13, 34, 34, 10, 13, 10, 
	13, 10, 32, 34, 9, 13, 10, 32, 
	34, 9, 13, 10, 32, 34, 9, 13, 
	10, 32, 34, 9, 13, 10, 32, 9, 
	13, 10, 32, 9, 13, 10, 13, 10, 
	95, 70, 69, 65, 84, 85, 82, 69, 
	95, 69, 78, 68, 95, 37, 32, 10, 
	13, 10, 13, 13, 32, 64, 9, 10, 
	9, 10, 13, 32, 64, 11, 12, 10, 
	32, 64, 9, 13, 32, 107, 108, 10, 
	13, 116, 122, 10, 13, 97, 105, 10, 
	13, 107, 10, 13, 116, 10, 13, 105, 
	10, 13, 101, -59, 10, 13, -66, 10, 
	13, 10, 13, 32, -61, 10, 13, -95, 
	10, 13, 10, 13, 114, 10, 13, 111, 
	10, 13, 118, 10, 13, 101, -59, 10, 
	13, -120, 10, 13, 101, 117, 110, 107, 
	99, 105, 97, 58, 10, 10, 10, 32, 
	35, 37, 64, 70, 78, 79, 80, 83, 
	86, 9, 13, 10, 95, 10, 70, 10, 
	69, 10, 65, 10, 84, 10, 85, 10, 
	82, 10, 69, 10, 95, 10, 69, 10, 
	78, 10, 68, 10, 95, 10, 37, 10, 
	117, 10, 110, 10, 107, 10, 99, 10, 
	105, 10, 97, 10, 58, 10, 32, 34, 
	35, 37, 42, 64, 65, 70, 75, 78, 
	79, 80, 83, 84, 86, 90, 124, 9, 
	13, 101, -60, -113, -61, -95, -60, -115, 
	114, 116, 32, 83, 99, 101, 110, -61, 
	-95, 114, 97, 117, 58, 10, 10, 10, 
	32, 35, 37, 42, 64, 65, 70, 75, 
	80, 83, 84, 86, 90, 9, 13, 10, 
	95, 10, 70, 10, 69, 10, 65, 10, 
	84, 10, 85, 10, 82, 10, 69, 10, 
	95, 10, 69, 10, 78, 10, 68, 10, 
	95, 10, 37, 10, 32, 10, 32, 107, 
	108, 10, 32, 34, 35, 37, 42, 64, 
	65, 70, 75, 78, 79, 80, 83, 84, 
	86, 90, 116, 122, 124, 9, 13, 115, 
	110, 111, 118, 97, 32, 83, 99, 101, 
	110, -61, -95, 114, 97, 111, 114, -59, 
	107, 116, 122, -66, 105, 97, 100, 97, 
	118, 107, 105, 97, -60, -66, 111, 109, 
	97, 100, 105, 101, 58, 10, 10, 10, 
	32, 35, 37, 42, 64, 65, 70, 75, 
	78, 79, 80, 83, 84, 86, 90, 9, 
	13, 10, 95, 10, 70, 10, 69, 10, 
	65, 10, 84, 10, 85, 10, 82, 10, 
	69, 10, 95, 10, 69, 10, 78, 10, 
	68, 10, 95, 10, 37, 10, 32, 10, 
	32, 107, 108, 10, 32, 34, 35, 37, 
	42, 64, 65, 70, 75, 78, 79, 80, 
	83, 84, 86, 90, 116, 122, 124, 9, 
	13, 99, 101, 110, -61, -95, 114, 58, 
	10, 10, 10, 32, 35, 37, 42, 64, 
	65, 70, 75, 78, 79, 80, 83, 84, 
	86, 90, 9, 13, 10, 95, 10, 70, 
	10, 69, 10, 65, 10, 84, 10, 85, 
	10, 82, 10, 69, 10, 95, 10, 69, 
	10, 78, 10, 68, 10, 95, 10, 37, 
	10, 32, 10, 32, 107, 108, 10, 32, 
	34, 35, 37, 42, 64, 65, 70, 75, 
	78, 79, 80, 83, 84, 86, 90, 116, 
	122, 124, 9, 13, 97, 107, 108, 97, 
	115, 116, 110, 111, 115, -59, -91, 97, 
	32, 112, 114, 101, 100, 112, 111, 107, 
	108, 97, 100, 117, 97, 105, 107, 116, 
	105, 101, -59, -66, 32, -61, -95, 114, 
	111, 118, 101, -59, -120, 32, 124, 9, 
	13, 10, 32, 92, 124, 9, 13, 10, 
	92, 124, 10, 92, 10, 32, 92, 124, 
	9, 13, 10, 32, 34, 35, 37, 42, 
	64, 65, 70, 75, 78, 79, 80, 83, 
	84, 86, 90, 124, 9, 13, 10, 101, 
	10, 117, 10, 110, 10, 107, 10, 99, 
	10, 105, 10, 97, 10, 58, 10, 101, 
	-60, 10, -113, 10, -61, 10, -95, 10, 
	-60, 10, -115, 10, 10, 114, 10, 116, 
	10, 32, 10, 83, 10, 99, 10, 101, 
	10, 110, -61, 10, -95, 10, 10, 114, 
	10, 97, 117, 10, 115, 10, 110, 10, 
	111, 10, 118, 10, 97, 10, 32, 10, 
	83, 10, 99, 10, 101, 10, 110, -61, 
	10, -95, 10, 10, 114, 10, 111, -59, 
	10, 107, 116, 122, -66, 10, 10, 105, 
	10, 97, 10, 100, 10, 97, 10, 118, 
	10, 107, 10, 105, 10, 97, -60, 10, 
	-66, 10, 10, 111, 10, 109, 10, 97, 
	10, 100, 10, 105, 10, 101, 10, 99, 
	10, 101, 10, 110, -61, 10, -95, 10, 
	10, 114, 10, 97, 10, 107, 10, 108, 
	10, 97, 10, 115, 10, 116, 10, 110, 
	10, 111, 10, 115, -59, 10, -91, 10, 
	10, 97, 10, 32, 10, 112, 10, 114, 
	10, 101, 10, 100, 10, 112, 10, 111, 
	10, 107, 10, 108, 10, 97, 10, 100, 
	10, 117, 97, 105, 107, 116, 105, 101, 
	-59, -66, 32, -61, -95, 114, 111, 118, 
	101, -59, -120, 10, 101, 10, 117, 10, 
	110, 10, 107, 10, 99, 10, 105, 10, 
	97, 10, 58, 10, 101, -60, 10, -113, 
	10, -61, 10, -95, 10, -60, 10, -115, 
	10, 10, 114, 10, 116, 10, 32, 10, 
	83, 10, 99, 10, 101, 10, 110, -61, 
	10, -95, 10, 10, 114, 10, 97, 117, 
	10, 115, 10, 110, 10, 111, 10, 118, 
	10, 97, 10, 32, 10, 83, 10, 99, 
	10, 101, 10, 110, -61, 10, -95, 10, 
	10, 114, 10, 111, -59, 10, 107, 116, 
	-66, 10, 10, 105, 10, 97, 10, 100, 
	10, 97, 10, 118, 10, 107, 10, 105, 
	10, 97, -60, 10, -66, 10, 10, 111, 
	10, 109, 10, 99, 10, 101, 10, 110, 
	-61, 10, -95, 10, 10, 114, 10, 97, 
	10, 107, 10, 108, 10, 97, 10, 115, 
	10, 116, 10, 110, 10, 111, 10, 115, 
	-59, 10, -91, 10, 10, 97, 10, 32, 
	10, 112, 10, 114, 10, 101, 10, 100, 
	10, 112, 10, 111, 10, 107, 10, 108, 
	10, 97, 10, 100, 10, 117, -61, -83, 
	107, 108, 97, 100, 121, 58, 10, 10, 
	10, 32, 35, 70, 80, 86, 124, 9, 
	13, 10, 117, 10, 110, 10, 107, 10, 
	99, 10, 105, 10, 97, 10, 58, 10, 
	111, -59, 10, -66, 10, 10, 105, 10, 
	97, 10, 100, 10, 97, 10, 118, 10, 
	107, 10, 108, 10, 97, 10, 115, 10, 
	116, 10, 110, 10, 111, 10, 115, -59, 
	10, -91, 10, 97, 105, 107, 116, 105, 
	101, -59, -66, 32, -61, -95, 114, 111, 
	118, 101, -59, -120, 10, 101, 10, 117, 
	10, 110, 10, 107, 10, 99, 10, 105, 
	10, 97, 10, 58, 10, 101, -60, 10, 
	-113, 10, 10, 111, -59, 10, 107, 116, 
	-66, 10, 10, 105, 10, 97, 10, 100, 
	10, 97, 10, 118, 10, 107, 10, 105, 
	10, 97, -60, 10, -66, 10, 10, 111, 
	10, 109, 10, 99, 10, 101, 10, 110, 
	-61, 10, -95, 10, 10, 114, 10, 97, 
	10, 107, 10, 108, 10, 97, 10, 115, 
	10, 116, 10, 110, 10, 111, 10, 115, 
	-59, 10, -91, 10, 10, 97, 10, 32, 
	10, 112, 10, 114, 10, 101, 10, 100, 
	10, 112, 10, 111, 10, 107, 10, 108, 
	10, 97, 10, 100, 10, 117, -61, 10, 
	-95, 10, -60, 10, -115, 10, 10, 114, 
	10, 116, 10, 32, 10, 83, 10, 99, 
	10, 101, 10, 110, -61, 10, -95, 10, 
	10, 114, 10, 97, 117, 10, 115, 10, 
	110, 10, 111, 10, 118, 10, 97, 10, 
	32, 10, 83, 10, 99, 10, 101, 10, 
	110, -61, 10, -95, 10, 10, 114, 10, 
	111, 114, -59, 10, 122, -66, 10, 10, 
	105, 10, 97, 10, 100, 10, 97, 10, 
	118, 10, 107, 10, 97, 10, 100, 10, 
	105, 10, 101, -61, 10, -83, 10, 10, 
	107, 10, 108, 10, 97, 10, 100, 10, 
	121, 10, 99, 10, 101, 10, 110, -61, 
	10, -95, 10, 10, 114, 10, 108, 10, 
	97, 10, 115, 10, 116, 10, 110, 10, 
	111, 10, 115, -59, 10, -91, 10, 0
};

static const char _lexer_single_lengths[] = {
	0, 19, 1, 1, 18, 1, 1, 2, 
	2, 3, 3, 3, 3, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	2, 2, 3, 5, 3, 3, 4, 4, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 11, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 18, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 2, 1, 1, 1, 14, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 4, 20, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 2, 4, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 16, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 4, 20, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 16, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 4, 20, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	2, 4, 3, 2, 4, 18, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 5, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 4, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 7, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 4, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 1, 0, 0, 0, 
	0, 1, 1, 1, 1, 1, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 1, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 1, 0, 0, 1, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 21, 23, 25, 45, 47, 49, 
	52, 55, 60, 65, 70, 75, 79, 83, 
	86, 88, 90, 92, 94, 96, 98, 100, 
	102, 104, 106, 108, 110, 112, 114, 116, 
	118, 121, 124, 129, 136, 141, 145, 150, 
	155, 159, 163, 167, 171, 175, 179, 183, 
	187, 191, 195, 199, 203, 207, 211, 215, 
	217, 219, 221, 223, 225, 227, 229, 231, 
	233, 235, 248, 251, 254, 257, 260, 263, 
	266, 269, 272, 275, 278, 281, 284, 287, 
	290, 293, 296, 299, 302, 305, 308, 311, 
	331, 333, 335, 337, 339, 341, 343, 345, 
	347, 349, 351, 353, 355, 357, 359, 361, 
	363, 365, 368, 370, 372, 374, 390, 393, 
	396, 399, 402, 405, 408, 411, 414, 417, 
	420, 423, 426, 429, 432, 435, 440, 462, 
	464, 466, 468, 470, 472, 474, 476, 478, 
	480, 482, 484, 486, 488, 490, 493, 498, 
	500, 502, 504, 506, 508, 510, 512, 514, 
	516, 518, 520, 522, 524, 526, 528, 530, 
	532, 534, 536, 538, 556, 559, 562, 565, 
	568, 571, 574, 577, 580, 583, 586, 589, 
	592, 595, 598, 601, 606, 628, 630, 632, 
	634, 636, 638, 640, 642, 644, 646, 664, 
	667, 670, 673, 676, 679, 682, 685, 688, 
	691, 694, 697, 700, 703, 706, 709, 714, 
	736, 738, 740, 742, 744, 746, 748, 750, 
	752, 754, 756, 758, 760, 762, 764, 766, 
	768, 770, 772, 774, 776, 778, 780, 782, 
	784, 787, 789, 791, 793, 795, 797, 799, 
	801, 803, 805, 807, 809, 811, 813, 815, 
	817, 821, 827, 831, 834, 840, 860, 863, 
	866, 869, 872, 875, 878, 881, 884, 887, 
	890, 893, 896, 899, 902, 905, 908, 911, 
	914, 917, 920, 923, 926, 929, 932, 935, 
	939, 942, 945, 948, 951, 954, 957, 960, 
	963, 966, 969, 972, 975, 978, 981, 987, 
	990, 993, 996, 999, 1002, 1005, 1008, 1011, 
	1014, 1017, 1020, 1023, 1026, 1029, 1032, 1035, 
	1038, 1041, 1044, 1047, 1050, 1053, 1056, 1059, 
	1062, 1065, 1068, 1071, 1074, 1077, 1080, 1083, 
	1086, 1089, 1092, 1095, 1098, 1101, 1104, 1107, 
	1110, 1113, 1116, 1119, 1122, 1125, 1128, 1131, 
	1133, 1135, 1137, 1139, 1141, 1143, 1145, 1147, 
	1149, 1151, 1153, 1155, 1157, 1159, 1161, 1164, 
	1167, 1170, 1173, 1176, 1179, 1182, 1185, 1188, 
	1191, 1194, 1197, 1200, 1203, 1206, 1209, 1212, 
	1215, 1218, 1221, 1224, 1227, 1230, 1233, 1236, 
	1240, 1243, 1246, 1249, 1252, 1255, 1258, 1261, 
	1264, 1267, 1270, 1273, 1276, 1279, 1282, 1287, 
	1290, 1293, 1296, 1299, 1302, 1305, 1308, 1311, 
	1314, 1317, 1320, 1323, 1326, 1329, 1332, 1335, 
	1338, 1341, 1344, 1347, 1350, 1353, 1356, 1359, 
	1362, 1365, 1368, 1371, 1374, 1377, 1380, 1383, 
	1386, 1389, 1392, 1395, 1398, 1401, 1404, 1407, 
	1410, 1413, 1416, 1418, 1420, 1422, 1424, 1426, 
	1428, 1430, 1432, 1434, 1436, 1445, 1448, 1451, 
	1454, 1457, 1460, 1463, 1466, 1469, 1472, 1475, 
	1478, 1481, 1484, 1487, 1490, 1493, 1496, 1499, 
	1502, 1505, 1508, 1511, 1514, 1517, 1520, 1523, 
	1525, 1527, 1529, 1531, 1533, 1535, 1537, 1539, 
	1541, 1543, 1545, 1547, 1549, 1551, 1553, 1556, 
	1559, 1562, 1565, 1568, 1571, 1574, 1577, 1580, 
	1583, 1586, 1589, 1594, 1597, 1600, 1603, 1606, 
	1609, 1612, 1615, 1618, 1621, 1624, 1627, 1630, 
	1633, 1636, 1639, 1642, 1645, 1648, 1651, 1654, 
	1657, 1660, 1663, 1666, 1669, 1672, 1675, 1678, 
	1681, 1684, 1687, 1690, 1693, 1696, 1699, 1702, 
	1705, 1708, 1711, 1714, 1717, 1720, 1723, 1726, 
	1729, 1732, 1735, 1738, 1741, 1744, 1747, 1750, 
	1753, 1756, 1759, 1762, 1765, 1769, 1772, 1775, 
	1778, 1781, 1784, 1787, 1790, 1793, 1796, 1799, 
	1802, 1805, 1808, 1812, 1816, 1819, 1822, 1825, 
	1828, 1831, 1834, 1837, 1840, 1843, 1846, 1849, 
	1852, 1855, 1858, 1861, 1864, 1867, 1870, 1873, 
	1876, 1879, 1882, 1885, 1888, 1891, 1894, 1897, 
	1900, 1903, 1906, 1909, 1912, 1915
};

static const short _lexer_trans_targs[] = {
	2, 4, 4, 5, 15, 17, 31, 34, 
	37, 56, 88, 91, 127, 141, 181, 208, 
	210, 219, 248, 4, 0, 3, 0, 4, 
	0, 4, 4, 5, 15, 17, 31, 34, 
	37, 56, 88, 91, 127, 141, 181, 208, 
	210, 219, 248, 4, 0, 6, 0, 7, 
	0, 9, 8, 8, 9, 8, 8, 10, 
	10, 11, 10, 10, 10, 10, 11, 10, 
	10, 10, 10, 12, 10, 10, 10, 10, 
	13, 10, 10, 4, 14, 14, 0, 4, 
	14, 14, 0, 4, 16, 15, 4, 0, 
	18, 0, 19, 0, 20, 0, 21, 0, 
	22, 0, 23, 0, 24, 0, 25, 0, 
	26, 0, 27, 0, 28, 0, 29, 0, 
	30, 0, 613, 0, 32, 0, 4, 16, 
	33, 4, 16, 33, 0, 0, 0, 0, 
	35, 36, 4, 36, 36, 34, 35, 35, 
	4, 36, 34, 36, 0, 38, 31, 55, 
	0, 4, 16, 39, 47, 33, 4, 16, 
	40, 43, 33, 4, 16, 41, 33, 4, 
	16, 42, 33, 4, 16, 43, 33, 4, 
	16, 44, 33, 45, 4, 16, 33, 46, 
	4, 16, 33, 4, 16, 32, 33, 48, 
	4, 16, 33, 49, 4, 16, 33, 4, 
	16, 50, 33, 4, 16, 51, 33, 4, 
	16, 52, 33, 4, 16, 53, 33, 54, 
	4, 16, 33, 46, 4, 16, 33, 31, 
	0, 57, 0, 58, 0, 59, 0, 60, 
	0, 61, 0, 62, 0, 63, 0, 65, 
	64, 65, 64, 65, 65, 4, 66, 4, 
	80, 550, 565, 578, 598, 604, 65, 64, 
	65, 67, 64, 65, 68, 64, 65, 69, 
	64, 65, 70, 64, 65, 71, 64, 65, 
	72, 64, 65, 73, 64, 65, 74, 64, 
	65, 75, 64, 65, 76, 64, 65, 77, 
	64, 65, 78, 64, 65, 79, 64, 65, 
	4, 64, 65, 81, 64, 65, 82, 64, 
	65, 83, 64, 65, 84, 64, 65, 85, 
	64, 65, 86, 64, 65, 87, 64, 4, 
	4, 5, 15, 17, 31, 34, 37, 56, 
	88, 91, 127, 141, 181, 208, 210, 219, 
	248, 4, 0, 89, 0, 90, 0, 31, 
	0, 92, 0, 93, 0, 94, 0, 95, 
	0, 96, 0, 97, 0, 98, 0, 99, 
	0, 100, 0, 101, 0, 102, 0, 103, 
	0, 104, 0, 105, 0, 106, 106, 0, 
	107, 0, 109, 108, 109, 108, 109, 109, 
	4, 110, 124, 4, 125, 495, 502, 505, 
	520, 526, 528, 537, 109, 108, 109, 111, 
	108, 109, 112, 108, 109, 113, 108, 109, 
	114, 108, 109, 115, 108, 109, 116, 108, 
	109, 117, 108, 109, 118, 108, 109, 119, 
	108, 109, 120, 108, 109, 121, 108, 109, 
	122, 108, 109, 123, 108, 109, 4, 108, 
	109, 87, 108, 109, 126, 124, 494, 108, 
	4, 4, 5, 15, 17, 31, 34, 37, 
	56, 88, 91, 127, 141, 181, 208, 210, 
	219, 478, 486, 248, 4, 0, 128, 0, 
	129, 0, 130, 0, 131, 0, 132, 0, 
	133, 0, 134, 0, 135, 0, 136, 0, 
	137, 0, 138, 0, 139, 0, 140, 0, 
	106, 0, 142, 442, 0, 143, 150, 154, 
	156, 0, 144, 0, 145, 0, 146, 0, 
	147, 0, 148, 0, 149, 0, 61, 0, 
	151, 0, 152, 0, 153, 0, 31, 0, 
	155, 0, 31, 0, 157, 0, 158, 0, 
	159, 0, 160, 0, 161, 0, 163, 162, 
	163, 162, 163, 163, 4, 164, 178, 4, 
	179, 359, 366, 369, 384, 397, 412, 418, 
	420, 429, 163, 162, 163, 165, 162, 163, 
	166, 162, 163, 167, 162, 163, 168, 162, 
	163, 169, 162, 163, 170, 162, 163, 171, 
	162, 163, 172, 162, 163, 173, 162, 163, 
	174, 162, 163, 175, 162, 163, 176, 162, 
	163, 177, 162, 163, 4, 162, 163, 87, 
	162, 163, 180, 178, 358, 162, 4, 4, 
	5, 15, 17, 31, 34, 37, 56, 88, 
	91, 127, 141, 181, 208, 210, 219, 342, 
	350, 248, 4, 0, 182, 0, 183, 0, 
	184, 0, 185, 0, 186, 0, 187, 0, 
	188, 0, 190, 189, 190, 189, 190, 190, 
	4, 191, 205, 4, 206, 255, 262, 265, 
	280, 293, 312, 318, 320, 329, 190, 189, 
	190, 192, 189, 190, 193, 189, 190, 194, 
	189, 190, 195, 189, 190, 196, 189, 190, 
	197, 189, 190, 198, 189, 190, 199, 189, 
	190, 200, 189, 190, 201, 189, 190, 202, 
	189, 190, 203, 189, 190, 204, 189, 190, 
	4, 189, 190, 87, 189, 190, 207, 205, 
	254, 189, 4, 4, 5, 15, 17, 31, 
	34, 37, 56, 88, 91, 127, 141, 181, 
	208, 210, 219, 232, 240, 248, 4, 0, 
	209, 0, 31, 0, 211, 0, 212, 0, 
	213, 0, 214, 0, 215, 0, 216, 0, 
	217, 0, 218, 0, 62, 0, 220, 0, 
	221, 0, 222, 0, 223, 0, 224, 0, 
	225, 0, 226, 0, 227, 0, 228, 0, 
	229, 0, 230, 0, 231, 0, 31, 0, 
	233, 236, 0, 234, 0, 235, 0, 236, 
	0, 237, 0, 238, 0, 239, 0, 87, 
	0, 241, 0, 242, 0, 243, 0, 244, 
	0, 245, 0, 246, 0, 247, 0, 239, 
	0, 248, 249, 248, 0, 253, 252, 251, 
	249, 252, 250, 0, 251, 249, 250, 0, 
	251, 250, 253, 252, 251, 249, 252, 250, 
	253, 253, 5, 15, 17, 31, 34, 37, 
	56, 88, 91, 127, 141, 181, 208, 210, 
	219, 248, 253, 0, 190, 205, 189, 190, 
	256, 189, 190, 257, 189, 190, 258, 189, 
	190, 259, 189, 190, 260, 189, 190, 261, 
	189, 190, 87, 189, 190, 263, 189, 264, 
	190, 189, 205, 190, 189, 266, 190, 189, 
	267, 190, 189, 268, 190, 189, 269, 190, 
	189, 190, 270, 189, 190, 271, 189, 190, 
	272, 189, 190, 273, 189, 190, 274, 189, 
	190, 275, 189, 190, 276, 189, 277, 190, 
	189, 278, 190, 189, 190, 279, 189, 190, 
	261, 261, 189, 190, 281, 189, 190, 282, 
	189, 190, 283, 189, 190, 284, 189, 190, 
	285, 189, 190, 286, 189, 190, 287, 189, 
	190, 288, 189, 190, 289, 189, 190, 290, 
	189, 291, 190, 189, 292, 190, 189, 190, 
	260, 189, 190, 294, 189, 295, 190, 302, 
	306, 308, 189, 296, 190, 189, 190, 297, 
	189, 190, 298, 189, 190, 299, 189, 190, 
	300, 189, 190, 301, 189, 190, 260, 189, 
	190, 303, 189, 190, 304, 189, 305, 190, 
	189, 205, 190, 189, 190, 307, 189, 190, 
	205, 189, 190, 309, 189, 190, 310, 189, 
	190, 311, 189, 190, 261, 189, 190, 313, 
	189, 190, 314, 189, 190, 315, 189, 316, 
	190, 189, 317, 190, 189, 190, 261, 189, 
	190, 319, 189, 190, 205, 189, 190, 321, 
	189, 190, 322, 189, 190, 323, 189, 190, 
	324, 189, 190, 325, 189, 190, 326, 189, 
	190, 327, 189, 328, 190, 189, 261, 190, 
	189, 190, 330, 189, 190, 331, 189, 190, 
	332, 189, 190, 333, 189, 190, 334, 189, 
	190, 335, 189, 190, 336, 189, 190, 337, 
	189, 190, 338, 189, 190, 339, 189, 190, 
	340, 189, 190, 341, 189, 190, 205, 189, 
	343, 346, 0, 344, 0, 345, 0, 346, 
	0, 347, 0, 348, 0, 349, 0, 87, 
	0, 351, 0, 352, 0, 353, 0, 354, 
	0, 355, 0, 356, 0, 357, 0, 349, 
	0, 163, 178, 162, 163, 360, 162, 163, 
	361, 162, 163, 362, 162, 163, 363, 162, 
	163, 364, 162, 163, 365, 162, 163, 87, 
	162, 163, 367, 162, 368, 163, 162, 178, 
	163, 162, 370, 163, 162, 371, 163, 162, 
	372, 163, 162, 373, 163, 162, 163, 374, 
	162, 163, 375, 162, 163, 376, 162, 163, 
	377, 162, 163, 378, 162, 163, 379, 162, 
	163, 380, 162, 381, 163, 162, 382, 163, 
	162, 163, 383, 162, 163, 365, 365, 162, 
	163, 385, 162, 163, 386, 162, 163, 387, 
	162, 163, 388, 162, 163, 389, 162, 163, 
	390, 162, 163, 391, 162, 163, 392, 162, 
	163, 393, 162, 163, 394, 162, 395, 163, 
	162, 396, 163, 162, 163, 364, 162, 163, 
	398, 162, 399, 163, 406, 410, 162, 400, 
	163, 162, 163, 401, 162, 163, 402, 162, 
	163, 403, 162, 163, 404, 162, 163, 405, 
	162, 163, 364, 162, 163, 407, 162, 163, 
	408, 162, 409, 163, 162, 178, 163, 162, 
	163, 411, 162, 163, 178, 162, 163, 413, 
	162, 163, 414, 162, 163, 415, 162, 416, 
	163, 162, 417, 163, 162, 163, 365, 162, 
	163, 419, 162, 163, 178, 162, 163, 421, 
	162, 163, 422, 162, 163, 423, 162, 163, 
	424, 162, 163, 425, 162, 163, 426, 162, 
	163, 427, 162, 428, 163, 162, 365, 163, 
	162, 163, 430, 162, 163, 431, 162, 163, 
	432, 162, 163, 433, 162, 163, 434, 162, 
	163, 435, 162, 163, 436, 162, 163, 437, 
	162, 163, 438, 162, 163, 439, 162, 163, 
	440, 162, 163, 441, 162, 163, 178, 162, 
	443, 0, 444, 0, 445, 0, 446, 0, 
	447, 0, 448, 0, 449, 0, 450, 0, 
	452, 451, 452, 451, 452, 452, 4, 453, 
	460, 469, 4, 452, 451, 452, 454, 451, 
	452, 455, 451, 452, 456, 451, 452, 457, 
	451, 452, 458, 451, 452, 459, 451, 452, 
	87, 451, 452, 461, 451, 462, 452, 451, 
	463, 452, 451, 452, 464, 451, 452, 465, 
	451, 452, 466, 451, 452, 467, 451, 452, 
	468, 451, 452, 458, 451, 452, 470, 451, 
	452, 471, 451, 452, 472, 451, 452, 473, 
	451, 452, 474, 451, 452, 475, 451, 452, 
	476, 451, 477, 452, 451, 459, 452, 451, 
	479, 482, 0, 480, 0, 481, 0, 482, 
	0, 483, 0, 484, 0, 485, 0, 87, 
	0, 487, 0, 488, 0, 489, 0, 490, 
	0, 491, 0, 492, 0, 493, 0, 485, 
	0, 109, 124, 108, 109, 496, 108, 109, 
	497, 108, 109, 498, 108, 109, 499, 108, 
	109, 500, 108, 109, 501, 108, 109, 87, 
	108, 109, 503, 108, 504, 109, 108, 124, 
	109, 108, 109, 506, 108, 507, 109, 514, 
	518, 108, 508, 109, 108, 109, 509, 108, 
	109, 510, 108, 109, 511, 108, 109, 512, 
	108, 109, 513, 108, 109, 500, 108, 109, 
	515, 108, 109, 516, 108, 517, 109, 108, 
	124, 109, 108, 109, 519, 108, 109, 124, 
	108, 109, 521, 108, 109, 522, 108, 109, 
	523, 108, 524, 109, 108, 525, 109, 108, 
	109, 501, 108, 109, 527, 108, 109, 124, 
	108, 109, 529, 108, 109, 530, 108, 109, 
	531, 108, 109, 532, 108, 109, 533, 108, 
	109, 534, 108, 109, 535, 108, 536, 109, 
	108, 501, 109, 108, 109, 538, 108, 109, 
	539, 108, 109, 540, 108, 109, 541, 108, 
	109, 542, 108, 109, 543, 108, 109, 544, 
	108, 109, 545, 108, 109, 546, 108, 109, 
	547, 108, 109, 548, 108, 109, 549, 108, 
	109, 124, 108, 551, 65, 64, 552, 65, 
	64, 553, 65, 64, 554, 65, 64, 65, 
	555, 64, 65, 556, 64, 65, 557, 64, 
	65, 558, 64, 65, 559, 64, 65, 560, 
	64, 65, 561, 64, 562, 65, 64, 563, 
	65, 64, 65, 564, 64, 65, 86, 86, 
	64, 65, 566, 64, 65, 567, 64, 65, 
	568, 64, 65, 569, 64, 65, 570, 64, 
	65, 571, 64, 65, 572, 64, 65, 573, 
	64, 65, 574, 64, 65, 575, 64, 576, 
	65, 64, 577, 65, 64, 65, 85, 64, 
	65, 579, 591, 64, 580, 65, 587, 64, 
	581, 65, 64, 65, 582, 64, 65, 583, 
	64, 65, 584, 64, 65, 585, 64, 65, 
	586, 64, 65, 85, 64, 65, 588, 64, 
	65, 589, 64, 65, 590, 64, 65, 86, 
	64, 592, 65, 64, 593, 65, 64, 65, 
	594, 64, 65, 595, 64, 65, 596, 64, 
	65, 597, 64, 65, 86, 64, 65, 599, 
	64, 65, 600, 64, 65, 601, 64, 602, 
	65, 64, 603, 65, 64, 65, 86, 64, 
	65, 605, 64, 65, 606, 64, 65, 607, 
	64, 65, 608, 64, 65, 609, 64, 65, 
	610, 64, 65, 611, 64, 612, 65, 64, 
	86, 65, 64, 0, 0
};

static const unsigned char _lexer_trans_actions[] = {
	0, 54, 0, 5, 1, 0, 29, 1, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 35, 0, 43, 0, 43, 0, 
	43, 54, 0, 5, 1, 0, 29, 1, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 35, 0, 43, 0, 43, 0, 
	43, 139, 48, 9, 106, 11, 0, 134, 
	45, 45, 45, 3, 122, 33, 33, 33, 
	0, 122, 33, 33, 33, 0, 122, 33, 
	0, 33, 0, 102, 7, 7, 43, 54, 
	0, 0, 43, 114, 25, 0, 54, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 149, 126, 
	57, 110, 23, 0, 43, 43, 43, 43, 
	0, 27, 118, 27, 27, 51, 27, 0, 
	54, 0, 1, 0, 43, 0, 0, 0, 
	43, 149, 126, 57, 57, 57, 110, 23, 
	0, 0, 0, 110, 23, 0, 0, 110, 
	23, 0, 0, 110, 23, 0, 0, 110, 
	23, 0, 0, 0, 110, 23, 0, 0, 
	110, 23, 0, 110, 23, 0, 0, 0, 
	110, 23, 0, 0, 110, 23, 0, 110, 
	23, 0, 0, 110, 23, 0, 0, 110, 
	23, 0, 0, 110, 23, 0, 0, 0, 
	110, 23, 0, 0, 110, 23, 0, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 144, 
	57, 54, 0, 54, 0, 69, 33, 69, 
	84, 84, 84, 84, 84, 84, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	13, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 13, 0, 130, 
	31, 60, 57, 31, 63, 57, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	66, 31, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 0, 43, 
	0, 43, 144, 57, 54, 0, 54, 0, 
	78, 33, 84, 78, 84, 84, 84, 84, 
	84, 84, 84, 84, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 19, 0, 
	54, 19, 0, 54, 19, 0, 0, 0, 
	130, 31, 60, 57, 31, 63, 57, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 0, 0, 66, 31, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 0, 43, 0, 0, 0, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 144, 57, 
	54, 0, 54, 0, 72, 33, 84, 72, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 15, 0, 54, 15, 
	0, 54, 15, 0, 0, 0, 130, 31, 
	60, 57, 31, 63, 57, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 0, 
	0, 66, 31, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 144, 57, 54, 0, 54, 0, 
	75, 33, 84, 75, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	17, 0, 54, 17, 0, 54, 17, 0, 
	0, 0, 130, 31, 60, 57, 31, 63, 
	57, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 63, 0, 0, 66, 31, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 17, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 0, 0, 43, 54, 37, 37, 
	87, 37, 37, 43, 0, 39, 0, 43, 
	0, 0, 54, 0, 0, 39, 0, 0, 
	54, 0, 93, 90, 41, 96, 90, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 99, 0, 43, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 17, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 0, 0, 0, 54, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 15, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 15, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 0, 0, 
	54, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	144, 57, 54, 0, 54, 0, 81, 84, 
	84, 84, 81, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	21, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 19, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 19, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 0, 54, 0, 
	0, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 0, 0, 54, 0, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 613;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "ragel/i18n/sk.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  /* Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters */
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1343 "ext/gherkin_lexer_sk/gherkin_lexer_sk.c"
	{
	cs = lexer_start;
	}

#line 425 "ragel/i18n/sk.c.rl"
    
#line 1350 "ext/gherkin_lexer_sk/gherkin_lexer_sk.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "ragel/i18n/sk.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "ragel/i18n/sk.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "ragel/i18n/sk.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "ragel/i18n/sk.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "ragel/i18n/sk.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "ragel/i18n/sk.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "ragel/i18n/sk.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "ragel/i18n/sk.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "ragel/i18n/sk.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "ragel/i18n/sk.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "ragel/i18n/sk.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "ragel/i18n/sk.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "ragel/i18n/sk.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "ragel/i18n/sk.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "ragel/i18n/sk.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "ragel/i18n/sk.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "ragel/i18n/sk.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "ragel/i18n/sk.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "ragel/i18n/sk.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "ragel/i18n/sk.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "ragel/i18n/sk.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "ragel/i18n/sk.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "ragel/i18n/sk.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "ragel/i18n/sk.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1640 "ext/gherkin_lexer_sk/gherkin_lexer_sk.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "ragel/i18n/sk.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1703 "ext/gherkin_lexer_sk/gherkin_lexer_sk.c"
		}
	}
	}

	_out: {}
	}

#line 426 "ragel/i18n/sk.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    /* Reset lexer by re-initializing the whole thing */
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_sk()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Sk", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

