/*
*  Rubrica
*  file: 
*
*  
*  Copyright (C) 2000-2005 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <glade/glade.h>

#include "libral.h"

#include "app.h"
#include "groups_view.h"
#include "groups_cb.h"
#include "themes.h"
#include "types.h"



static void on_entry_activated (GtkWidget* entry, gpointer data);
static void on_add_group       (GtkWidget* button, gpointer data);
static void on_remove_group    (GtkWidget* button, gpointer data);
static void on_rename_group    (GtkWidget* button, gpointer data);


static void
on_entry_activated(GtkWidget* entry, gpointer data)
{
  g_signal_emit_by_name(G_OBJECT(data), "clicked", NULL);
}


static void
on_add_group (GtkWidget* button, gpointer data)
{
  GladeXML* gui;  
  RubricaGroupsView* view = RUBRICA_GROUPS_VIEW(data);
  RGroupBox* groups_box;
  RGroup* group;
  GtkWidget* entry;
  GtkWidget* loadbt;
  GtkWidget* ok;
  GtkWidget* dialog;
  GtkImage* image;
  gchar* str;             /* group name */
  gchar* uri = NULL;      /* pixmap uri */
  gint response;
  
  groups_box = rubrica_groups_view_get_group_box(view);

  gui = glade_xml_new (RUBRICA_GUI_DIR"/NewGroup.glade", NULL, NULL);  
  if (!gui)
    g_error("\nCan't load interface");
  
  dialog = glade_xml_get_widget(gui, "newgroup");
  ok     = glade_xml_get_widget(gui, "okbutton1");
  entry  = glade_xml_get_widget(gui, "group_entry");
  loadbt = glade_xml_get_widget(gui, "loadbt");
  image  = (GtkImage*) glade_xml_get_widget(gui, "image");
  g_object_unref(gui);

  g_object_set_data(G_OBJECT(loadbt), "uri", uri);

  g_signal_connect(G_OBJECT(entry), "activate",
		   G_CALLBACK(on_entry_activated), ok);

  g_signal_connect(G_OBJECT(loadbt), "clicked", 
		   G_CALLBACK(rubrica_themes_load_pixmap), image);
   
  response = gtk_dialog_run(GTK_DIALOG(dialog));
  switch (response)
    {
    case GTK_RESPONSE_OK:           
      str = g_strdup(gtk_entry_get_text(GTK_ENTRY(entry)));
      uri = g_object_get_data(G_OBJECT(loadbt), "uri");

      group = r_group_new();
      g_object_set(group, 
		   "group-name", str, "group-label", str, 
		   "group-owner", "user", "group-pixmap", uri, 
		   "enabled", FALSE, NULL);
      r_group_box_add_group(groups_box, group);
      break;
      
    case GTK_RESPONSE_CANCEL:
      break;
      
    default:
      break;
    }  
  
  gtk_widget_destroy(dialog);  
}


static void
on_remove_group (GtkWidget* button, gpointer data)
{
  RubricaGroupsView* view = RUBRICA_GROUPS_VIEW(data);
  RGroupBox* box;
  RGroup* group;
  GtkTreeView* tree;
  GtkTreeIter iter;
  GtkTreeModel* model;
  GtkTreeSelection *selection;
  gchar* user = NULL;
  gchar* name = NULL;
  
  box       = rubrica_groups_view_get_group_box(view);
  tree      = GTK_TREE_VIEW(rubrica_view_get_tree(RUBRICA_VIEW(view)));
  model     = gtk_tree_view_get_model(GTK_TREE_VIEW(tree));
  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(tree));

  if (gtk_tree_selection_get_selected(selection, &model, &iter))
    {
      gtk_tree_model_get(model, &iter, 
			 GROUP_NAME_COLUMN, &name,
			 GROUP_OWNER_COLUMN, &user,
			 -1);
      
      if (user && (g_ascii_strcasecmp("user", user) == 0))
	{
	  group = r_group_box_find(box, name);
	  if (group)
	    r_group_box_delete_group(box, group);
	}
    }  
}


static void
on_rename_group (GtkWidget* button, gpointer data)
{
  RubricaGroupsView* view = RUBRICA_GROUPS_VIEW(data);
  RGroupBox* box;
  GtkTreeView* tree;
  GtkTreeIter iter;
  GtkTreeModel* model;
  GtkTreeSelection *selection;
  gchar* user = NULL;
  gchar* name = NULL;
  
  box       = rubrica_groups_view_get_group_box(view);
  tree      = GTK_TREE_VIEW(rubrica_view_get_tree(RUBRICA_VIEW(view)));
  model     = gtk_tree_view_get_model(GTK_TREE_VIEW(tree));
  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(tree));

  if (gtk_tree_selection_get_selected(selection, &model, &iter))
    {
      gtk_tree_model_get(model, &iter, 
			 GROUP_NAME_COLUMN, &name,
			 GROUP_OWNER_COLUMN, &user,
			 -1);
      
      if (user && (g_ascii_strcasecmp("user", user) == 0))
	{
	  gchar* newname;
	  
	  newname = g_strdup_printf("%s%d", name, rand());
	  
	  r_group_box_rename_group(box, name, newname);
	}
    }  
}



/*   Public
*/

gboolean 
on_app_group_view_event_occurred (GtkTreeView* tree, GdkEvent *event,
				  gpointer data)
{
  RubricaApp* app = (RubricaApp*) data;
  GdkEventButton *ev = (GdkEventButton *)event;
  GtkTreeModel *model;
  GtkTreeSelection *selection; 
  GtkTreePath *path = NULL;
  GtkTreeIter iter;
  GtkWidget* view;

  view      = rubrica_app_get_groups_view(RUBRICA_APP(app));
  model     = gtk_tree_view_get_model(GTK_TREE_VIEW(tree));
  selection = gtk_tree_view_get_selection(tree);
  gtk_tree_selection_unselect_all(selection);
  
  if (gtk_tree_view_get_path_at_pos(tree, ev->x, ev->y, &path, NULL, 
				    NULL, NULL))
    {
      gtk_tree_selection_select_path(selection, path);
      gtk_tree_model_get_iter(model, &iter, path);
      gtk_tree_path_free(path);

      if ((ev->type == GDK_BUTTON_PRESS) && (ev->button == 3))
	{
	  GtkMenu* menu;
	  GtkWidget *remove;
	  GtkWidget *rename;
	  GtkWidget *add;	  
	  gchar* user = NULL;
   
	  gtk_tree_model_get(model, &iter, GROUP_OWNER_COLUMN, &user, -1);
	  
	  menu = (GtkMenu*) gtk_menu_new();
	  
	  add = gtk_menu_item_new_with_mnemonic (_("add ne_w group"));
	  gtk_widget_show (add);
	  gtk_container_add (GTK_CONTAINER (menu), add);
	  
	  rename = gtk_menu_item_new_with_mnemonic (_("_rename group"));
	  gtk_widget_show (rename);
	  gtk_container_add (GTK_CONTAINER (menu), rename);

	  remove = gtk_menu_item_new_with_mnemonic (_("_remove group"));
	  gtk_widget_show (remove);
	  gtk_container_add (GTK_CONTAINER (menu), remove);
	  
	  if (user && (g_ascii_strcasecmp("user", user) == 0))
	    {
	      gtk_widget_set_sensitive(remove, TRUE);
	      gtk_widget_set_sensitive(rename, TRUE);
	    }
	  else
	    {
	      gtk_widget_set_sensitive(remove, FALSE);
	      gtk_widget_set_sensitive(rename, FALSE);
	    }
	  
	  g_signal_connect (G_OBJECT(add), "activate",
			    G_CALLBACK (on_add_group), view);
	  
	  g_signal_connect (G_OBJECT(remove), "activate",
			    G_CALLBACK (on_remove_group), view);
	  	  
	  g_signal_connect (G_OBJECT(rename), "activate",
			    G_CALLBACK (on_rename_group), view);

	  gtk_widget_show_all(GTK_WIDGET(menu));
	  gtk_menu_popup (menu, NULL, NULL, NULL, NULL, ev->button, ev->time);

	}
      else
	if ((ev->type == GDK_BUTTON_PRESS) && (ev->button == 1))
	  {
	    gchar* group;

	    gtk_tree_model_get(model, &iter, GROUP_NAME_COLUMN, &group, -1);
	    
	    rubrica_app_display_cards_by_group(app, group);
	  }
    }
  
  return FALSE;
}



gboolean
on_form_group_view_event_occurred (GtkTreeView* tree, GdkEvent *event,
				   gpointer data)
{
  GdkEventButton *ev = (GdkEventButton *)event;
  GtkTreeSelection *selection; 
  GtkTreeModel *model;
  GtkTreePath *path = NULL;
  GtkTreeIter iter;
  GtkWidget* group_view = (GtkWidget*) data;

  model     = gtk_tree_view_get_model(GTK_TREE_VIEW(tree));
  selection = gtk_tree_view_get_selection(tree);
  gtk_tree_selection_unselect_all(selection);

  if (gtk_tree_view_get_path_at_pos(tree, ev->x, ev->y, &path, NULL, 
				    NULL, NULL))
    {
      gtk_tree_selection_select_path(selection, path);
      gtk_tree_model_get_iter(model, &iter, path);
      gtk_tree_path_free(path);

      if ((ev->type == GDK_BUTTON_PRESS) && (ev->button == 3))
	{
	  GtkMenu* menu;
	  GtkWidget *remove;
	  GtkWidget *rename;
	  GtkWidget *add;	  
	  gchar* user = NULL;
   
	  gtk_tree_model_get(model, &iter, GROUP_OWNER_COLUMN, &user, -1);
	  
	  menu = (GtkMenu*) gtk_menu_new();
	  
	  add = gtk_menu_item_new_with_mnemonic ("add ne_w group");
	  gtk_widget_show (add);
	  gtk_container_add (GTK_CONTAINER (menu), add);
	  
	  rename = gtk_menu_item_new_with_mnemonic ("_rename group");
	  gtk_widget_show (rename);
	  gtk_container_add (GTK_CONTAINER (menu), rename);

	  remove = gtk_menu_item_new_with_mnemonic ("_remove group");
	  gtk_widget_show (remove);
	  gtk_container_add (GTK_CONTAINER (menu), remove);
	  
	  if (user && (g_ascii_strcasecmp("user", user) == 0))
	    {
	      gtk_widget_set_sensitive(remove, TRUE);
	      gtk_widget_set_sensitive(rename, TRUE);
	    }
	  else
	    {
	      gtk_widget_set_sensitive(remove, FALSE);
	      gtk_widget_set_sensitive(rename, FALSE);
	    }
	  
	  g_signal_connect (G_OBJECT(add), "activate",
			    G_CALLBACK (on_add_group), group_view);
	  
	  g_signal_connect (G_OBJECT(remove), "activate",
			    G_CALLBACK (on_remove_group), group_view);	  
	  	  
	  g_signal_connect (G_OBJECT(rename), "activate",
			    G_CALLBACK (on_rename_group), group_view);	  

	  gtk_widget_show_all(GTK_WIDGET(menu));
	  gtk_menu_popup (menu, NULL, NULL, NULL, NULL, ev->button, ev->time);
	}
    }
  
  return FALSE;
}

 /*
gint
on_key_press_event (GtkWidget *widget, GdkEventKey *event, gpointer data)
{
  evaluate event so calendar is navigable with keyboard 
  switch (event->keyval)
    {
    case GDK_Escape:
      break;
      
    case GDK_Return:
    case GDK_KP_Enter:
    case 
      break;
      
    default:
      return FALSE;
    }
  
  g_signal_stop_emission_by_name (widget, "key_press_event");
  hide_popup (RUBRICA_CALENDAR(data));

  return TRUE;
}
*/
