% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.with.progress.R
\name{rk.with.progress}
\alias{rk.with.progress}
\title{Run a command with an associated progress dialog}
\usage{
rk.with.progress(expr, text = "")
}
\arguments{
\item{expr}{Command to run}

\item{text}{Short user-visible explanation of what is being done. E.g. "Downloading XY..."}
}
\value{
Returns the result of evaluating the expression. The result is always returned invisibly.
}
\description{
\code{rk.with.progress()} evaluates the given R expression, while showing a UI dialog to monitor the progress, and allowing the user
to cancel the operation.
}
\note{
This function should be used sparingly. For code designed to be run in the R Console window, or as part of other R functions, it
       should be omitted. Rather it should only be used for top-level operations where progress is not immediately visible. A prime use case
       may be a plugin that performs a large download.
}
\examples{
\dontrun{
rk.with.progress({
   for (i in 1:80) {
      cat('=')
      Sys.sleep(.1)
   }
   cat('\n')
}, "Waiting for nothing...")
}

}
\author{
Thomas Friedrichsmeier \email{rkward-devel@kde.org}
}
\keyword{utilities}
