/*  RipOff - Plugin based CD Ripper
 *  Copyright (C) 2006 Bobby Ryan Newberry
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "RipOff.h"
#include "RipOffTrack.h"
#include "RipOffConfigFile.h"
#include "config.h"
#include <cdio/paranoia.h>

/* all RipOffPlugin structs that you define must start with these two fields
   in this order */
struct RipOffPluginRaw_
{
	gchar *name;
	gchar *label;
};
typedef struct RipOffPluginRaw_ * RipOffPluginRaw;

RipOffPluginRaw ripoff_plugin_raw_new(xmlDocPtr ptr);

/* This function returns the name of the plugin that will be shown in the preferences 
   dialog. */
gchar *ripoff_plugin_raw_get_name(RipOffPluginRaw raw);

/* This function returns a label that will be used to represent the plugin in the loading/saving
of preferences. If it isn't unique very odd things will happen */
gchar *ripoff_plugin_raw_get_label(RipOffPluginRaw raw);

/* Returns the file extension RipOff should append to the end of the encoded file 
this plugin will output. Example: "ogg" NOT ".ogg" (the '.' is handled for you) */
const gchar *ripoff_plugin_raw_get_extension(RipOffPluginRaw raw);

/* Returns whether the plugin has a preferences dialog. This ensures that the option
   is greyed out and the plugin is never asked to display a preferences dialog */
gboolean ripoff_plugin_raw_has_prefs(RipOffPluginRaw raw);

/* A GtkWindow that contains plugin configuration information and functionality. 
   Any values it changse should be contained in your plugin objects data structures and
   handled by you */
GtkWidget *ripoff_plugin_raw_prefs(RipOffPluginRaw raw);

/* Returns whether the plugin has an about dialog. Ensures that the option 
   is greyed out and the plugin is never asked to display an about dialog */
gboolean ripoff_plugin_raw_has_about(RipOffPluginRaw raw);

/* A GtkWindow that contains "about" information you wish to show to the user.
   Examples include your name, e-mail, licensing info, copyright etc. */
GtkWidget *ripoff_plugin_raw_about(RipOffPluginRaw raw);

/* This is where you should perform all your setup operations before you actually
   start encoding audio data. output-descriptor points to the beginning of the file
   and is opened. track is all the meatadata about the track */
gboolean ripoff_plugin_raw_perform_setup(	RipOffPluginRaw raw,
						long total_bytes_to_encode,
						FILE *output_descriptor,
						RipOffTrack track);

/* This is where the bulk of the encoding action occurs. audio_data is a pointer
   to a buffer CDIO_CD_FRAMESIZE_RAW bytes long. The plugin should encode the buffer
   and output the encoded data to output_descriptor */
gboolean ripoff_plugin_raw_encode_buffer(	RipOffPluginRaw raw,
						long total_bytes_to_encode,
						int16_t *audio_data,
						FILE *output_descriptor,
						RipOffTrack track);

/* DO NOT close the output_file descriptor. RipOff will handle all file
descriptor opening and closings for you. Instead, make sure all your audio
data has been written and any closing operations have been performed */
gboolean ripoff_plugin_raw_perform_cleanup(	RipOffPluginRaw raw,
						long total_bytes_to_encode,
						FILE *output_descriptor,
						RipOffTrack track);

/* Informs the plugin that it should save its preferences */
void ripoff_plugin_raw_close(RipOffPluginRaw raw);
