#ifndef _GENRCM_H
#define _GENRCM_H
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================

/* genrcm.f -- translated by f2c (version 19931217).*/

/*****************************************************************/
/*****************************************************************/
/*********   GENRCM ..... GENERAL REVERSE CUTHILL MCKEE   ********/
/*****************************************************************/

/*    PURPOSE - GENRCM FINDS THE REVERSE CUTHILL-MCKEE*/
/*       ORDERING FOR A GENERAL GRAPH. FOR EACH CONNECTED*/
/*       COMPONENT IN THE GRAPH, GENRCM OBTAINS THE ORDERING*/
/*       BY CALLING THE SUBROUTINE RCM.*/

/*    INPUT PARAMETERS -*/
/*       NEQNS - NUMBER OF EQUATIONS*/
/*       (XADJ, ADJNCY) - ARRAY PAIR CONTAINING THE ADJACENCY*/
/*              STRUCTURE OF THE GRAPH OF THE MATRIX.*/

/*    OUTPUT PARAMETER -*/
/*       PERM - VECTOR THAT CONTAINS THE RCM ORDERING.*/

/*    WORKING PARAMETERS -*/
/*       MASK - IS USED TO MARK VARIABLES THAT HAVE BEEN*/
/*              NUMBERED DURING THE ORDERING PROCESS. IT IS*/
/*              INITIALIZED TO 1, AND SET TO ZERO AS EACH NODE*/
/*              IS NUMBERED.*/
/*       XLS - THE INDEX VECTOR FOR A LEVEL STRUCTURE.  THE*/
/*              LEVEL STRUCTURE IS STORED IN THE CURRENTLY*/
/*              UNUSED SPACES IN THE PERMUTATION VECTOR PERM.*/

/*    PROGRAM SUBROUTINES -*/
/*       FNROOT, RCM.*/
/*****************************************************************/

#include "rheolef/fnroot.h"
#include "rheolef/rcm.h"
namespace rheolef { 

template <class Size, class Iterator>
void
genrcm(
	Size     neqns,
	Iterator xadj,
	Iterator adjncy, 
	Iterator perm,
	Iterator mask,
	Iterator xls)
{
    typedef typename std::iterator_traits<Iterator>::value_type  Integer;

    /* System generated locals */
    Integer i__1;

    /* Local variables */
    static Integer nlvl, root, i, ccsize;
    static Integer num;

    /* Parameter adjustments */
    --xls;
    --mask;
    --perm;
    --adjncy;
    --xadj;

    i__1 = neqns;
    for (i = 1; i <= i__1; ++i) {
	mask[i] = 1;
    }
    num = 1;
    i__1 = neqns;
    for (i = 1; i <= i__1; ++i) {
/*          FOR EACH MASKED CONNECTED COMPONENT ...*/
	if (mask[i] == 0) {
	    goto L200;
	}
	root = i;
/*             FIRST FIND A PSEUDO-PERIPHERAL NODE ROOT.*/
/*             NOTE THAT THE LEVEL STRUCTURE FOUND BY*/
/*             FNROOT IS STORED STARTING AT PERM(NUM).*/
/*             THEN RCM IS CALLED TO ORDER THE COMPONENT*/
/*             USING ROOT AS THE STARTING NODE.*/

	fnroot(&root, &xadj[1], &adjncy[1], &mask[1], &nlvl, &xls[1], &perm[num]);
	rcm(&root, &xadj[1], &adjncy[1], &mask[1], &perm[num], &ccsize, &xls[1]);

	num += ccsize;
	if (num > neqns) {
	    return;
	}
L200:
	;
    }
}
}// namespace rheolef
#endif // _GENRCM_H
