#!/usr/bin/python
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# --------------------------------------------------------------------------
import vtk

# --------------------------------
# geo visualization with mayavi
# --------------------------------
geo_color = [					\
	[ 1, 0, 0],				\
	[ 0, 1, 0],				\
	[ 0, 0, 1],				\
	[ 1, 1, 0],				\
	[ 1, 0, 1],				\
	[ 0, 1, 1],				\
	[0.8900, 0.1500, 0.2100	],		\
	[0.6400, 0.5800, 0.5000 ],		\
	[1.0000, 0.3800, 0.0100	] ]

cut_plane = vtk.vtkPlane()

def mayavi_geo_domain (v, option, filename, dom_name, idx):

  data = v.open_vtk(filename, config=0)
  if idx == 0:
      a = v.load_module ('Axes', config=0)
      o = v.load_module ('Outline', config=0)

  color = geo_color[idx % len(geo_color)]
  if idx == 0 and option['full']:
      edge_filter     = v.load_filter('UserDefined', 0, 'vtkExtractEdges')

  if option['cut']:
      polydata_filter = v.load_filter('UserDefined', 0, 'vtkGeometryFilter')
      clip_filter     = v.load_filter('UserDefined', 0, 'vtkClipPolyData')
      clip_filter.fil.SetClipFunction(cut_plane)

  text = v.load_module('Text', config=0)
  text.act.SetInput(dom_name)
  text.tprop.SetFontSize(16)
  text.tprop.SetColor(color)
  coord = text.act.GetPositionCoordinate()
  coord.SetCoordinateSystemToNormalizedViewport()
  coord.SetValue(0.02, 0.02 + idx*0.04)
  coord2 = text.act.GetPosition2Coordinate()
  coord2.SetCoordinateSystemToNormalizedViewport()
  text.act.SetHeight(0.04)
  text.act.SetWidth(0.4)
  text.act.ScaledTextOn()

  module = v.load_module('SurfaceMap', config=0)
  module.actor.GetProperty().SetColor(color)
  if option['fill']:
    module.actor.GetProperty().SetRepresentationToSurface()
  else:
    module.actor.GetProperty().SetRepresentationToWireframe()

  if idx == 0 and option['cut']:
      # re-read data...(?)
      data2 = v.open_vtk(filename, config=0)
      cut_plane.SetNormal(option['normal'])
      if option['has_origin']:
         cut_plane.SetOrigin(option['origin'])
      else:
         origin = data2.GetOutput().GetCenter()
         cut_plane.SetOrigin(origin)
      cutter_filter   = v.load_filter('UserDefined', 0, 'vtkCutter')
      cutter_filter.fil.SetCutFunction(cut_plane)
      show_cutted_surf = option['fill']
      show_cutted_grid = not option['fill'] or option['full']
      if show_cutted_grid:
        module1 = v.load_module('SurfaceMap', config=0)
        module1.actor.GetProperty().SetColor(0, 0, 0)
        module1.actor.GetProperty().SetRepresentationToWireframe()
      if show_cutted_surf:
        module2 = v.load_module('SurfaceMap', config=0)
        module2.actor.GetProperty().SetColor(0.9, 0.9, 0.9)
        module2.actor.GetProperty().SetRepresentationToSurface()

def mayavi_geo (v, option, d):
  has_only_bdry = option['fill'] and not (option['fill'] or option['cut'])
  if not has_only_bdry:
    mayavi_geo_domain (v, option, d[0]+".vtk", "mesh", 0)
  for i in range(1,len(d)):
    mayavi_geo_domain (v, option, d[0]+"."+d[i]+".vtk", d[i], i)
  

