///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
//  test de la classe field
//  
//  interpolation: ok
//  boundary_val:

#include "rheolef/field.h" 
#include "rheolef/tiny_matvec.h"
using namespace rheolef;
using namespace std;

void usage()
{
  cerr << "tst_field: usage: tst_field"
       << " [P0][P1][P1d][P2]"
       << " [Q0][Q1][Q1d][Q2]\n" ;
  exit(1) ;
}

//
// fonctions de test
//
Float f1( point  x )
{
  return x[0] + 10.*x[1] ;
}
Float f2( point  x )
{
  return -x[0] - 5.*x[1] ;
}

int main(int argc, char**argv)
{
  //
  // command line: a choice of approximation
  //
  if (argc != 2) usage() ;
  geo g ;
  if (argv[1][0] == 'P')
//    g = geo("tri4-v2") ;
    g = geo("tri2-v2") ;
  else if (argv[1][0] == 'Q')
    g = geo("quadri2-v2") ;
  else usage() ;
  //
  // build space
  //
  space X_h(g, argv[1]) ;
//  X_h.block("bottom") ;
  X_h.block("top") ;
  X_h.freeze() ;

  //
  // begin tests
  //

  field x__h(X_h) ;

  // test interpolation

  x__h = 1. ;
  cout << "x__h=1:\n" << x__h << "\n" ;
  x__h = f1 ;
  cout << "x__h=f1=x+10y:\n" << x__h << "\n" ;

  // tests on boundary

  // show space in order to know blocked and free
  cout << X_h << "\n" ;
  // constant value
  x__h.boundary_val(-2, 0, "top") ;
  cout << "x__h.boundary_val(-2, 0, top):\n"
       << x__h
       << "\n" ;
  // analytic fonction
  x__h.boundary_val(f2, X_h, 0, "top") ;
  cout << "x__h.boundary_val(f2, X_h, 0, top):\n"
       << x__h
       << "\n" ;
  // known field
  field y__h(X_h) ;
  y__h = f2 ;
  cout << "y__h=f2=-x-5y:\n" << y__h << "\n" ;
  x__h.boundary_val(y__h, 0, "top") ;
  cout << "x__h.boundary_val(y__h, 0, top):\n"
       << x__h
       << "\n" ;

}
