#include "rheolef.h"
using namespace rheolef;
using namespace std;

const Float epsilon = 0.01;

int main(int argc, char**argv) {
    geo omega (argv[1]);
    space Vh (omega, "P1");
    Vh.block ("left");
    Vh.block ("right");
    field uh (Vh);
    uh["left"] = uh["right"] = 0;
    field fh (Vh, 1);

    field eta (Vh);
    eta ["east"] = 1;
    eta ["west"] = epsilon;
    form a (Vh, Vh, "grad_grad", eta); 
    form m    (Vh, Vh, "mass"); 
    ssk<Float> fact = ldlt(a.uu);
    uh.u = fact.solve (m.uu*fh.u + m.ub*fh.b - a.ub*uh.b);
    cout << setprecision(numeric_limits<Float>::digits10)
         << catchmark("epsilon") << epsilon << endl
         << catchmark("u")       << uh;
    return 0;
}
