set terminal pslatex auxfile
set output "demo2-P1-uniform.tex"

set logscale
set size square

set xtics (\
        "{$10^{-3}$}" 1e-3, \
	"{$10^{-2}$}" 1e-2, \
	"{$10^{-1}$}" 1e-1 \
	)
set ytics (\
        "[r]{$10^{-6}$}" 1e-6, \
        "[r]{$10^{-5}$}" 1e-5, \
        "[r]{$10^{-4}$}" 1e-4, \
        "[r]{$10^{-3}$}" 1e-3, \
	"[r]{$10^{-2}$}" 1e-2 \
	)

# figure label
set label "$P_1$ element" at graph 0.05, 0.90 left

# x-label
set label "[r]{$nelt^{-{1 \\over 2}}$}" at graph 0.95, 0.10 right

set label "[l]{$\\Vert u_h-\\pi_h u\\Vert_{0,2,\\Omega} $}"       at graph 0.05, 0.27
set label "[l]{$\\Vert u_h-\\pi_h u\\Vert_{0,\\infty,\\Omega} $}" at graph 0.05, 0.47

# triangle slope: 2
set arrow from graph 0.60, 0.20 to graph 0.80, 0.20 nohead lt 1
set arrow from graph 0.80, 0.20 to graph 0.80, 0.40 nohead lt 1
set arrow from graph 0.80, 0.40 to graph 0.60, 0.20 nohead lt 1
set label "[l]{$\\scriptstyle 2 = k+1$}" at graph 0.83, 0.30 left

plot [1e-3:1e-1][1e-6:1e-2] \
	"demo2-P1-uniform.gdat" u (1./sqrt($1)):3 notitle with linespoints linetype 1, \
	"demo2-P1-uniform.gdat" u (1./sqrt($1)):4 notitle with linespoints linetype 1

#pause -1 "<retour>"

