#include "rheolef.h"
using namespace rheolef;
using namespace std;
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  const Float epsilon = 0.01;
  geo omega (argv[1]);
  space Xh (omega, "P1");
  Xh.block ("left");
  Xh.block ("right");
  space Qh (omega, "P0", "vector");
  test v (Xh);
  field eta (Qh);
  eta ["east"] = 1;
  eta ["west"] = epsilon;
  field lh = integrate (v);
  form b = -form(Xh, Qh, "grad"); 
  form inv_m (Qh, Qh, "inv_mass", 1/eta); 
  form a = trans(b)*inv_m*b;
  solver sa (a.uu);
  uh.u = fact.solve (lh.u - a.ub*uh.b);
  cout << catchmark("epsilon") << epsilon << endl
       << catchmark("u")       << uh;
}
