#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "sinusprod.icc"
int main(int argc, char**argv) {
  environment rheolef(argc, argv);
  Float error_linf_expected = (argc > 1) ? atof(argv[1]) : 1e+38;
  field uh; din >> uh;
  space Xh = uh.get_space();
  size_t d = Xh.get_geo().dimension();
  field pi_h_u = interpolate(Xh, u_exact(d));
  field eh = uh - pi_h_u;
  trial u (Xh); test v (Xh);
  form m = integrate (u*v);
  form a = integrate (dot(grad(u),grad(v)));
  dout << "error_l2   " << sqrt(m(eh,eh)) << endl
       << "error_linf " << eh.max_abs()   << endl
       << "error_h1   " << sqrt(a(eh,eh)) << endl;
  return (eh.max_abs() <= error_linf_expected) ? 0 : 1;
}
