///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
#include "rheolef/csr.h"
#include "rheolef/blas-algorithm.h"
#include "rheolef/csr-algo-amulx.h"
using namespace std;
namespace rheolef {

// ================================[ MAT-VEC PRODUCT ]===========================
template <class T>
vec<T>
operator * (const csr<T>& a, const vec<T>& x)
{
    check_amulx_length (a, x);
    vec<T> y(a.nrow(), T(0));
    csr_amux (a.ia().begin(), a.ia().end(), a.ja().begin(), a.a().begin(),
    	x.begin(), y.begin());
    return y;
}
// =====================[ INSTANCIATION IN LIBRARY ]=============================
template vec<Float> operator * (const csr<Float>&, const vec<Float>&);

} // namespace rheolef
