#include "rheolef/rheolef.h"
#include "rheolef/uzawa_abtb.h"
using namespace rheolef;
using namespace std;

Float u_upstream (const point& x) { return sqr(8.-x[0])/512.; }

int main(int argc, char**argv) {
  geo  omega (argv[1]);
  domain upstream = omega["upstream"];

  space Vh (omega, "P2", "vector");
  space Qh (omega, "P1");
  space Wh (omega, upstream, "P2");

  Vh.block("wall");
  Vh.block("upstream");
  Vh[0].block("axis");
  Vh[0].block("downstream");
  Vh[0].block("axis");
  field uh (Vh);

  uh["wall"] = 0;
  uh[0]["upstream"] = 0;
  uh[1]["upstream"] = interpolate(Wh,u_upstream);
  uh[0]["downstream"] = 0;
  uh[0]["axis"] = 0;

  field ph (Qh, 0.);
  form a (Vh, Vh, "2D_D");
  form b (Vh, Qh, "div");
  int   max_iter  = 50;
  Float tol       = 1e-12;
  Float r         = 1e+7;
  form ar = a + r*trans(b)*b;
  ssk<Float> fact = ldlt(ar.uu);
  uzawa_abtb (ar.uu, fact, b.uu, uh.u, ph.u, -(ar.ub*uh.b), -(b.ub*uh.b), r, max_iter, tol);

  cout << catchmark("u")  << uh
       << catchmark("p")  << ph;
}
