#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "embankment.icc"
int main(int argc, char**argv) {
  environment rheolef(argc, argv);
  geo  omega (argv[1]);
  space Xh = embankment_space (omega, argv[2]);
  Float lambda = (argc > 3) ? atof(argv[3]) : 1;
  size_t d = omega.dimension();
  point f (0,0,0);
  f[d-1] = -1;
  trial u (Xh); test v (Xh);
  form  a  = integrate (lambda*div(u)*div(v) + 2*ddot(D(u),D(v)));
  field lh = integrate (dot(f,v));
  solver sa (a.uu());
  field uh (Xh, 0);
  uh.set_u() = sa.solve (lh.u() - a.ub()*uh.b());
  dout << catchmark("inv_lambda") << 1/lambda << endl
       << catchmark("u")          << uh;
}
