///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// DNS: Dense format
// fortran-compatible implementation (for SPARSKIT)
// with reference counters
//
// author: Pierre.Saramito@imag.fr
//
// date: 14 january 1997
//
# include "rheolef/dns.h"
# include "rheolef/vec.h"
# include "rheolef/csr.h"
using namespace rheolef;
using namespace std;

template <class T>
const dns<T>&
csr2dns (dns<T>& a, const csr<T>& b)
{
    // first pass: set all elements to zero
    a.reset();
    
    // second pass: on non-zero elements of b
    Index i = 0;
    typename csr<T>::const_iterator iter = b.begin();
    typename csr<T>::const_iterator last = b.end();
    while (iter != last) {
        typename csr<T>::const_row::const_iterator i_row_iter = (*iter).begin();
        typename csr<T>::const_row::const_iterator i_row_last = (*iter).end();
        while (i_row_iter != i_row_last) {
	    Index j = (*i_row_iter).first;
    	    assert_macro (j >= a.ncol(), "dns(csr&): column number "<<j<<" out of range 0.."<< a.ncol());
	    a(i, j) = (*i_row_iter).second;
	    ++i_row_iter;
	}
	++iter;
    }
    return a;
}
template <class T>
dns<T>::dns (const csr<T>& a) 
    : Array<T>(a.nrow()*a.ncol())
{
    csr2dns(*this, a);
}
template <class T>
const dns<T>& 
dns<T>::operator = (const csr<T>& a) 
{
    csr2dns(*this, a);
    return *this;
}
template <class T>
Index
dns<T>::nnz () const
{
    Index nnz = 0;
    const_iterator a = Array<T>::begin(); 
    const_iterator z = Array<T>::end();
    while (a < z) if (T(*a++) != T(0)) nnz++;
    return nnz;
}
template <class T>
dns<T>
dns<T>::operator = (const T& lambda)
{
    fill(Array<T>::begin(), Array<T>::end(), lambda);
    return *this ;
}
template <class T>
istream&
operator >> (istream& s, dns<T>& a)
{	
    const Index nr = a.nrow();
    const Index nc = a.ncol();
    for (Index i = 0; s && i < nr; i++)
        for (Index j = 0; s && j < nc; j++)
	    s >> a(i,j);
    return s;
}
template <class T>
ostream&
operator << (ostream& s, const dns<T>& a)
{	
    const Index nr = a.nrow();
    const Index nc = a.ncol();
    for (Index i = 0; s && i < nr; i++) {
        for (Index j = 0; s && j < nc; j++) {
	    s << a(i,j);
	    if (s && j != nc) s << " ";
        }
        if (s) s << endl;
    }
    return s;
}
// =====================[ INSTANCIATION IN LIBRARY ]=============================
template class dns<Float>;
template istream& operator >> (istream&, dns<Float>&);
template ostream& operator << (ostream&, const dns<Float>&);

