% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_beta_ci.R
\name{betaCI}
\alias{betaCI}
\title{Obtain CIs from the sampled values}
\usage{
betaCI(betaDist, percentile = c(0.05, 0.95))
}
\arguments{
\item{betaDist}{A vector with the values sampled from the distribution}

\item{percentile}{A vector with the two percentiles that will be returned.
Defaults to 0.05 and 0.95, to give 90\% confidence intervals.}
}
\value{
A named vector with the desired percentiles.
}
\description{
Obtain CIs from the sampled values
}
\examples{
betasample <- rbeta(n=10000, 2, 2)
psiplot:::betaCI(betasample)
}
