% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WikidataQueryServiceR-package.R
\docType{package}
\name{WikidataQueryServiceR-package}
\alias{WikidataQueryServiceR-package}
\alias{_PACKAGE}
\alias{WDQS}
\title{WikidataQueryServiceR: API Client Library for 'Wikidata Query Service'}
\description{
An API client for the 'Wikidata Query Service'
    <https://query.wikidata.org/>.
}
\details{
\href{https://www.mediawiki.org/wiki/Wikidata_query_service}{Wikidata Query Service}
is maintained by the \href{https://wikimediafoundation.org/}{Wikimedia Foundation}.
}
\section{Resources}{

\itemize{
\item \href{https://www.wikidata.org/wiki/Wikidata:A_beginner-friendly_course_for_SPARQL}{A beginner-friendly course for SPARQL}
\item Building a SPARQL query: \href{https://www.wikidata.org/wiki/Help:SPARQL/Building_a_query/Museums_on_Instagram}{Museums on Instagram}
\item \href{https://www.wikidata.org/wiki/Wikidata:SPARQL_query_service/queries/examples}{SPARQL Query Examples} for WDQS
\item \href{http://programminghistorian.org/lessons/graph-databases-and-SPARQL}{Using SPARQL to access Linked Open Data}
by Matthew Lincoln
\item Interesting or illustrative \href{https://www.wikidata.org/wiki/Wikidata:SPARQL_query_service/queries}{SPARQL queries}
for Wikidata
\item Wikidata \href{https://www.wikidata.org/wiki/Wikidata:SPARQL_query_service/2016_SPARQL_Workshop}{2016 SPARQL Workshop}
\item \href{https://www.youtube.com/watch?v=1jHoUkj_mKw}{Wikidata SPARQL Query video tutorial}
by Navino Evans
\item \emph{\href{http://www.learningsparql.com/}{Learning SPARQL}} by Bob DuCharme
\item \href{https://www.mediawiki.org/wiki/Wikidata_query_service/User_Manual}{WDQS User Manual}
\item \href{https://github.com/bearloga/wmf/blob/master/presentations/talks/Cascadia\%20R\%20Conference\%202017/presentation.md#wikidata-query-service-wdqs}{Quick intro to WDQS & SPARQL}
from \href{https://github.com/bearloga/wmf/tree/master/presentations/talks/Cascadia\%20R\%20Conference\%202017}{my Cascadia R Conference 2017 talk}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/bearloga/WikidataQueryServiceR}
  \item Report bugs at \url{https://github.com/bearloga/WikidataQueryServiceR/issues}
}

}
\author{
\strong{Maintainer}: Mikhail Popov \email{mikhail@wikimedia.org} (@bearloga on Twitter)

Other contributors:
\itemize{
  \item Wikimedia Foundation [copyright holder]
}

}
\keyword{internal}
