% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim-pc-hazard.r
\name{rchaz}
\alias{rchaz}
\alias{pc.hazard}
\alias{simrchaz}
\alias{addCums}
\title{Simulation of Piecewise constant hazard model (Cox).}
\usage{
rchaz(cumhazard, rr, n = NULL, entry = NULL, cum.hazard = TRUE,
  cause = 1, extend = FALSE)
}
\arguments{
\item{cumhazard}{cumulative hazard, or piece-constant rates for periods
defined by first column of input.}

\item{rr}{number of simulations or vector of relative risk for simuations.}

\item{n}{number of simulations given as "n"}

\item{entry}{delayed entry time for simuations.}

\item{cum.hazard}{specifies wheter input is cumulative hazard or rates.}

\item{cause}{name of cause}

\item{extend}{to extend piecewise constant with constant rate. Default is average rate over time from cumulative (when TRUE), if numeric then uses given rate.}
}
\description{
Simulates data from piecwise constant baseline hazard that can also be of
Cox type. Censor data at highest value of the break points.
}
\examples{

rates <-  c(0,0.01,0.052,0.01,0.04)
breaks <- c(0,10,   20,  30,   40)
haz <- cbind(breaks,rates)
n <- 1000
X <- rbinom(n,1,0.5)
beta <- 0.2
rrcox <- exp(X * beta)
cumhaz <- cumsum(c(0,diff(breaks)*rates[-1]))
cumhaz <- cbind(breaks,cumhaz)

pctime <- rchaz(haz,n=1000,cum.hazard=FALSE)

par(mfrow=c(1,2))
ss <- aalen(Surv(time,status)~+1,data=pctime,robust=0)
plot(ss)
lines(cumhaz,col=2,lwd=2)

pctimecox <- rchaz(cumhaz,rrcox)
pctime <- cbind(pctime,X)
ssx <- cox.aalen(Surv(time,status)~+prop(X),data=pctimecox,robust=0)
plot(ssx)
lines(cumhaz,col=2,lwd=2)

### simulating data with hazard as real data 
data(TRACE)

par(mfrow=c(1,2))
ss <- cox.aalen(Surv(time,status==9)~+prop(vf),data=TRACE,robust=0)
par(mfrow=c(1,2))
plot(ss)
###
pctime <- rchaz(ss$cum,n=1000)
###
sss <- aalen(Surv(time,status)~+1,data=pctime,robust=0)
lines(sss$cum,col=2,lwd=2)

pctime <- rchaz(ss$cum,rrcox)
pctime <- cbind(pctime,X)
###
sss <- cox.aalen(Surv(time,status)~+prop(X),data=pctime,robust=0)
summary(sss)
plot(ss)
lines(sss$cum,col=3,lwd=3)

}
\author{
Thomas Scheike
}
\keyword{survival}
