% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local.R
\name{local_test_context}
\alias{local_test_context}
\alias{local_reproducible_output}
\title{Locally set options for maximal test reproducibility}
\usage{
local_test_context(.env = parent.frame())

local_reproducible_output(
  width = 80,
  crayon = FALSE,
  unicode = FALSE,
  lang = "en",
  .env = parent.frame()
)
}
\arguments{
\item{.env}{Environment to use for scoping; expert use only.}

\item{width}{Value of the \code{"width"} option.}

\item{crayon}{Value of the \code{"crayon.enabled"} option.}

\item{unicode}{Value of the \code{"cli.unicode"} option.
The test is skipped if \code{l10n_info()$`UTF-8`} is \code{FALSE}.}

\item{lang}{Optionally, supply a BCP47 language code to set the language
used for translating error messages. This is a lower case two letter
\href{https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes}{ISO 639 country code},
optionally followed by "_" or "-" and an upper case two letter
\href{https://en.wikipedia.org/wiki/ISO_3166-2}{ISO 3166 region code}.}
}
\description{
\code{local_test_context()} is run automatically by \code{test_that()} but you may
want to run it yourself if you want to replicate test results interactively.
If run inside a function, the effects are automatically reversed when the
function exits; if running in the global environment, use
\code{\link[withr:defer]{withr::deferred_run()}} to undo.

\code{local_reproducible_output()} is run automatically by \code{test_that()} in the
3rd edition. You might want to call it to override the the default settings
inside a test, if you want to test Unicode, coloured output, or a
non-standard width.
}
\details{
\code{local_test_context()} sets \code{TESTTHAT = "true"}, which ensures that
\code{\link[=is_testing]{is_testing()}} returns \code{TRUE} and allows code to tell if it is run by
testthat.

In the third edition, \code{local_test_context()} also calls
\code{local_reproducible_output()} which temporary sets the following options:
\itemize{
\item \code{cli.dynamic = FALSE} so that tests assume that they are not run in
a dynamic console (i.e. one where you can move the cursor around).
\item \code{cli.unicode} (default: \code{FALSE}) so that the cli package never generates
unicode output (normally cli uses unicode on Linux/Mac but not Windows).
Windows can't easily save unicode output to disk, so it must be set to
false for consistency.
\item \code{cli.condition_width = Inf} so that new lines introduced while
width-wrapping condition messages don't interfere with message matching.
\item \code{crayon.enabled} (default: \code{FALSE}) suppresses ANSI colours generated by
the crayon package (normally colours are used if crayon detects that you're
in a terminal that supports colour).
\item \code{cli.num_colors} (default: \code{1L}) Same as the crayon option.
\item \code{lifecycle_verbosity = "warning"} so that every lifecycle problem always
generates a warning (otherwise deprecated functions don't generate a
warning every time).
\item \code{max.print = 99999} so the same number of values are printed.
\item \code{OutDec = "."} so numbers always uses \code{.} as the decimal point
(European users sometimes set \code{OutDec = ","}).
\item \code{rlang_interactive = FALSE} so that \code{\link[rlang:is_interactive]{rlang::is_interactive()}} returns
\code{FALSE}, and code that uses it pretends you're in a non-interactive
environment.
\item \code{useFancyQuotes = FALSE} so base R functions always use regular (straight)
quotes (otherwise the default is locale dependent, see \code{\link[=sQuote]{sQuote()}} for
details).
\item \code{width} (default: 80) to control the width of printed output (usually this
varies with the size of your console).
}

And modifies the following env vars:
\itemize{
\item Unsets \code{RSTUDIO}, which ensures that RStudio is never detected as running.
\item Sets \code{LANGUAGE = "en"}, which ensures that no message translation occurs.
}

Finally, it sets the collation locale to "C", which ensures that character
sorting the same regardless of system locale.
}
\examples{
local({
  local_test_context()
  cat(crayon::blue("Text will not be colored"))
  cat(cli::symbol$ellipsis)
  cat("\n")
})
test_that("test ellipsis", {
  local_reproducible_output(unicode = FALSE)
  expect_equal(cli::symbol$ellipsis, "...")

  local_reproducible_output(unicode = TRUE)
  expect_equal(cli::symbol$ellipsis, "\u2026")
})
}
